/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.e4.migration.MementoReader;

public class InfoReader
extends MementoReader {
    private List<PageReader> pages;
    private IMemento memFolder;

    InfoReader(IMemento memento) {
        super(memento);
    }

    String getId() {
        return this.getString("part");
    }

    boolean isRelativelyPositioned() {
        return this.contains("ratio");
    }

    boolean isFolder() {
        return this.getBoolean("folder");
    }

    boolean isEditorArea() {
        String id = this.getId();
        return "org.eclipse.ui.editorss".equals(id);
    }

    private IMemento getFolder() {
        if (this.memFolder == null) {
            this.memFolder = this.memento.getChild("folder");
        }
        return this.memFolder;
    }

    int[] getPartOrder() {
        IMemento folder = this.getFolder();
        if (folder == null) {
            return null;
        }
        IMemento presentation = folder.getChild("presentation");
        if (presentation == null) {
            return null;
        }
        IMemento[] partPositions = presentation.getChildren("part");
        int[] partOrder = new int[partPositions.length];
        int i = 0;
        while (i < partPositions.length) {
            partOrder[i] = partPositions[i].getInteger("id");
            ++i;
        }
        return partOrder;
    }

    List<PageReader> getPages() {
        if (this.pages != null) {
            return this.pages;
        }
        IMemento folder = this.getFolder();
        if (folder != null) {
            IMemento[] pageMems = folder.getChildren("page");
            this.pages = new ArrayList<PageReader>(pageMems.length);
            IMemento[] iMementoArray = pageMems;
            int n = pageMems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento pageMem = iMementoArray[n2];
                this.pages.add(new PageReader(pageMem));
                ++n2;
            }
        }
        return this.pages;
    }

    String getActivePageId() {
        String activePageId = null;
        IMemento folder = this.getFolder();
        if (folder != null) {
            activePageId = folder.getString("activePageID");
        }
        return activePageId;
    }

    float getRatio() {
        return this.getFloat("ratio").floatValue();
    }

    int getRelationship() {
        return this.getInteger("relationship");
    }

    String getRelative() {
        return this.getString("relative");
    }

    public PartState getState() {
        PartState state = PartState.RESTORED;
        IMemento folder = this.getFolder();
        int value = folder.getInteger("expanded");
        switch (value) {
            case 0: {
                state = PartState.MINIMIZED;
                break;
            }
            case 1: {
                state = PartState.MAXIMIZED;
            }
        }
        return state;
    }

    static class PageReader
    extends MementoReader {
        PageReader(IMemento pageMemento) {
            super(pageMemento);
        }

        String getId() {
            return this.getString("content");
        }
    }

    public static enum PartState {
        MINIMIZED,
        MAXIMIZED,
        RESTORED;

    }
}

