/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.PerspectiveTagger;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayoutUtils;
import org.eclipse.ui.internal.e4.migration.InfoReader;
import org.eclipse.ui.internal.e4.migration.PerspectiveReader;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveBuilder {
    static final String ORIGINAL_ID = "originalId";
    static final String BASE_PERSPECTIVE_ID = "basePerspectiveId";
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    @Inject
    private PerspectiveReader perspReader;
    @Inject
    private EModelService modelService;
    private MPerspective perspective;
    private List<String> tags;
    private List<String> renderedViews;
    private Map<String, MPlaceholder> viewPlaceholders = new HashMap<String, MPlaceholder>();
    private Map<String, PerspectiveReader.ViewLayoutReader> viewLayouts;
    private MPlaceholder editorAreaPlaceholder;
    private ModeledPageLayoutUtils layoutUtils;

    @PostConstruct
    private void postConstruct() {
        this.layoutUtils = new ModeledPageLayoutUtils(this.modelService);
    }

    public MPerspective createPerspective() {
        this.create();
        this.tags = this.perspective.getTags();
        this.populate();
        return this.perspective;
    }

    private void create() {
        this.perspective = (MPerspective)this.modelService.createModelElement(MPerspective.class);
        this.perspective.setElementId(this.perspReader.getId());
        String label = this.perspReader.getLabel();
        this.perspective.setLabel(label);
        this.perspective.setTooltip(label);
        if (this.perspReader.isCustom()) {
            this.perspective.getTransientData().put(BASE_PERSPECTIVE_ID, this.perspReader.getBasicPerspectiveId());
            this.perspective.getTransientData().put(ORIGINAL_ID, this.perspReader.getOriginalId());
        }
    }

    private void populate() {
        this.addActionSetTags();
        this.addPerspectiveShortcutTags();
        this.addNewWizardTags();
        this.addShowViewTags();
        this.addHiddenItems();
        this.addShowInTags();
        for (InfoReader info : this.perspReader.getInfos()) {
            if (info.isEditorArea()) {
                this.addEditorArea(info);
                continue;
            }
            if (!info.isFolder()) continue;
            MPartStack stack = this.addPartStack(info);
            this.populatePartStack(stack, info);
        }
        this.setZoomState();
        this.addDetachedWindows();
        this.hideEmptyStacks();
        this.hideUrenderableSashes();
        this.hideInvisibleSashes();
        this.processStandaloneViews();
        this.correctSelectedElements();
        this.addTrimBars();
        PerspectiveTagger.tagPerspective(this.perspective, this.modelService);
    }

    private void processStandaloneViews() {
        Map<String, PerspectiveReader.ViewLayoutReader> viewLayouts = this.perspReader.getViewLayouts();
        for (String viewId : viewLayouts.keySet()) {
            MPlaceholder placeholder = this.viewPlaceholders.get(viewId);
            if (placeholder == null || !viewLayouts.get(viewId).isStandalone()) continue;
            MElementContainer parent = placeholder.getParent();
            placeholder.setContainerData(parent.getContainerData());
            parent.getChildren().remove(placeholder);
            MElementContainer grandParent = parent.getParent();
            int location = grandParent.getChildren().indexOf(parent);
            grandParent.getChildren().add(location, placeholder);
            grandParent.getChildren().remove(parent);
        }
    }

    private void addDetachedWindows() {
        for (PerspectiveReader.DetachedWindowReader detachedWindowReader : this.perspReader.getDetachedWindows()) {
            MTrimmedWindow detachedWindow = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
            Rectangle bounds = detachedWindowReader.getBounds();
            detachedWindow.setX(bounds.x);
            detachedWindow.setY(bounds.y);
            detachedWindow.setWidth(bounds.width);
            detachedWindow.setHeight(bounds.height);
            MPartStack stack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
            this.populatePartStack(stack, detachedWindowReader);
            detachedWindow.getChildren().add(stack);
            this.perspective.getWindows().add(detachedWindow);
        }
    }

    private void addTrimBars() {
        Map<String, Integer> fastViewBars = this.perspReader.getFastViewBars();
        if (fastViewBars.size() == 0) {
            return;
        }
        int topCounter = 0;
        int bottomCounter = 0;
        int rightCounter = 0;
        int leftCounter = 0;
        StringBuilder sb = new StringBuilder();
        for (InfoReader folder : this.perspReader.getInfos()) {
            String folderId = folder.getId();
            if (!fastViewBars.containsKey(folderId)) continue;
            sb.append(folderId).append(' ');
            Integer side = fastViewBars.get(folderId);
            if (side == null) {
                side = 16384;
            }
            switch (side) {
                case 128: {
                    sb.append(0).append(' ').append(topCounter++);
                    break;
                }
                case 1024: {
                    sb.append(1).append(' ').append(bottomCounter++);
                    break;
                }
                case 131072: {
                    sb.append(3).append(' ').append(rightCounter++);
                    break;
                }
                default: {
                    sb.append(2).append(' ').append(leftCounter++);
                }
            }
            sb.append('#');
        }
        this.perspective.getPersistedState().put("trims", sb.toString());
    }

    private void hideEmptyStacks() {
        for (MPartStack stack : this.modelService.findElements((MUIElement)this.perspective, null, MPartStack.class, null)) {
            if (ID_EDITOR_AREA.equals(stack.getElementId()) || ID_EDITOR_AREA.equals(stack.getParent().getElementId()) || this.hasRenderableContent(stack)) continue;
            stack.setToBeRendered(false);
        }
    }

    private void setZoomState() {
        boolean isAnythingMaximized;
        List stacks = this.modelService.findElements((MUIElement)this.perspective, null, MPartStack.class, null);
        boolean bl = isAnythingMaximized = this.isMaximized((MUIElement)this.editorAreaPlaceholder) || this.isAnyMaximized(stacks);
        if (isAnythingMaximized) {
            this.markMinimizedByZoom((MUIElement)this.editorAreaPlaceholder);
            for (MPartStack stack : stacks) {
                this.markMinimizedByZoom((MUIElement)stack);
            }
        }
    }

    private void markMinimizedByZoom(MUIElement element) {
        List tags = element.getTags();
        if (tags.contains("Minimized")) {
            tags.add("MinimizedByZoom");
        }
    }

    private boolean isAnyMaximized(List<MPartStack> stacks) {
        for (MPartStack stack : stacks) {
            if (!this.isMaximized((MUIElement)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isMaximized(MUIElement element) {
        return element.getTags().contains("Maximized");
    }

    private void hideUrenderableSashes() {
        for (MPartSashContainer sash : this.modelService.findElements((MUIElement)this.perspective, null, MPartSashContainer.class, null)) {
            this.hideUnrenderableSash((MElementContainer<?>)sash);
        }
    }

    private void hideInvisibleSashes() {
        for (MPartSashContainer sash : this.modelService.findElements((MUIElement)this.perspective, null, MPartSashContainer.class, null)) {
            this.hideInvisibleSash((MElementContainer<?>)sash);
        }
    }

    private void hideInvisibleSash(MElementContainer<?> container) {
        if (container instanceof MPartSashContainer && container != this.perspective && !this.hasVisibleContent((MPartSashContainer)container)) {
            container.setVisible(false);
            this.hideInvisibleSash(container.getParent());
        }
    }

    private boolean hasVisibleContent(MPartSashContainer sash) {
        for (MPartSashContainerElement child : sash.getChildren()) {
            if (!child.isVisible()) continue;
            return true;
        }
        return false;
    }

    private void hideUnrenderableSash(MElementContainer<?> container) {
        if (container instanceof MPartSashContainer && container != this.perspective && this.modelService.countRenderableChildren(container) == 0) {
            container.setToBeRendered(false);
            this.hideUnrenderableSash(container.getParent());
        }
    }

    private boolean hasRenderableContent(MPartStack stack) {
        for (MStackElement child : stack.getChildren()) {
            if (!child.isVisible() || !child.isToBeRendered()) continue;
            return true;
        }
        return false;
    }

    private void correctSelectedElements() {
        List perspChildren = this.perspective.getChildren();
        if (this.perspective.getSelectedElement() == null && !perspChildren.isEmpty()) {
            for (MPartSashContainerElement child : perspChildren) {
                if (!child.isToBeRendered()) continue;
                this.perspective.setSelectedElement((MUIElement)child);
                break;
            }
        }
        for (MPartSashContainerElement child : perspChildren) {
            this.correctSelectedElements((MUIElement)child);
        }
    }

    private void correctSelectedElements(MUIElement element) {
        MUIElement firstRenderableElement;
        if (!(element instanceof MPartSashContainer) && !(element instanceof MPartStack)) {
            return;
        }
        MElementContainer container = (MElementContainer)element;
        List children = container.getChildren();
        if (container.getSelectedElement() == null && !children.isEmpty() && (firstRenderableElement = this.getFirstRenderableElement(children)) != null) {
            container.setSelectedElement(firstRenderableElement);
        }
        for (MUIElement child : children) {
            this.correctSelectedElements(child);
        }
    }

    private MUIElement getFirstRenderableElement(List<MUIElement> elements) {
        for (MUIElement element : elements) {
            if (!element.isToBeRendered()) continue;
            return element;
        }
        return null;
    }

    private void addToPerspective(MPartSashContainerElement element, InfoReader info) {
        if (info.isRelativelyPositioned()) {
            this.insert((MUIElement)element, info);
        } else {
            this.perspective.getChildren().add(element);
        }
    }

    private void addEditorArea(InfoReader info) {
        this.editorAreaPlaceholder = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        this.editorAreaPlaceholder.setElementId(ID_EDITOR_AREA);
        this.editorAreaPlaceholder.setToBeRendered(this.perspReader.isEditorAreaVisible());
        this.setPartState((MUIElement)this.editorAreaPlaceholder, this.perspReader.getEditorAreaState());
        this.addToPerspective((MPartSashContainerElement)this.editorAreaPlaceholder, info);
    }

    private MPartStack addPartStack(InfoReader info) {
        MPartStack stack = this.createPartStack(info);
        if (info.isRelativelyPositioned()) {
            String refElementId = info.getRelative();
            MUIElement refElement = this.modelService.find(refElementId, (MUIElement)this.perspective);
            MElementContainer parent = refElement.getParent();
            if (parent instanceof MPartStack) {
                refElement = parent;
            }
            this.insert((MUIElement)stack, refElement, info);
        } else {
            this.perspective.getChildren().add(stack);
        }
        this.setPartState((MUIElement)stack, info.getState());
        return stack;
    }

    private void setPartState(MUIElement element, InfoReader.PartState state) {
        List tags = element.getTags();
        switch (state) {
            case MINIMIZED: {
                tags.add("Minimized");
                element.setVisible(false);
                break;
            }
            case MAXIMIZED: {
                tags.add("Maximized");
                break;
            }
        }
    }

    private void insert(MUIElement element, MUIElement refElement, InfoReader info) {
        this.layoutUtils.insert(element, refElement, this.layoutUtils.plRelToSwt(info.getRelationship()), info.getRatio());
    }

    private void insert(MUIElement element, InfoReader info) {
        this.insert(element, this.modelService.find(info.getRelative(), (MUIElement)this.perspective), info);
    }

    private MPartStack createPartStack(InfoReader info) {
        String stackId = info.getId();
        if (stackId != null && stackId.equals("stickyFolderRight")) {
            stackId = "legacyStickyFolderRight";
        }
        return this.layoutUtils.createStack(stackId, true);
    }

    private void populatePartStack(MPartStack stack, InfoReader info) {
        for (InfoReader.PageReader page : info.getPages()) {
            this.addPlaceholderToStack(stack, page.getId());
        }
        MStackElement selectedElement = (MStackElement)this.modelService.find(info.getActivePageId(), (MUIElement)stack);
        if (selectedElement != null) {
            selectedElement.setToBeRendered(true);
            selectedElement.setVisible(true);
        }
        stack.setSelectedElement((MUIElement)selectedElement);
        List<MStackElement> renderedViews = this.getRenderedViews(stack);
        if (renderedViews.size() < 2) {
            return;
        }
        int[] partOrder = info.getPartOrder();
        List stackChildren = stack.getChildren();
        if (partOrder == null || partOrder.length != renderedViews.size()) {
            return;
        }
        ArrayList<MStackElement> originalOrder = new ArrayList<MStackElement>(renderedViews);
        stackChildren.clear();
        int i = 0;
        while (i < partOrder.length) {
            stackChildren.add((MStackElement)originalOrder.get(partOrder[i]));
            ++i;
        }
        originalOrder.removeAll(stackChildren);
        stackChildren.addAll(originalOrder);
    }

    private List<MStackElement> getRenderedViews(MPartStack stack) {
        ArrayList<MStackElement> renderedViews = new ArrayList<MStackElement>();
        for (MStackElement element : stack.getChildren()) {
            if (!element.isToBeRendered()) continue;
            renderedViews.add(element);
        }
        return renderedViews;
    }

    private void populatePartStack(MPartStack stack, PerspectiveReader.DetachedWindowReader info) {
        for (InfoReader.PageReader page : info.getPages()) {
            this.addPlaceholderToStack(stack, page.getId());
        }
        stack.setSelectedElement((MUIElement)((MStackElement)this.modelService.find(info.getActivePageId(), (MUIElement)stack)));
    }

    private void addPlaceholderToStack(MPartStack stack, String partId) {
        MPlaceholder placeholder = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholder.setElementId(partId);
        if (!this.isToBeRendered(placeholder)) {
            placeholder.setToBeRendered(false);
        }
        this.addLayoutTagsToPlaceholder(placeholder, partId);
        stack.getChildren().add(placeholder);
        this.viewPlaceholders.put(partId, placeholder);
    }

    private void addLayoutTagsToPlaceholder(MPlaceholder placeholder, String partId) {
        PerspectiveReader.ViewLayoutReader viewLayout = this.getViewLayout(partId);
        if (viewLayout == null) {
            return;
        }
        List tags = placeholder.getTags();
        if (!viewLayout.isCloseable()) {
            tags.add("NoClose");
        }
        if (viewLayout.isStandalone()) {
            tags.add("Standalone");
        }
    }

    private boolean isToBeRendered(MPlaceholder placeholder) {
        if (this.renderedViews == null) {
            this.renderedViews = this.perspReader.getRenderedViewIds();
        }
        return this.renderedViews.contains(placeholder.getElementId());
    }

    private void addPerspectiveShortcutTags() {
        for (String shortcutId : this.perspReader.getPerspectiveShortcutIds()) {
            this.tags.add("persp.perspSC:" + shortcutId);
        }
    }

    private void addActionSetTags() {
        for (String actionSetId : this.perspReader.getActionSetIds()) {
            this.tags.add("persp.actionSet:" + actionSetId);
        }
    }

    private void addShowInTags() {
        String origId = null;
        origId = this.perspReader.isCustom() ? this.perspReader.getBasicPerspectiveId() : this.perspReader.getId();
        ArrayList<String> list = PerspectiveBuilder.getShowInPartFromRegistry(origId);
        if (list != null) {
            for (String showIn : list) {
                this.tags.add("persp.showIn:" + showIn);
            }
        }
    }

    public static ArrayList<String> getShowInPartFromRegistry(String targetId) {
        ArrayList<String> list = new ArrayList<String>();
        IExtension[] extensions = PerspectiveBuilder.getPerspectiveExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                list.addAll(PerspectiveBuilder.getExtensionShowInPartFromRegistry(extensions[i], targetId));
                ++i;
            }
        }
        return list;
    }

    private static IExtension[] getPerspectiveExtensions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "perspectiveExtensions");
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        extensions = RegistryReader.orderExtensions(extensions);
        return extensions;
    }

    private static ArrayList<String> getExtensionShowInPartFromRegistry(IExtension extension, String targetId) {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String id;
            String type = configElements[j].getName();
            if (type.equals("perspectiveExtension") && (targetId.equals(id = configElements[j].getAttribute("targetID")) || "*".equals(id))) {
                list.addAll(PerspectiveBuilder.getConfigElementShowInPartsFromRegistry(configElements[j]));
            }
            ++j;
        }
        return list;
    }

    private static ArrayList<String> getConfigElementShowInPartsFromRegistry(IConfigurationElement configElement) {
        ArrayList<String> list = new ArrayList<String>();
        String tag = "showInPart";
        IConfigurationElement[] children = configElement.getChildren();
        int nX = 0;
        while (nX < children.length) {
            String tid;
            IConfigurationElement child = children[nX];
            String ctype = child.getName();
            if (tag.equals(ctype) && (tid = child.getAttribute("id")) != null) {
                list.add(tid);
            }
            ++nX;
        }
        return list;
    }

    private void addNewWizardTags() {
        for (String actionId : this.perspReader.getNewWizardActionIds()) {
            this.tags.add("persp.newWizSC:" + actionId);
        }
    }

    private void addShowViewTags() {
        for (String actionId : this.perspReader.getShowViewActionIds()) {
            this.tags.add("persp.viewSC:" + actionId);
        }
    }

    private void addHiddenItems() {
        String comma = ",";
        StringBuilder persistedValue = new StringBuilder();
        for (String elementId : this.perspReader.getHiddenMenuItemIds()) {
            persistedValue.append("persp.hideMenuSC:");
            persistedValue.append(elementId).append(comma);
        }
        for (String elementId : this.perspReader.getHiddenToolbarItemIds()) {
            persistedValue.append("persp.hideToolbarSC:");
            persistedValue.append(elementId).append(comma);
        }
        this.perspective.getPersistedState().put("persp.hiddenItems", persistedValue.toString());
    }

    private PerspectiveReader.ViewLayoutReader getViewLayout(String viewId) {
        if (this.viewLayouts == null) {
            this.viewLayouts = this.perspReader.getViewLayouts();
        }
        return this.viewLayouts.get(viewId);
    }

    Collection<MPlaceholder> getPlaceholders() {
        return this.viewPlaceholders.values();
    }

    MPlaceholder getEditorAreaPlaceholder() {
        return this.editorAreaPlaceholder;
    }
}

