/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.e4.migration.InfoReader;
import org.eclipse.ui.internal.e4.migration.MementoReader;

public class PerspectiveReader
extends MementoReader {
    private DescriptorReader descriptor;

    public PerspectiveReader(IMemento memento) {
        super(memento);
    }

    String getId() {
        return this.getDescriptor().getId();
    }

    String getLabel() {
        return this.getDescriptor().getLabel();
    }

    private DescriptorReader getDescriptor() {
        if (this.descriptor == null) {
            IMemento desriptorMem = this.getChild("descriptor");
            if (desriptorMem == null) {
                throw new NullPointerException("Perspective descriptor not found");
            }
            this.descriptor = new DescriptorReader(desriptorMem);
        }
        return this.descriptor;
    }

    List<InfoReader> getInfos() {
        IMemento[] infoMems = this.getInfoMems();
        ArrayList<InfoReader> infos = new ArrayList<InfoReader>(infoMems.length);
        IMemento[] iMementoArray = infoMems;
        int n = infoMems.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento infoMem = iMementoArray[n2];
            infos.add(new InfoReader(infoMem));
            ++n2;
        }
        return infos;
    }

    private IMemento[] getInfoMems() {
        IMemento mainWindow;
        IMemento[] infoMems = null;
        IMemento layout = this.getLayout();
        if (layout != null && (mainWindow = layout.getChild("mainWindow")) != null) {
            infoMems = mainWindow.getChildren("info");
        }
        if (infoMems == null) {
            infoMems = new IMemento[]{};
        }
        return infoMems;
    }

    Map<String, ViewLayoutReader> getViewLayouts() {
        IMemento[] viewLayoutMems = this.getChildren("viewLayoutRec");
        HashMap<String, ViewLayoutReader> viewLayouts = new HashMap<String, ViewLayoutReader>(viewLayoutMems.length);
        IMemento[] iMementoArray = viewLayoutMems;
        int n = viewLayoutMems.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            ViewLayoutReader viewLayout = new ViewLayoutReader(memento);
            viewLayouts.put(viewLayout.getViewId(), viewLayout);
            ++n2;
        }
        return viewLayouts;
    }

    private IMemento getLayout() {
        return this.getChild("layout");
    }

    List<String> getPerspectiveShortcutIds() {
        return this.getChildrenIds("perspective_action");
    }

    List<String> getActionSetIds() {
        return this.getChildrenIds("alwaysOnActionSet");
    }

    List<String> getShowViewActionIds() {
        return this.getChildrenIds("show_view_action");
    }

    List<String> getNewWizardActionIds() {
        return this.getChildrenIds("new_wizard_action");
    }

    List<String> getRenderedViewIds() {
        List<String> viewIds = this.getChildrenIds("view");
        viewIds.addAll(this.getFastViewIds());
        return viewIds;
    }

    Map<String, Integer> getFastViewBars() {
        HashMap<String, Integer> bars = new HashMap<String, Integer>();
        IMemento[] iMementoArray = this.getFastViewBarMems();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento bar = iMementoArray[n2];
            bars.put(bar.getString("id"), bar.getInteger("fastViewLocation"));
            ++n2;
        }
        return bars;
    }

    private List<String> getFastViewIds() {
        IMemento[] fastViewBarArr;
        int n;
        ArrayList<String> fastViewIds = new ArrayList<String>();
        IMemento fastViews = this.getChild("fastViews");
        if (fastViews != null) {
            IMemento[] iMementoArray = fastViews.getChildren("view");
            n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento view = iMementoArray[n2];
                fastViewIds.add(view.getString("id"));
                ++n2;
            }
        }
        IMemento[] iMementoArray = fastViewBarArr = this.getFastViewBarMems();
        int n3 = fastViewBarArr.length;
        n = 0;
        while (n < n3) {
            IMemento fastViewBar = iMementoArray[n];
            IMemento fastViewsInBar = fastViewBar.getChild("fastViews");
            if (fastViewsInBar != null) {
                IMemento[] iMementoArray2 = fastViewsInBar.getChildren("view");
                int n4 = iMementoArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    IMemento view = iMementoArray2[n5];
                    fastViewIds.add(view.getString("id"));
                    ++n5;
                }
            }
            ++n;
        }
        return fastViewIds;
    }

    private IMemento[] getFastViewBarMems() {
        IMemento[] emptyArr = new IMemento[]{};
        IMemento fastViewBars = this.getChild("fastViewBars");
        if (fastViewBars == null) {
            return emptyArr;
        }
        IMemento[] fastViewBarArr = fastViewBars.getChildren("fastViewBar");
        return fastViewBarArr == null ? emptyArr : fastViewBarArr;
    }

    List<String> getHiddenMenuItemIds() {
        return this.getChildrenIds("hide_menu_item_id");
    }

    List<String> getHiddenToolbarItemIds() {
        return this.getChildrenIds("hide_toolbar_item_id");
    }

    private List<String> getChildrenIds(String tag) {
        IMemento[] idMemArr = this.getChildren(tag);
        ArrayList<String> idList = new ArrayList<String>(idMemArr.length);
        IMemento[] iMementoArray = idMemArr;
        int n = idMemArr.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento idMem = iMementoArray[n2];
            idList.add(idMem.getString("id"));
            ++n2;
        }
        return idList;
    }

    List<DetachedWindowReader> getDetachedWindows() {
        ArrayList<DetachedWindowReader> readers = new ArrayList<DetachedWindowReader>();
        IMemento layout = this.getLayout();
        if (layout != null) {
            IMemento[] mems;
            IMemento[] iMementoArray = mems = layout.getChildren("detachedWindow");
            int n = mems.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mem = iMementoArray[n2];
                readers.add(new DetachedWindowReader(mem));
                ++n2;
            }
        }
        return readers;
    }

    boolean isCustom() {
        return this.getDescriptor().isCustom();
    }

    String getBasicPerspectiveId() {
        return this.getDescriptor().getBasicPerspectiveId();
    }

    String getOriginalId() {
        return this.getDescriptor().getOriginalId();
    }

    boolean isEditorAreaVisible() {
        return Integer.valueOf(1).equals(this.getInteger("editorAreaVisible"));
    }

    InfoReader.PartState getEditorAreaState() {
        InfoReader.PartState state = InfoReader.PartState.RESTORED;
        int value = this.getInteger("editorAreaTrimState");
        switch (value) {
            case 0: 
            case 4: {
                state = InfoReader.PartState.MINIMIZED;
                break;
            }
            case 1: {
                state = InfoReader.PartState.MAXIMIZED;
            }
        }
        return state;
    }

    private static class DescriptorReader
    extends MementoReader {
        private static final String TAG_DESCRIPTOR = "descriptor";

        DescriptorReader(IMemento memento) {
            super(memento);
        }

        String getId() {
            String id = this.getOriginalId();
            if (this.isCustom()) {
                id = String.valueOf(this.getBasicPerspectiveId()) + "." + id;
            }
            return id;
        }

        String getOriginalId() {
            String id = this.getString("id");
            if (id == null) {
                throw new NullPointerException("Perspective ID not found");
            }
            return id;
        }

        boolean isCustom() {
            return this.contains(TAG_DESCRIPTOR);
        }

        String getBasicPerspectiveId() {
            String id = this.getString(TAG_DESCRIPTOR);
            if (id == null) {
                throw new NullPointerException("Basic perspective ID not found");
            }
            return id;
        }

        String getLabel() {
            return this.getString("label");
        }
    }

    static class DetachedWindowReader
    extends MementoReader {
        private DetachedWindowReader(IMemento memento) {
            super(memento);
        }

        Rectangle getBounds() {
            Rectangle windowBounds = new Rectangle(0, 0, 0, 0);
            Integer bigInt = this.getInteger("x");
            windowBounds.x = bigInt == null ? 0 : bigInt;
            bigInt = this.getInteger("y");
            windowBounds.y = bigInt == null ? 0 : bigInt;
            bigInt = this.getInteger("width");
            windowBounds.width = bigInt == null ? 0 : bigInt;
            bigInt = this.getInteger("height");
            windowBounds.height = bigInt == null ? 0 : bigInt;
            return windowBounds;
        }

        String getActivePageId() {
            String activePageId = null;
            IMemento folder = this.getFolder();
            if (folder != null) {
                activePageId = folder.getString("activePageID");
            }
            return activePageId;
        }

        List<InfoReader.PageReader> getPages() {
            IMemento folder = this.getFolder();
            ArrayList<InfoReader.PageReader> pages = new ArrayList<InfoReader.PageReader>();
            if (folder != null) {
                IMemento[] pageMems;
                IMemento[] iMementoArray = pageMems = folder.getChildren("page");
                int n = pageMems.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento pageMem = iMementoArray[n2];
                    pages.add(new InfoReader.PageReader(pageMem));
                    ++n2;
                }
            }
            return pages;
        }

        private IMemento getFolder() {
            return this.getChild("folder");
        }
    }

    static class ViewLayoutReader
    extends MementoReader {
        private ViewLayoutReader(IMemento memento) {
            super(memento);
        }

        String getViewId() {
            return this.getString("id");
        }

        boolean isCloseable() {
            return this.getBoolean("closeable", true);
        }

        boolean isStandalone() {
            return this.getBoolean("standalone");
        }
    }
}

