/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.ColorUtil;

public abstract class QuickAccessContents {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private static final int INITIAL_COUNT_PER_PROVIDER = 5;
    private static final int MAX_COUNT_TOTAL = 20;
    protected Text filterText;
    private QuickAccessProvider[] providers;
    protected Table table;
    protected Label infoLabel;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected String rememberedText;
    private Color grayColor;
    private TextLayout textLayout;
    private boolean showAllMatches = false;
    protected boolean resized = false;
    private TriggerSequence keySequence;

    public QuickAccessContents(QuickAccessProvider[] providers) {
        this.providers = providers;
    }

    private int computeNumberOfItems() {
        Rectangle rect = this.table.getClientArea();
        int itemHeight = this.table.getItemHeight();
        int headerHeight = this.table.getHeaderHeight();
        return (rect.height - headerHeight + itemHeight - 1) / (itemHeight + this.table.getGridLineWidth());
    }

    public void refresh(String filter) {
        if (this.table != null) {
            boolean filterTextEmpty = filter.length() == 0;
            QuickAccessElement perfectMatch = this.getPerfectMatch(filter);
            List<QuickAccessEntry>[] entries = this.computeMatchingEntries(filter, perfectMatch);
            int selectionIndex = this.refreshTable(perfectMatch, entries);
            if (this.table.getItemCount() > 0) {
                this.table.setSelection(selectionIndex);
            } else if (filterTextEmpty) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, QuickAccessMessages.QuickAccessContents_QuickAccess);
                item.setText(1, QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
                item.setForeground(1, this.grayColor);
            } else {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, QuickAccessMessages.QuickAccessContents_NoMatchingResults);
                item.setForeground(0, this.grayColor);
            }
            this.updateFeedback(filterTextEmpty, this.showAllMatches);
        }
    }

    protected abstract QuickAccessElement getPerfectMatch(String var1);

    protected abstract void updateFeedback(boolean var1, boolean var2);

    public void setShowAllMatches(boolean showAll) {
        if (this.showAllMatches != showAll) {
            this.showAllMatches = showAll;
            this.updateInfoLabel();
            this.refresh(this.filterText.getText().toLowerCase());
        }
    }

    private void updateInfoLabel() {
        if (this.infoLabel != null) {
            TriggerSequence sequence = this.getTriggerSequence();
            if (sequence == null) {
                this.infoLabel.setText("");
            } else if (this.showAllMatches) {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.QuickAccessContents_PressKeyToLimitResults, (Object)sequence.format()));
            } else {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowAllMatches, (Object)sequence.format()));
            }
            this.infoLabel.getParent().layout(true);
        }
    }

    public TriggerSequence getTriggerSequence() {
        if (this.keySequence == null) {
            IBindingService bindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
            this.keySequence = bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        }
        return this.keySequence;
    }

    public boolean getShowAllMatches() {
        return this.showAllMatches;
    }

    private int refreshTable(QuickAccessElement perfectMatch, List<QuickAccessEntry>[] entries) {
        if (this.table.getItemCount() > entries.length && this.table.getItemCount() - entries.length > 20) {
            this.table.removeAll();
        }
        TableItem[] items = this.table.getItems();
        int selectionIndex = -1;
        int index = 0;
        int i = 0;
        while (i < this.providers.length) {
            if (entries[i] != null) {
                boolean firstEntry = true;
                Iterator<QuickAccessEntry> it = entries[i].iterator();
                while (it.hasNext()) {
                    TableItem item;
                    QuickAccessEntry entry = it.next();
                    entry.firstInCategory = firstEntry;
                    firstEntry = false;
                    if (!it.hasNext()) {
                        entry.lastInCategory = true;
                    }
                    if (index < items.length) {
                        item = items[index];
                        this.table.clear(index);
                    } else {
                        item = new TableItem(this.table, 0);
                    }
                    if (perfectMatch == entry.element && selectionIndex == -1) {
                        selectionIndex = index;
                    }
                    item.setData((Object)entry);
                    item.setText(0, entry.provider.getName());
                    item.setText(1, entry.element.getLabel());
                    if (Util.isWpf()) {
                        item.setImage(1, entry.getImage(entry.element, (ResourceManager)this.resourceManager));
                    }
                    ++index;
                }
            }
            ++i;
        }
        if (index < items.length) {
            this.table.remove(index, items.length - 1);
        }
        if (selectionIndex == -1) {
            selectionIndex = 0;
        }
        return selectionIndex;
    }

    private List<QuickAccessEntry>[] computeMatchingEntries(String filter, QuickAccessElement perfectMatch) {
        QuickAccessEntry entry;
        boolean done;
        List[] entries = new List[this.providers.length];
        int maxCount = this.computeNumberOfItems();
        int[] indexPerProvider = new int[this.providers.length];
        int countPerProvider = Math.min(maxCount / 4, 5);
        int countTotal = 0;
        boolean perfectMatchAdded = true;
        if (perfectMatch != null) {
            --maxCount;
            perfectMatchAdded = false;
        }
        do {
            done = true;
            int i = 0;
            while (i < this.providers.length && (this.showAllMatches || countTotal < maxCount)) {
                if (entries[i] == null) {
                    entries[i] = new ArrayList();
                    indexPerProvider[i] = 0;
                }
                int count = 0;
                QuickAccessProvider provider = this.providers[i];
                if (filter.length() > 0 || provider.isAlwaysPresent() || this.showAllMatches) {
                    QuickAccessElement[] sortedElements = provider.getElementsSorted();
                    ArrayList<QuickAccessEntry> poorFilterMatches = new ArrayList<QuickAccessEntry>();
                    int j = indexPerProvider[i];
                    while (j < sortedElements.length && (this.showAllMatches || count < countPerProvider && countTotal < maxCount)) {
                        QuickAccessElement element = sortedElements[j];
                        QuickAccessEntry entry2 = null;
                        if (filter.length() == 0) {
                            entry2 = i == 0 || this.showAllMatches ? new QuickAccessEntry(element, provider, new int[0][0], new int[0][0], 0) : null;
                        } else {
                            QuickAccessEntry possibleMatch = element.match(filter, provider);
                            if (possibleMatch != null) {
                                if (possibleMatch.getMatchQuality() <= 5) {
                                    entry2 = possibleMatch;
                                } else {
                                    poorFilterMatches.add(possibleMatch);
                                }
                            }
                        }
                        if (this.entryEnabled(provider, entry2)) {
                            entries[i].add(entry2);
                            ++count;
                            ++countTotal;
                            if (i == 0 && entry2.element == perfectMatch) {
                                perfectMatchAdded = true;
                                maxCount = 20;
                            }
                        }
                        ++j;
                    }
                    indexPerProvider[i] = j;
                    Iterator iterator = poorFilterMatches.iterator();
                    while (iterator.hasNext() && (this.showAllMatches || count < countPerProvider && countTotal < maxCount)) {
                        QuickAccessEntry quickAccessEntry = (QuickAccessEntry)iterator.next();
                        entries[i].add(quickAccessEntry);
                        ++count;
                        ++countTotal;
                        if (i != 0 || quickAccessEntry.element != perfectMatch) continue;
                        perfectMatchAdded = true;
                        maxCount = 20;
                    }
                    if (j < sortedElements.length) {
                        done = false;
                    }
                }
                ++i;
            }
            countPerProvider = 1;
        } while ((this.showAllMatches || countTotal < maxCount) && !done);
        if (!perfectMatchAdded && this.entryEnabled(this.providers[0], entry = perfectMatch.match(filter, this.providers[0]))) {
            if (entries[0] == null) {
                entries[0] = new ArrayList();
                indexPerProvider[0] = 0;
            }
            entries[0].add(entry);
        }
        return entries;
    }

    private boolean entryEnabled(QuickAccessProvider provider, QuickAccessEntry entry) {
        if (entry == null) {
            return false;
        }
        if (provider instanceof PreviousPicksProvider) {
            QuickAccessElement element = entry.element;
            QuickAccessProvider originalProvider = element.getProvider();
            QuickAccessElement match = originalProvider.getElementForId(element.getId());
            return match != null;
        }
        return true;
    }

    private void doDispose() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    protected abstract void handleElementSelected(String var1, Object var2);

    private void handleSelection() {
        QuickAccessElement selectedElement = null;
        String text = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1) {
            QuickAccessEntry entry = (QuickAccessEntry)this.table.getSelection()[0].getData();
            QuickAccessElement quickAccessElement = selectedElement = entry == null ? null : entry.element;
        }
        if (selectedElement != null) {
            this.doClose();
            this.handleElementSelected(text, selectedElement);
        }
    }

    public void preOpen() {
        this.setShowAllMatches(false);
        this.keySequence = null;
        this.updateInfoLabel();
    }

    protected abstract void doClose();

    public void hookFilterText(Text filterText) {
        this.filterText = filterText;
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        QuickAccessContents.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || QuickAccessContents.this.table.getItemCount() <= index + 1) break;
                        QuickAccessContents.this.table.setSelection(index + 1);
                        break;
                    }
                    case 0x1000001: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || index < 1) break;
                        QuickAccessContents.this.table.setSelection(index - 1);
                        break;
                    }
                    case 27: {
                        QuickAccessContents.this.doClose();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText().toLowerCase();
                QuickAccessContents.this.refresh(text);
            }
        });
    }

    public Table createTable(Composite composite, int defaultOrientation) {
        TextStyle boldStyle;
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QuickAccessContents.this.doDispose();
            }
        });
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(tableComposite, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(defaultOrientation);
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)JFaceResources.getDialogFont()).setStyle(1));
        this.textLayout.setFont(this.table.getFont());
        this.textLayout.setText(QuickAccessMessages.QuickAccess_AvailableCategories);
        int maxProviderWidth = (int)((double)this.textLayout.getBounds().width * 1.1);
        this.textLayout.setFont(boldFont);
        int i = 0;
        while (i < this.providers.length) {
            QuickAccessProvider provider = this.providers[i];
            this.textLayout.setText(provider.getName());
            int width = (int)((double)this.textLayout.getBounds().width * 1.1);
            if (width > maxProviderWidth) {
                maxProviderWidth = width;
            }
            ++i;
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, maxProviderWidth));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!QuickAccessContents.this.showAllMatches && !QuickAccessContents.this.resized) {
                    QuickAccessContents.this.resized = true;
                    e.display.timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if ((this).QuickAccessContents.this.table != null && !(this).QuickAccessContents.this.table.isDisposed()) {
                                QuickAccessContents.this.refresh((this).QuickAccessContents.this.filterText.getText().toLowerCase());
                            }
                            (this).QuickAccessContents.this.resized = false;
                        }
                    });
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && QuickAccessContents.this.table.getSelectionIndex() == 0) {
                    QuickAccessContents.this.filterText.setFocus();
                } else if (e.character == '\u001b') {
                    QuickAccessContents.this.doClose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (QuickAccessContents.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (QuickAccessContents.this.table.equals(e.getSource())) {
                    TableItem o = QuickAccessContents.this.table.getItem(new Point(e.x, e.y));
                    TableItem selection = QuickAccessContents.this.table.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickAccessContents.this.handleSelection();
                    }
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent e) {
                if (QuickAccessContents.this.table.equals(e.getSource())) {
                    TableItem o;
                    if (this.lastItem == null ^ (o = QuickAccessContents.this.table.getItem(new Point(e.x, e.y))) == null) {
                        QuickAccessContents.this.table.setCursor(o == null ? null : QuickAccessContents.this.table.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TableItem) {
                        if (!o.equals(this.lastItem)) {
                            this.lastItem = o;
                            QuickAccessContents.this.table.setSelection(new TableItem[]{this.lastItem});
                        }
                    } else if (o == null) {
                        this.lastItem = null;
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickAccessContents.this.handleSelection();
            }
        });
        if (PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS")) {
            boldStyle = new TextStyle(boldFont, null, null);
            this.grayColor = this.resourceManager.createColor(ColorUtil.blend(this.table.getBackground().getRGB(), this.table.getForeground().getRGB()));
        } else {
            boldStyle = null;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                QuickAccessEntry entry = (QuickAccessEntry)event.item.getData();
                if (entry != null) {
                    switch (event.type) {
                        case 41: {
                            entry.measure(event, QuickAccessContents.this.textLayout, (ResourceManager)QuickAccessContents.this.resourceManager, boldStyle);
                            break;
                        }
                        case 42: {
                            entry.paint(event, QuickAccessContents.this.textLayout, (ResourceManager)QuickAccessContents.this.resourceManager, boldStyle, QuickAccessContents.this.grayColor);
                            break;
                        }
                        case 40: {
                            entry.erase(event);
                        }
                    }
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        return this.table;
    }

    public Label createInfoLabel(Composite parent) {
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setFont(parent.getFont());
        this.infoLabel.setForeground(this.grayColor);
        this.infoLabel.setBackground(this.table.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.infoLabel.setLayoutData((Object)gd);
        this.updateInfoLabel();
        return this.infoLabel;
    }

    public void resetProviders() {
        QuickAccessProvider[] quickAccessProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            QuickAccessProvider provider = quickAccessProviderArray[n2];
            provider.reset();
            ++n2;
        }
    }
}

