/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public class ConnectProviderOperation
implements IEGitOperation {
    private final Map<IProject, File> projects = new LinkedHashMap<IProject, File>();
    private boolean refreshResources = true;

    public ConnectProviderOperation(IProject proj) {
        this(proj, proj.getLocation().append(".git").toFile());
    }

    public ConnectProviderOperation(IProject proj, File pathToRepo) {
        this.projects.put(proj, pathToRepo);
    }

    public ConnectProviderOperation(Map<IProject, File> projects) {
        this.projects.putAll(projects);
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (String)CoreText.ConnectProviderOperation_connecting, (int)this.projects.size());
        MultiStatus ms = new MultiStatus(Activator.getPluginId(), 0, CoreText.ConnectProviderOperation_ConnectErrors, null);
        for (Map.Entry<IProject, File> entry : this.projects.entrySet()) {
            this.connectProject(entry, ms, (IProgressMonitor)progress.newChild(1));
        }
        if (!ms.isOK()) {
            throw new CoreException((IStatus)ms);
        }
    }

    private void connectProject(Map.Entry<IProject, File> entry, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IProject project = entry.getKey();
        String taskName = NLS.bind((String)CoreText.ConnectProviderOperation_ConnectingProject, (Object)project.getName());
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), taskName);
        }
        RepositoryFinder finder = new RepositoryFinder(project);
        finder.setFindInChildren(false);
        Collection<RepositoryMapping> repos = finder.find((IProgressMonitor)subMon.newChild(50));
        if (repos.isEmpty()) {
            ms.add(Activator.error(NLS.bind((String)CoreText.ConnectProviderOperation_NoRepositoriesError, (Object)project.getName()), null));
            return;
        }
        RepositoryMapping actualMapping = this.findActualRepository(repos, entry.getValue());
        if (actualMapping == null) {
            ms.add(Activator.error(NLS.bind((String)CoreText.ConnectProviderOperation_UnexpectedRepositoryError, (Object[])new Object[]{project.getName(), entry.getValue().toString(), repos.toString()}), null));
            return;
        }
        GitProjectData projectData = new GitProjectData(project);
        try {
            projectData.setRepositoryMappings(Arrays.asList(actualMapping));
            projectData.store();
            GitProjectData.add(project, projectData);
        }
        catch (CoreException ce) {
            ms.add(ce.getStatus());
            this.deleteGitProvider(ms, project);
            return;
        }
        catch (RuntimeException ce) {
            ms.add(Activator.error(ce.getMessage(), ce));
            this.deleteGitProvider(ms, project);
            return;
        }
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.egit.core.GitProvider");
        if (this.refreshResources) {
            project.refreshLocal(2, (IProgressMonitor)subMon.newChild(40));
        } else {
            subMon.worked(40);
        }
        this.autoIgnoreDerivedResources(project, (IProgressMonitor)subMon.newChild(10));
    }

    private void deleteGitProvider(MultiStatus ms, IProject project) {
        try {
            GitProjectData.delete(project);
        }
        catch (IOException e) {
            ms.add(Activator.error(e.getMessage(), e));
        }
    }

    private void autoIgnoreDerivedResources(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!Activator.autoIgnoreDerived()) {
            return;
        }
        List<IPath> paths = this.findDerivedResources((IContainer)project);
        if (paths.size() > 0) {
            IgnoreOperation ignoreOp = new IgnoreOperation(paths);
            ignoreOp.execute(monitor);
        }
    }

    private List<IPath> findDerivedResources(IContainer c) throws CoreException {
        IResource[] members;
        ArrayList<IPath> derived = new ArrayList<IPath>();
        IResource[] iResourceArray = members = c.members(8);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r.isDerived()) {
                derived.add(r.getLocation());
            } else if (r instanceof IContainer) {
                derived.addAll(this.findDerivedResources((IContainer)r));
            }
            ++n2;
        }
        return derived;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        Set<IProject> projectSet = this.projects.keySet();
        return new MultiRule((ISchedulingRule[])projectSet.toArray(new IProject[projectSet.size()]));
    }

    @Nullable
    private RepositoryMapping findActualRepository(Collection<RepositoryMapping> repos, File suggestedRepo) {
        File path = Path.fromOSString((String)suggestedRepo.getPath()).toFile();
        for (RepositoryMapping rm : repos) {
            IPath other = rm.getGitDirAbsolutePath();
            if (other == null || !path.equals(other.toFile())) continue;
            return rm;
        }
        return null;
    }

    public void setRefreshResources(boolean refresh) {
        this.refreshResources = refresh;
    }
}

