/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;

public class RebaseOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref ref;
    private final RebaseCommand.Operation operation;
    private RebaseResult result;
    private final RebaseCommand.InteractiveHandler handler;
    private boolean preserveMerges = false;

    public RebaseOperation(Repository repository, Ref ref) {
        this(repository, ref, RebaseCommand.Operation.BEGIN, null);
    }

    public RebaseOperation(Repository repository, Ref ref, RebaseCommand.InteractiveHandler handler) {
        this(repository, ref, RebaseCommand.Operation.BEGIN, handler);
    }

    public RebaseOperation(Repository repository, RebaseCommand.Operation operation) {
        this(repository, null, operation, null);
    }

    public RebaseOperation(Repository repository, RebaseCommand.Operation operation, RebaseCommand.InteractiveHandler handler) {
        this(repository, null, operation, handler);
    }

    private RebaseOperation(Repository repository, Ref ref, RebaseCommand.Operation operation, RebaseCommand.InteractiveHandler handler) {
        this.repository = repository;
        this.ref = ref;
        this.operation = operation;
        this.handler = handler;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        if (this.result != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        final IProject[] validProjects = ProjectUtil.getValidOpenProjects(this.repository);
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)2);
                RebaseCommand cmd = new Git(RebaseOperation.this.repository).rebase().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1)));
                MergeStrategy strategy = Activator.getDefault().getPreferredMergeStrategy();
                if (strategy != null) {
                    cmd.setStrategy(strategy);
                }
                try {
                    try {
                        if (RebaseOperation.this.handler != null) {
                            cmd.runInteractively(RebaseOperation.this.handler, true);
                        }
                        if (RebaseOperation.this.operation == RebaseCommand.Operation.BEGIN) {
                            cmd.setPreserveMerges(RebaseOperation.this.preserveMerges);
                            RebaseOperation.this.result = cmd.setUpstream(RebaseOperation.this.ref.getName()).call();
                        } else {
                            RebaseOperation.this.result = cmd.setOperation(RebaseOperation.this.operation).call();
                        }
                    }
                    catch (NoHeadException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (RefNotFoundException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (JGitInternalException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (GitAPIException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                }
                finally {
                    if (RebaseOperation.this.refreshNeeded()) {
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)progress.newChild(1));
                    } else {
                        progress.worked(1);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    private boolean refreshNeeded() {
        if (this.result == null) {
            return true;
        }
        return this.result.getStatus() != RebaseResult.Status.UP_TO_DATE;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }

    public RebaseResult getResult() {
        return this.result;
    }

    public final Repository getRepository() {
        return this.repository;
    }

    public final RebaseCommand.Operation getOperation() {
        return this.operation;
    }

    public void setPreserveMerges(boolean preserveMerges) {
        this.preserveMerges = preserveMerges;
    }
}

