/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TasksFilter;

class TaskListContentProvider
implements IStructuredContentProvider,
IResourceChangeListener {
    private static final int TASKS = 0;
    private static final int ERRORS = 1;
    private static final int WARNINGS = 2;
    private static final int INFOS = 3;
    private TaskList taskList;
    private TableViewer viewer;
    private IResource input;
    private int[] visibleMarkerCounts = null;
    private int totalMarkerCount = -1;

    public TaskListContentProvider(TaskList taskList) {
        this.taskList = taskList;
        this.viewer = taskList.getTableViewer();
    }

    private boolean getFilterOnMarkerLimit() {
        return this.taskList.getFilter().getFilterOnMarkerLimit();
    }

    private int getMarkerLimit() {
        return this.taskList.getFilter().getMarkerLimit();
    }

    private boolean isMarkerLimitExceeded() {
        return this.taskList.isMarkerLimitExceeded();
    }

    private void setMarkerLimitExceeded(boolean markerLimitExceeded) {
        this.taskList.setMarkerLimitExceeded(markerLimitExceeded);
    }

    public String getStatusSummaryVisible() {
        if (this.visibleMarkerCounts == null) {
            return "";
        }
        return NLS.bind((String)TaskListMessages.TaskList_statusSummaryVisible, (Object)new Integer(this.sum(this.visibleMarkerCounts)), (Object)this.getStatusSummaryBreakdown(this.visibleMarkerCounts));
    }

    public String getStatusSummarySelected(IStructuredSelection selection) {
        int[] selectedMarkerCounts = this.getMarkerCounts(selection.toList());
        return NLS.bind((String)TaskListMessages.TaskList_statusSummarySelected, (Object)new Integer(this.sum(selectedMarkerCounts)), (Object)this.getStatusSummaryBreakdown(selectedMarkerCounts));
    }

    private String getStatusSummaryBreakdown(int[] counts) {
        return NLS.bind((String)TaskListMessages.TaskList_statusSummaryBreakdown, (Object[])new Object[]{new Integer(counts[0]), new Integer(counts[1]), new Integer(counts[2]), new Integer(counts[3])});
    }

    public String getTitleSummary() {
        if (this.visibleMarkerCounts == null) {
            return "";
        }
        int visibleMarkerCount = this.sum(this.visibleMarkerCounts);
        TasksFilter filter = this.taskList.getFilter();
        if (filter.isShowingAll()) {
            return NLS.bind((String)TaskListMessages.TaskList_titleSummaryUnfiltered, (Object)new Integer(visibleMarkerCount));
        }
        return NLS.bind((String)TaskListMessages.TaskList_titleSummaryFiltered, (Object)new Integer(visibleMarkerCount), (Object)new Integer(this.getTotalMarkerCount()));
    }

    private int sum(int[] counts) {
        int sum = 0;
        int i = 0;
        int l = counts.length;
        while (i < l) {
            sum += counts[i];
            ++i;
        }
        return sum;
    }

    private int getTotalMarkerCount() {
        if (this.totalMarkerCount == -1) {
            this.totalMarkerCount = 0;
            try {
                IWorkspaceRoot root = this.taskList.getWorkspace().getRoot();
                IMarker[] markers = root.findMarkers(null, true, 2);
                int i = 0;
                while (i < markers.length) {
                    if (this.isRootType(markers[i])) {
                        ++this.totalMarkerCount;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return this.totalMarkerCount;
    }

    private boolean isRootType(IMarker marker) {
        String[] rootTypes = TasksFilter.ROOT_TYPES;
        int i = 0;
        int l = rootTypes.length;
        while (i < l) {
            if (MarkerUtil.isMarkerType(marker, rootTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IMarker[] getMarkers() throws CoreException {
        IResource resource;
        IResource[] resources = this.taskList.getResources();
        int l = resources.length;
        boolean bExists = false;
        int i = 0;
        while (i < l) {
            resource = resources[i];
            if (resource != null && resource.exists()) {
                bExists = true;
                break;
            }
            ++i;
        }
        if (!bExists) {
            return new IMarker[0];
        }
        if (this.taskList.showOwnerProject()) {
            IResource[] projectResources = new IResource[l];
            int i2 = 0;
            while (i2 < l) {
                resource = resources[i2];
                if (resource != null) {
                    IProject project = resource.getProject();
                    projectResources[i2] = project != null ? project : resource;
                }
                ++i2;
            }
            resources = projectResources;
        }
        int depth = this.taskList.getResourceDepth();
        TasksFilter filter = this.taskList.getFilter();
        HashSet<IMarker> set = new HashSet<IMarker>();
        int i3 = 0;
        while (i3 < l) {
            resource = resources[i3];
            if (resource != null) {
                IMarker[] markers = resource.findMarkers(null, true, depth);
                int j = 0;
                while (j < markers.length) {
                    IMarker marker = markers[j];
                    if (filter.select(marker)) {
                        set.add(marker);
                    }
                    ++j;
                }
            }
            ++i3;
        }
        IMarker[] result = new IMarker[set.size()];
        set.toArray(result);
        return result;
    }

    private int[] getMarkerCounts(List markers) {
        int[] markerCounts = new int[4];
        for (IMarker marker : markers) {
            if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
                switch (MarkerUtil.getSeverity(marker)) {
                    case 2: {
                        markerCounts[1] = markerCounts[1] + 1;
                        break;
                    }
                    case 1: {
                        markerCounts[2] = markerCounts[2] + 1;
                        break;
                    }
                    case 0: {
                        markerCounts[3] = markerCounts[3] + 1;
                    }
                }
                continue;
            }
            if (!MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) continue;
            markerCounts[0] = markerCounts[0] + 1;
        }
        return markerCounts;
    }

    private void updateMarkerCounts(IMarkerDelta markerDelta, int difference) {
        if (this.visibleMarkerCounts == null) {
            return;
        }
        if (markerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            int severity = markerDelta.getAttribute("severity", 1);
            switch (severity) {
                case 2: {
                    this.visibleMarkerCounts[1] = this.visibleMarkerCounts[1] + difference;
                    break;
                }
                case 1: {
                    this.visibleMarkerCounts[2] = this.visibleMarkerCounts[2] + difference;
                    break;
                }
                case 0: {
                    this.visibleMarkerCounts[3] = this.visibleMarkerCounts[3] + difference;
                }
            }
        } else if (markerDelta.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            this.visibleMarkerCounts[0] = this.visibleMarkerCounts[0] + difference;
        }
    }

    private void updateViewer(List additions, List removals, List changes) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (removals.size() > 0) {
            this.viewer.cancelEditing();
            this.viewer.remove(removals.toArray());
        }
        if (additions.size() > 0) {
            this.viewer.add(additions.toArray());
        }
        if (changes.size() > 0) {
            this.viewer.update(changes.toArray(), null);
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.input = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.input != null) {
            this.input.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.input = (IResource)newInput;
        if (this.input != null) {
            this.input.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.viewer = (TableViewer)viewer;
    }

    public Object[] getElements(Object parent) {
        try {
            Object[] markers = this.getMarkers();
            this.visibleMarkerCounts = this.getMarkerCounts(Arrays.asList(markers));
            if (this.getFilterOnMarkerLimit() && markers.length > this.getMarkerLimit()) {
                if (!this.isMarkerLimitExceeded()) {
                    this.setMarkerLimitExceeded(true);
                    this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh());
                }
                return new IMarker[0];
            }
            if (this.isMarkerLimitExceeded()) {
                this.setMarkerLimitExceeded(false);
                this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh());
            }
            return markers;
        }
        catch (CoreException coreException) {
            return new IMarker[0];
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        if (markerDeltas == null) {
            return;
        }
        int oldTotal = this.totalMarkerCount;
        ArrayList<IMarker> additions = new ArrayList<IMarker>();
        ArrayList<IMarker> removals = new ArrayList<IMarker>();
        ArrayList<IMarker> changes = new ArrayList<IMarker>();
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta markerDelta = markerDeltas[i];
            if (markerDelta != null) {
                int iKind = markerDelta.getKind();
                int j = 0;
                while (j < TasksFilter.ROOT_TYPES.length) {
                    if (markerDelta.isSubtypeOf(TasksFilter.ROOT_TYPES[j])) {
                        IResource resource;
                        if (this.totalMarkerCount != -1) {
                            switch (iKind) {
                                case 1: {
                                    ++this.totalMarkerCount;
                                    break;
                                }
                                case 2: {
                                    --this.totalMarkerCount;
                                }
                            }
                        }
                        if ((resource = markerDelta.getResource()) != null) {
                            boolean affectedBy;
                            boolean bl = affectedBy = this.taskList.checkResource(resource) && this.taskList.getFilter().select(markerDelta);
                            if (!affectedBy) break;
                            IMarker marker = markerDelta.getMarker();
                            switch (iKind) {
                                case 1: {
                                    additions.add(marker);
                                    this.updateMarkerCounts(markerDelta, 1);
                                    break;
                                }
                                case 2: {
                                    removals.add(marker);
                                    this.updateMarkerCounts(markerDelta, -1);
                                    break;
                                }
                                case 4: {
                                    changes.add(marker);
                                }
                            }
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (oldTotal == this.totalMarkerCount && additions.size() + removals.size() + changes.size() == 0) {
            return;
        }
        this.viewer.getControl().getDisplay().syncExec(() -> {
            if (this.getFilterOnMarkerLimit() && this.sum(this.visibleMarkerCounts) > this.getMarkerLimit()) {
                if (!this.isMarkerLimitExceeded()) {
                    this.setMarkerLimitExceeded(true);
                    this.viewer.refresh();
                }
            } else if (this.taskList.isMarkerLimitExceeded()) {
                this.setMarkerLimitExceeded(false);
                this.viewer.refresh();
            } else {
                this.updateViewer(additions, removals, changes);
            }
            this.taskList.markersChanged();
        });
    }
}

