/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.EvaluationReference;
import org.eclipse.ui.internal.navigator.extensions.EvaluationValueReference;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;

public class EvaluationCache
implements VisibilityAssistant.VisibilityListener {
    private final Map<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>> evaluations = new HashMap<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>>();
    private final Map<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>> evaluationsWithOverrides = new HashMap<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>>();
    private final ReferenceQueue<Object> evaluationsQueue = new ReferenceQueue();
    private final ReferenceQueue<Object> evaluationsWithOverridesQueue = new ReferenceQueue();

    public EvaluationCache(VisibilityAssistant anAssistant) {
        anAssistant.addListener(this);
    }

    private void cleanUpStaleEntries() {
        Reference<Object> r;
        while ((r = this.evaluationsQueue.poll()) != null) {
            EvaluationCache.processStaleEntry(r, this.evaluations);
        }
        while ((r = this.evaluationsWithOverridesQueue.poll()) != null) {
            EvaluationCache.processStaleEntry(r, this.evaluationsWithOverrides);
        }
    }

    private static void processStaleEntry(Reference<?> r, Map<? extends Reference<?>, ? extends Reference<?>> fromMap) {
        EvaluationReference<?> key;
        EvaluationValueReference oldVal;
        if (r instanceof EvaluationReference && (oldVal = (EvaluationValueReference)fromMap.remove(r)) != null) {
            oldVal.clear();
        }
        if (r instanceof EvaluationValueReference && (key = ((EvaluationValueReference)r).getKey()) != null) {
            fromMap.remove(key);
        }
    }

    private static NavigatorContentDescriptor[] getDescriptorsFromMap(Object anElement, Map<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>> map) {
        EvaluationValueReference<NavigatorContentDescriptor[]> value;
        EvaluationReference<Object> key = new EvaluationReference<Object>(anElement);
        NavigatorContentDescriptor[] cachedDescriptors = null;
        Reference cache = map.get(key);
        if (cache != null && (cachedDescriptors = (NavigatorContentDescriptor[])cache.get()) == null && (value = map.remove(key)) != null) {
            value.clear();
        }
        return cachedDescriptors;
    }

    public final NavigatorContentDescriptor[] getDescriptors(Object anElement, boolean toComputeOverrides) {
        this.cleanUpStaleEntries();
        if (anElement == null) {
            return null;
        }
        if (toComputeOverrides) {
            return EvaluationCache.getDescriptorsFromMap(anElement, this.evaluations);
        }
        return EvaluationCache.getDescriptorsFromMap(anElement, this.evaluationsWithOverrides);
    }

    private static void setDescriptorsInMap(Object anElement, NavigatorContentDescriptor[] theDescriptors, Map<EvaluationReference<Object>, EvaluationValueReference<NavigatorContentDescriptor[]>> map, ReferenceQueue<Object> queue) {
        EvaluationReference<Object> key = new EvaluationReference<Object>(anElement, queue);
        EvaluationValueReference<Object> newValue = new EvaluationValueReference<Object>(theDescriptors, key, queue);
        EvaluationValueReference<Object> oldValue = map.put(key, newValue);
        if (oldValue != null) {
            newValue.swapKey(oldValue);
            oldValue.clear();
        }
    }

    public final void setDescriptors(Object anElement, NavigatorContentDescriptor[] theDescriptors, boolean toComputeOverrides) {
        this.cleanUpStaleEntries();
        if (anElement != null) {
            if (toComputeOverrides) {
                EvaluationCache.setDescriptorsInMap(anElement, theDescriptors, this.evaluations, this.evaluationsQueue);
            } else {
                EvaluationCache.setDescriptorsInMap(anElement, theDescriptors, this.evaluationsWithOverrides, this.evaluationsWithOverridesQueue);
            }
        }
    }

    @Override
    public void onVisibilityOrActivationChange() {
        while (this.evaluationsQueue.poll() != null) {
        }
        while (this.evaluationsWithOverridesQueue.poll() != null) {
        }
        this.evaluations.clear();
        this.evaluationsWithOverrides.clear();
    }
}

