/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBServerDebugger
implements ICDebugger {
    void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
        try {
            SharedLibraryManager mgr = session.getSharedLibraryManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
            List p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, new ArrayList(1));
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Target target = (Target)dtargets[i];
                try {
                    mgr.setAutoLoadSymbols(target, autolib);
                }
                catch (CDIException cDIException) {
                    // empty catch block
                }
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[0]);
                    mgr.setSharedLibraryPaths(target, paths);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + e.getMessage());
        }
    }

    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = config.getAttribute("org.eclipse.cdt.launch.protocol", "mi");
            File cwd = exe.getProject().getLocation().toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            if (config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false)) {
                String remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
                remote = String.valueOf(remote) + ":";
                remote = String.valueOf(remote) + config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
                String[] args = new String[]{"remote", remote};
                session = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getLocation().toFile(), 0, args, cwd, gdbinit, null);
            } else {
                MIPlugin plugin = MIPlugin.getDefault();
                Preferences prefs = plugin.getPluginPreferences();
                int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
                String remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
                String remoteBaud = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, "invalid");
                session = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getLocation().toFile(), -1, null, cwd, gdbinit, null);
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Target target = (Target)targets[i];
                    MISession miSession = target.getMISession();
                    CommandFactory factory = miSession.getCommandFactory();
                    MIGDBSet setRemoteBaud = factory.createMIGDBSet(new String[]{"remotebaud", remoteBaud});
                    miSession.postCommand(setRemoteBaud, launchTimeout);
                    MIInfo info = setRemoteBaud.getMIInfo();
                    if (info == null) {
                        throw new MIException(MIPlugin.getResourceString("src.GDBServerDebugger.Can_not_set_Baud"));
                    }
                    MITargetSelect select = factory.createMITargetSelect(new String[]{"remote", remote});
                    miSession.postCommand(select, launchTimeout);
                    select.getMIInfo();
                    if (info == null) {
                        throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                    }
                    ++i;
                }
            }
            this.initializeLibraries(config, session);
            Session session2 = session;
            return session2;
        }
        catch (IOException e) {
            failed = true;
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + e.getMessage());
        }
        catch (MIException e) {
            failed = true;
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + e.getMessage());
        }
        catch (CoreException e) {
            failed = true;
            throw new CDIException(String.valueOf(MIPlugin.getResourceString("src.GDBServerDebugger.Error_initializing")) + e.getMessage());
        }
        finally {
            if (failed && session != null) {
                try {
                    session.terminate();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        throw new CDIException(MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_attaching_unsupported"));
    }

    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        throw new CDIException(MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_corefiles_unsupported"));
    }
}

