/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class SwitchCacheModeHandler
extends AbstractHandler
implements IHandler {
    private static final String COMMAND_ID = "org.eclipse.ptp.rm.lml.monitor.ui.switchCacheMode";
    private static final String STATE_ID = "org.eclipse.ui.commands.toggleState";
    private IMonitorControl lastSelectedMonitor;

    private IMonitorControl getSelectedMonitorFromMonitorView() {
        Object selected;
        IStructuredSelection sel;
        IWorkbenchPage page;
        ISelection selection;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (selection = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getSelection("org.eclipse.ptp.rm.ui.views.MonitorView")) != null && selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty() && (selected = sel.getFirstElement()) instanceof IMonitorControl) {
            return (IMonitorControl)selected;
        }
        return null;
    }

    private void updateState(IMonitorControl monitor) {
        boolean forceUpdate;
        if (monitor == null) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand(COMMAND_ID);
        State state = command.getState(STATE_ID);
        boolean isToggled = (Boolean)state.getValue();
        boolean bl = forceUpdate = !monitor.isCacheActive();
        if (isToggled != forceUpdate) {
            try {
                HandlerUtil.toggleCommandState((Command)command);
            }
            catch (ExecutionException executionException) {}
        }
        state.setValue((Object)forceUpdate);
    }

    public SwitchCacheModeHandler() {
        MonitorControlManager.getInstance().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                IMonitorControl monitor = null;
                if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
                    monitor = (IMonitorControl)sel.getFirstElement();
                }
                SwitchCacheModeHandler.this.lastSelectedMonitor = monitor;
                SwitchCacheModeHandler.this.updateState(monitor);
            }
        });
        MonitorControlManager.getInstance().addMonitorChangedListener(new IMonitorChangedListener(){

            public void monitorUpdated(IMonitorControl[] monitors) {
                IMonitorControl[] iMonitorControlArray = monitors;
                int n = monitors.length;
                int n2 = 0;
                while (n2 < n) {
                    IMonitorControl monitor = iMonitorControlArray[n2];
                    if (monitor == SwitchCacheModeHandler.this.lastSelectedMonitor) {
                        SwitchCacheModeHandler.this.updateState(monitor);
                    }
                    ++n2;
                }
            }

            public void monitorRemoved(IMonitorControl[] monitors) {
            }

            public void monitorAdded(IMonitorControl[] monitors) {
            }
        });
        this.lastSelectedMonitor = this.getSelectedMonitorFromMonitorView();
        this.updateState(this.lastSelectedMonitor);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMonitorControl monitor = this.getSelectedMonitorFromMonitorView();
        if (monitor != null) {
            boolean isCacheActive = monitor.isCacheActive();
            monitor.setCacheActive(!isCacheActive);
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<IMonitorControl> monitors = new ArrayList<IMonitorControl>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object sel : (IStructuredSelection)selection) {
                if (!(sel instanceof IMonitorControl)) continue;
                monitors.add((IMonitorControl)sel);
            }
            Iterator iterator = monitors.iterator();
            while (iterator.hasNext()) {
                IMonitorControl cmonitor;
                boolean isCacheActive = (cmonitor = (IMonitorControl)iterator.next()).isCacheActive();
                cmonitor.setCacheActive(!isCacheActive);
            }
        }
        return null;
    }
}

