/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifLaunchConstants;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.internal.valgrind.massif.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Version;

public class MassifToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String TIME_B_STRING = Messages.getString("MassifToolPage.bytes");
    public static final String TIME_MS_STRING = Messages.getString("MassifToolPage.milliseconds");
    public static final String TIME_I_STRING = Messages.getString("MassifToolPage.instructions");
    public static final String MASSIF = "massif";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.massif";
    private static final Version VER_3_6_0 = new Version(3, 6, 0);
    private Button heapButton;
    private Spinner heapAdminSpinner;
    private Button stacksButton;
    private Spinner depthSpinner;
    private org.eclipse.swt.widgets.List allocFnList;
    private org.eclipse.swt.widgets.List ignoreFnList;
    private Spinner thresholdSpinner;
    private Spinner peakInaccuracySpinner;
    private Combo timeUnitCombo;
    private Spinner detailedFreqSpinner;
    private Spinner maxSnapshotsSpinner;
    private Button alignmentButton;
    private Spinner alignmentSpinner;
    private Button pagesasheapButton;
    private boolean isInitializing = false;
    private Version valgrindVersion;
    private SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MassifToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MassifToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(2, true);
        topLayout.horizontalSpacing = 10;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(1808));
        Composite heapTop = new Composite(top, 0);
        heapTop.setLayout((Layout)new GridLayout(2, false));
        this.heapButton = new Button(heapTop, 32);
        this.heapButton.setText(Messages.getString("MassifToolPage.profile_heap"));
        this.heapButton.addSelectionListener(this.selectListener);
        Composite heapAdminTop = new Composite(top, 0);
        heapAdminTop.setLayout((Layout)new GridLayout(2, false));
        Label heapAdminLabel = new Label(heapAdminTop, 0);
        heapAdminLabel.setText(Messages.getString("MassifToolPage.administrative_bytes"));
        this.heapAdminSpinner = new Spinner(heapAdminTop, 2048);
        this.heapAdminSpinner.addModifyListener(this.modifyListener);
        Composite stacksTop = new Composite(top, 0);
        stacksTop.setLayout((Layout)new GridLayout(2, false));
        this.stacksButton = new Button(stacksTop, 32);
        this.stacksButton.setText(Messages.getString("MassifToolPage.profile_stack"));
        this.stacksButton.addSelectionListener(this.selectListener);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            Composite pagesasheapTop = new Composite(top, 0);
            pagesasheapTop.setLayout((Layout)new GridLayout(2, false));
            this.pagesasheapButton = new Button(pagesasheapTop, 32);
            this.pagesasheapButton.setText(Messages.getString("MassifToolPage.profile_pagesasheap"));
            this.pagesasheapButton.addSelectionListener(this.selectListener);
        }
        Composite depthTop = new Composite(top, 0);
        depthTop.setLayout((Layout)new GridLayout(2, false));
        Label depthLabel = new Label(depthTop, 0);
        depthLabel.setText(Messages.getString("MassifToolPage.allocation_tree_depth"));
        this.depthSpinner = new Spinner(depthTop, 2048);
        this.depthSpinner.addModifyListener(this.modifyListener);
        Composite thresholdTop = new Composite(top, 0);
        thresholdTop.setLayout((Layout)new GridLayout(3, false));
        Label thresholdLabel = new Label(thresholdTop, 0);
        thresholdLabel.setText(Messages.getString("MassifToolPage.heap_allocation_threshold"));
        this.thresholdSpinner = new Spinner(thresholdTop, 2048);
        this.thresholdSpinner.setDigits(1);
        this.thresholdSpinner.setMaximum(1000);
        this.thresholdSpinner.addModifyListener(this.modifyListener);
        Label thresholdPercentLabel = new Label(thresholdTop, 0);
        thresholdPercentLabel.setText("%");
        Composite peakInaccuracyTop = new Composite(top, 0);
        peakInaccuracyTop.setLayout((Layout)new GridLayout(3, false));
        Label peakInaccuracyLabel = new Label(peakInaccuracyTop, 0);
        peakInaccuracyLabel.setText(Messages.getString("MassifToolPage.allocation_peak_inaccuracy"));
        this.peakInaccuracySpinner = new Spinner(peakInaccuracyTop, 2048);
        this.peakInaccuracySpinner.setDigits(1);
        this.peakInaccuracySpinner.setMaximum(1000);
        this.peakInaccuracySpinner.addModifyListener(this.modifyListener);
        Label peakInaccuracyPercentLabel = new Label(peakInaccuracyTop, 0);
        peakInaccuracyPercentLabel.setText("%");
        Composite timeUnitTop = new Composite(top, 0);
        timeUnitTop.setLayout((Layout)new GridLayout(2, false));
        Label timeUnitLabel = new Label(timeUnitTop, 0);
        timeUnitLabel.setText(Messages.getString("MassifToolPage.time_unit"));
        this.timeUnitCombo = new Combo(timeUnitTop, 8);
        String[] items = new String[]{TIME_I_STRING, TIME_MS_STRING, TIME_B_STRING};
        this.timeUnitCombo.setItems(items);
        this.timeUnitCombo.addSelectionListener(this.selectListener);
        Composite detailedFreqTop = new Composite(top, 0);
        detailedFreqTop.setLayout((Layout)new GridLayout(2, false));
        Label detailedFreqLabel = new Label(detailedFreqTop, 0);
        detailedFreqLabel.setText(Messages.getString("MassifToolPage.detailed_snapshot_freq"));
        this.detailedFreqSpinner = new Spinner(detailedFreqTop, 2048);
        this.detailedFreqSpinner.setMinimum(1);
        this.detailedFreqSpinner.setMaximum(Integer.MAX_VALUE);
        this.detailedFreqSpinner.addModifyListener(this.modifyListener);
        Composite maxSnapshotsTop = new Composite(top, 0);
        maxSnapshotsTop.setLayout((Layout)new GridLayout(2, false));
        Label maxSnapshotsLabel = new Label(maxSnapshotsTop, 0);
        maxSnapshotsLabel.setText(Messages.getString("MassifToolPage.max_snapshots"));
        this.maxSnapshotsSpinner = new Spinner(maxSnapshotsTop, 2048);
        this.maxSnapshotsSpinner.setMaximum(Integer.MAX_VALUE);
        this.maxSnapshotsSpinner.addModifyListener(this.modifyListener);
        Composite alignmentTop = new Composite(top, 0);
        GridLayout alignmentLayout = new GridLayout(2, false);
        alignmentLayout.marginHeight = 0;
        alignmentLayout.marginWidth = 0;
        alignmentTop.setLayout((Layout)alignmentLayout);
        this.alignmentButton = new Button(alignmentTop, 32);
        this.alignmentButton.setText(Messages.getString("MassifToolPage.minimum_heap_block"));
        this.alignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassifToolPage.this.checkAlignmentEnablement();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.alignmentSpinner = new Spinner(alignmentTop, 2048);
        this.alignmentSpinner.setMinimum(0);
        this.alignmentSpinner.setMaximum(4096);
        this.alignmentSpinner.addModifyListener(this.modifyListener);
        Composite allocFnTop = new Composite(top, 0);
        allocFnTop.setLayout((Layout)new GridLayout(3, false));
        allocFnTop.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label allocFnLabel = new Label(allocFnTop, 0);
        allocFnLabel.setText(Messages.getString("MassifToolPage.allocation_functions"));
        allocFnLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.createAllocFnControls(allocFnTop);
        Composite ignoreFnTop = new Composite(top, 0);
        ignoreFnTop.setLayout((Layout)new GridLayout(3, false));
        ignoreFnTop.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label ignoreFnLabel = new Label(ignoreFnTop, 0);
        ignoreFnLabel.setText(Messages.getString("MassifToolPage.ignore_functions"));
        ignoreFnLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.createIgnoreFnControls(ignoreFnTop);
    }

    private void checkAlignmentEnablement() {
        this.alignmentSpinner.setEnabled(this.alignmentButton.getSelection());
    }

    private void createAllocFnControls(Composite top) {
        this.allocFnList = new org.eclipse.swt.widgets.List(top, 2818);
        FontMetrics fm = MassifPlugin.getFontMetrics((Control)this.allocFnList);
        this.allocFnList.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)50), Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)5)));
        Composite allocButtons = new Composite(top, 0);
        GridLayout allocButtonsLayout = new GridLayout();
        allocButtonsLayout.marginHeight = 0;
        allocButtonsLayout.marginWidth = 0;
        allocButtons.setLayout((Layout)allocButtonsLayout);
        allocButtons.setLayoutData((Object)new GridData(1, 1, false, false));
        Button newButton = new Button(allocButtons, 8);
        newButton.setText(Messages.getString("MassifToolPage.New"));
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassifToolPage.this.handleAllocNewButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button removeButton = new Button(allocButtons, 8);
        removeButton.setText(Messages.getString("MassifToolPage.Remove"));
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassifToolPage.this.handleAllocRemoveButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createIgnoreFnControls(Composite top) {
        this.ignoreFnList = new org.eclipse.swt.widgets.List(top, 2818);
        FontMetrics fm = MassifPlugin.getFontMetrics((Control)this.ignoreFnList);
        this.ignoreFnList.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)50), Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)5)));
        Composite ignoreButtons = new Composite(top, 0);
        GridLayout ignoreButtonsLayout = new GridLayout();
        ignoreButtonsLayout.marginHeight = 0;
        ignoreButtonsLayout.marginWidth = 0;
        ignoreButtons.setLayout((Layout)ignoreButtonsLayout);
        ignoreButtons.setLayoutData((Object)new GridData(1, 1, false, false));
        Button newButton = new Button(ignoreButtons, 8);
        newButton.setText(Messages.getString("MassifToolPage.New"));
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassifToolPage.this.handleIgnoreNewButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button removeButton = new Button(ignoreButtons, 8);
        removeButton.setText(Messages.getString("MassifToolPage.Remove"));
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassifToolPage.this.handleIgnoreRemoveButtonPressed();
                MassifToolPage.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleAllocNewButtonPressed() {
        String function;
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("MassifToolPage.New_Allocation_Function"), Messages.getString("MassifToolPage.Function_name"), "", null);
        if (dialog.open() == 0 && !(function = dialog.getValue()).equals("")) {
            this.allocFnList.add(function);
        }
    }

    private void handleAllocRemoveButtonPressed() {
        int[] selections = this.allocFnList.getSelectionIndices();
        this.allocFnList.remove(selections);
    }

    private void handleIgnoreNewButtonPressed() {
        String function;
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("MassifToolPage.New_Ignore_Function"), Messages.getString("MassifToolPage.Function_name"), "", null);
        if (dialog.open() == 0 && !(function = dialog.getValue()).equals("")) {
            this.ignoreFnList.add(function);
        }
    }

    private void handleIgnoreRemoveButtonPressed() {
        int[] selections = this.ignoreFnList.getSelectionIndices();
        this.ignoreFnList.remove(selections);
    }

    public String getName() {
        return Messages.getString("MassifToolPage.Massif_Options");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            this.heapButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP", true));
            this.heapAdminSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN", 8));
            this.stacksButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS", false));
            this.depthSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH", 30));
            List allocFns = configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN", MassifLaunchConstants.DEFAULT_MASSIF_ALLOCFN);
            this.allocFnList.setItems(allocFns.toArray(new String[allocFns.size()]));
            List ignoreFns = configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_IGNOREFN", MassifLaunchConstants.DEFAULT_MASSIF_IGNOREFN);
            this.ignoreFnList.setItems(ignoreFns.toArray(new String[ignoreFns.size()]));
            this.thresholdSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD", 10));
            this.peakInaccuracySpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY", 10));
            String timeUnit = configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT", "i");
            if (timeUnit.equals("i")) {
                this.timeUnitCombo.select(0);
            } else if (timeUnit.equals("ms")) {
                this.timeUnitCombo.select(1);
            } else {
                this.timeUnitCombo.select(2);
            }
            this.detailedFreqSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ", 10));
            this.maxSnapshotsSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS", 100));
            this.alignmentButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_BOOL", false));
            this.checkAlignmentEnablement();
            int alignment = configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_VAL", 0);
            this.alignmentSpinner.setSelection(alignment);
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
                this.pagesasheapButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PAGEASHEAP", false));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP", this.heapButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN", this.heapAdminSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS", this.stacksButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH", this.depthSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN", Arrays.asList(this.allocFnList.getItems()));
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_IGNOREFN", Arrays.asList(this.ignoreFnList.getItems()));
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD", this.thresholdSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY", this.peakInaccuracySpinner.getSelection());
        int ix = this.timeUnitCombo.getSelectionIndex();
        String value = ix == 0 ? "i" : (ix == 1 ? "ms" : "B");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT", value);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ", this.detailedFreqSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS", this.maxSnapshotsSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_BOOL", this.alignmentButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_VAL", this.alignmentSpinner.getSelection());
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PAGEASHEAP", this.pagesasheapButton.getSelection());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = false;
        try {
            int alignment = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_VAL", 0);
            result = (alignment & alignment - 1) == 0;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!result) {
            this.setErrorMessage(Messages.getString("MassifToolPage.Alignment_must_be_power_2"));
        }
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.massif");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAP", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_HEAPADMIN", 8);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_STACKS", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DEPTH", 30);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALLOCFN", MassifLaunchConstants.DEFAULT_MASSIF_ALLOCFN);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_THRESHOLD", 10);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PEAKINACCURACY", 10);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_TIMEUNIT", "i");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_DETAILEDFREQ", 10);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_MAXSNAPSHOTS", 100);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_BOOL", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_ALIGNMENT_VAL", 0);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.massif.MASSIF_PAGEASHEAP", false);
        }
    }

    public void setValgrindVersion(Version ver) {
        this.valgrindVersion = ver;
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public Button getHeapButton() {
        return this.heapButton;
    }

    public Spinner getHeapAdminSpinner() {
        return this.heapAdminSpinner;
    }

    public Button getStacksButton() {
        return this.stacksButton;
    }

    public Button getPageasheapButton() {
        return this.pagesasheapButton;
    }

    public Spinner getDepthSpinner() {
        return this.depthSpinner;
    }

    public org.eclipse.swt.widgets.List getAllocFnList() {
        return this.allocFnList;
    }

    public org.eclipse.swt.widgets.List getIgnoreFnList() {
        return this.ignoreFnList;
    }

    public Spinner getThresholdSpinner() {
        return this.thresholdSpinner;
    }

    public Spinner getPeakInaccuracySpinner() {
        return this.peakInaccuracySpinner;
    }

    public Combo getTimeUnitCombo() {
        return this.timeUnitCombo;
    }

    public Spinner getDetailedFreqSpinner() {
        return this.detailedFreqSpinner;
    }

    public Spinner getMaxSnapshotsSpinner() {
        return this.maxSnapshotsSpinner;
    }

    public Button getAlignmentButton() {
        return this.alignmentButton;
    }

    public Spinner getAlignmentSpinner() {
        return this.alignmentSpinner;
    }
}

