/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIVariableInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.AbstractPValue;
import org.eclipse.ptp.internal.debug.core.model.AbstractPVariable;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;
import org.eclipse.ptp.internal.debug.core.model.PValueFactory;

public abstract class PVariable
extends AbstractPVariable
implements IPDIEventListener {
    private PVariableFormat fFormat = PVariableFormat.getFormat(Platform.getPreferencesService().getInt(PTPDebugCorePlugin.getUniqueIdentifier(), IPDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, 0, null));
    private boolean fIsDisposed = false;
    private boolean fIsEnabled = true;
    private String fName;
    private IInternalVariable fOriginal;
    private IInternalVariable fShadow;

    protected PVariable(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject) {
        super(parent);
        if (pdiVariableObject != null) {
            this.setName(pdiVariableObject.getName());
            this.createOriginal(pdiVariableObject);
        }
        this.fIsEnabled = parent instanceof AbstractPValue ? ((AbstractPValue)parent).getParentVariable().isEnabled() : !this.isBookkeepingEnabled();
        this.getPDISession().getEventManager().addEventListener(this);
    }

    protected PVariable(PDebugElement parent, IPDIVariableDescriptor pdiVariableObject, String errorMessage) {
        super(parent);
        if (pdiVariableObject != null) {
            this.setName(pdiVariableObject.getName());
            this.createOriginal(pdiVariableObject);
        }
        this.fIsEnabled = !this.isBookkeepingEnabled();
        this.setStatus(2, NLS.bind((String)Messages.PVariable_0, (Object[])new Object[]{errorMessage}));
        this.getPDISession().getEventManager().addEventListener(this);
    }

    public boolean canCast() {
        return this.getOriginal() != null && this.isEnabled();
    }

    public boolean canCastToArray() {
        try {
            return this.getOriginal() != null && this.isEnabled() && this.getAIF().getType() instanceof IAIFTypePointer;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    @Override
    public boolean canEnableDisable() {
        return !(this.getParent() instanceof IValue);
    }

    public void castToArray(int startIndex, int length) throws DebugException {
        IInternalVariable current = this.getCurrentInternalVariable();
        if (current != null) {
            IInternalVariable newVar = current.createShadow(startIndex, length);
            if (this.getShadow() != null) {
                this.getShadow().dispose(true);
            }
            this.setShadow(newVar);
            this.resetValue();
        }
    }

    @Override
    public void changeFormat(PVariableFormat format) throws DebugException {
        this.setFormat(format);
        this.resetValue();
    }

    @Override
    public void dispose() {
        this.internalDispose(false);
        this.setDisposed(true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVariable) {
            if (this.isDisposed() != ((PVariable)obj).isDisposed()) {
                return false;
            }
            IInternalVariable iv = this.getOriginal();
            return iv != null ? iv.equals(((PVariable)obj).getOriginal()) : false;
        }
        return false;
    }

    @Override
    public String getExpressionString() throws DebugException {
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.getQualifiedName() : null;
    }

    @Override
    public PVariableFormat getFormat() {
        return this.fFormat;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        IAIF aif = this.getAIF();
        return aif != null ? aif.getType().toString() : "";
    }

    public IPValue getValue() throws DebugException {
        IInternalVariable iv;
        if (!this.isDisposed() && this.isEnabled() && (iv = this.getCurrentInternalVariable()) != null) {
            try {
                return iv.getValue();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return PValueFactory.NULL_VALUE;
    }

    @Override
    public void handleDebugEvents(IPDIEvent[] events) {
        IPDIEvent[] iPDIEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIEvent event2 = iPDIEventArray[n2];
            IPDIEvent event = event2;
            if (event.contains(this.getTasks())) {
                if (event instanceof IPDIChangedEvent) {
                    this.handleChangedEvent((IPDIChangedEvent)event);
                } else if (event instanceof IPDIResumedEvent) {
                    this.handleResumedEvent((IPDIResumedEvent)event);
                }
            }
            ++n2;
        }
    }

    public boolean hasValueChanged() throws DebugException {
        if (this.isDisposed()) {
            return false;
        }
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.isChanged() : false;
    }

    @Override
    public boolean isArgument() {
        IInternalVariable iv = this.getOriginal();
        return iv != null ? iv.isArgument() : false;
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    @Override
    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void restoreOriginal() throws DebugException {
        IInternalVariable iv;
        IInternalVariable oldVar = this.getShadow();
        this.setShadow(null);
        if (oldVar != null) {
            oldVar.dispose(true);
        }
        if ((iv = this.getOriginal()) != null) {
            iv.invalidateValue();
        }
        this.resetValue();
    }

    @Override
    public void setEnabled(boolean enabled) throws DebugException {
        IInternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(true);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(true);
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(256);
    }

    public void setValue(IValue value) throws DebugException {
        PVariable.notSupported(Messages.PVariable_1);
    }

    public void setValue(String expression) throws DebugException {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            String newExpression = this.processExpression(expression);
            iv.setValue(newExpression);
        }
    }

    @Override
    public boolean supportsFormatting() {
        return true;
    }

    public boolean supportsValueModification() {
        try {
            return this.getCurrentInternalVariable().isEditable();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return value.getDebugTarget().equals(this.getDebugTarget());
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    private IInternalVariable getCurrentInternalVariable() {
        if (this.getShadow() != null) {
            return this.getShadow();
        }
        return this.getOriginal();
    }

    private IInternalVariable getOriginal() {
        return this.fOriginal;
    }

    private IInternalVariable getShadow() {
        return this.fShadow;
    }

    private void handleChangedEvent(IPDIChangedEvent event) {
        IInternalVariable iv;
        IPDISessionObject reason = event.getReason();
        if (reason instanceof IPDIVariableInfo && (iv = this.getCurrentInternalVariable()) != null && iv.isSameVariable(((IPDIVariableInfo)reason).getVariable())) {
            iv.setChanged(true);
            this.fireChangeEvent(256);
        }
    }

    private void handleResumedEvent(IPDIResumedEvent event) {
        boolean changed = false;
        if (this.hasErrors()) {
            this.resetStatus();
            changed = true;
            IInternalVariable iv = this.getCurrentInternalVariable();
            if (iv != null) {
                iv.invalidateValue();
            }
        }
        if (changed) {
            this.fireChangeEvent(256);
        }
    }

    private String processExpression(String oldExpression) throws DebugException {
        return oldExpression;
    }

    private void setShadow(IInternalVariable shadow) {
        this.fShadow = shadow;
    }

    protected abstract void createOriginal(IPDIVariableDescriptor var1);

    protected boolean hasErrors() {
        return !this.isOK();
    }

    protected void internalDispose(boolean destroy) {
        this.getPDISession().getEventManager().removeEventListener(this);
        IInternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(destroy);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(destroy);
        }
    }

    protected void invalidateValue() {
        this.resetStatus();
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.invalidateValue();
        }
    }

    protected boolean isBookkeepingEnabled() {
        return false;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    @Override
    protected void preserve() {
        this.resetStatus();
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.preserve();
        }
    }

    @Override
    protected void resetValue() {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            this.resetStatus();
            iv.resetValue();
            this.fireChangeEvent(256);
        }
    }

    protected boolean sameVariable(IPDIVariableDescriptor vo) {
        IInternalVariable iv = this.getOriginal();
        return iv != null && iv.isSameDescriptor(vo);
    }

    @Override
    protected void setChanged(boolean changed) {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.setChanged(changed);
        }
    }

    protected void setDisposed(boolean isDisposed) {
        this.fIsDisposed = isDisposed;
    }

    protected void setFormat(PVariableFormat format) {
        this.fFormat = format;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    protected void setOriginal(IInternalVariable original) {
        this.fOriginal = original;
    }

    protected int sizeof() {
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.sizeof() : -1;
    }

    public static interface IInternalVariable {
        public IInternalVariable createShadow(int var1, int var2) throws DebugException;

        public IInternalVariable createShadow(String var1) throws DebugException;

        public void dispose(boolean var1);

        public String getQualifiedName() throws DebugException;

        public IPValue getValue() throws DebugException;

        public void invalidateValue();

        public boolean isArgument();

        public boolean isChanged();

        public boolean isEditable() throws DebugException;

        public boolean isSameDescriptor(IPDIVariableDescriptor var1);

        public boolean isSameVariable(IPDIVariable var1);

        public void preserve();

        public void resetValue();

        public void setChanged(boolean var1);

        public void setValue(String var1) throws DebugException;

        public int sizeof();
    }
}

