/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceManager;

public abstract class RSEModelOperation {
    private static Map threads = new HashMap();

    public static void check() {
        if (RSEModelOperation.getDepth() == 0) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logInfo("not inside transaction");
        }
    }

    private static int getDepth() {
        Thread myThread = Thread.currentThread();
        if (threads.get(myThread) == null) {
            threads.put(myThread, new Integer(0));
        }
        int depth = (Integer)threads.get(myThread);
        return depth;
    }

    private static void beginTransaction() {
    }

    private static void endTransaction() {
        IRSEPersistenceManager persistenceManager = RSECorePlugin.getThePersistenceManager();
        persistenceManager.commitProfiles(5000L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void enterLevel() {
        int depth = RSEModelOperation.getDepth();
        try {
            if (depth == 0) {
                RSEModelOperation.beginTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Thread myThread = Thread.currentThread();
            threads.put(myThread, new Integer(depth + 1));
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        Thread myThread = Thread.currentThread();
        threads.put(myThread, new Integer(depth + 1));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void leaveLevel() {
        int depth = RSEModelOperation.getDepth();
        try {
            if (depth == 1) {
                RSEModelOperation.endTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Thread myThread = Thread.currentThread();
            threads.put(myThread, new Integer(depth - 1));
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        Thread myThread = Thread.currentThread();
        threads.put(myThread, new Integer(depth - 1));
    }

    public abstract void execute();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        RSEModelOperation.enterLevel();
        try {
            this.execute();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RSEModelOperation.leaveLevel();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RSEModelOperation.leaveLevel();
    }
}

