/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.model.GemModel;

public class StubbyGemGenerator
extends AbstractGenerator {
    private GemModel model;
    private static final String FIX_ME = "#FIXME";

    public StubbyGemGenerator(IFile gemFile) {
        this.parse(gemFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = gemFile.getProject().getName();
    }

    private void parse(IFile gemFile) {
        this.model = new GemModel(gemFile);
    }

    @Override
    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        this.generateDefines(buffer);
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n\n");
        this.generateRequires(buffer);
        buffer.append("BuildArch:      noarch\n");
        buffer.append("Provides:       rubygem(%{gem_name}) = %{version}\n\n\n");
        buffer.append("%description\n" + this.model.getDescription() + "\n\n\n");
        StubbyGemGenerator.generatePrepSection(buffer);
        StubbyGemGenerator.generateBuildSection(buffer);
        this.generateInstallSection(buffer);
        StubbyGemGenerator.generateFilesSections(buffer);
        StubbyGemGenerator.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateDefines(StringBuilder buffer) {
        buffer.append("%global gem_name " + this.model.getSimplePackageName().toLowerCase() + "\n\n");
    }

    private void generateRequires(StringBuilder buffer) {
        buffer.append("BuildRequires:  rubygems-devel\n");
        List<String> requireList = this.model.getBuildRequiresList();
        for (String require : requireList) {
            buffer.append("BuildRequires:  " + require + "\n");
        }
        buffer.append("Requires:       ruby(release)\n");
        String rubyGemsVersion = this.model.getGemVersion();
        if (rubyGemsVersion.equals(FIX_ME)) {
            buffer.append("Requires:       rubygems\n");
        } else {
            buffer.append("Requires:       rubygems == " + rubyGemsVersion + "\n");
        }
        requireList = this.model.getInstallRequiresList();
        for (String require : requireList) {
            buffer.append("Requires:       " + require + "\n");
        }
        buffer.append("\n");
    }

    private static void generatePrepSection(StringBuilder buffer) {
        buffer.append("%prep\n");
        buffer.append("gem unpack %{SOURCE0}\n");
        buffer.append("%setup -q -D -T -n %{gem_name}-%{version} #You may need to update this according to your Source0\n\n");
        buffer.append("gem spec %{SOURCE0} -l --ruby > %{gem_name}.gemspec\n\n\n");
    }

    private static void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("gem build %{gem_name}.gemspec\n\n");
        buffer.append("%gem_install\n\n\n");
    }

    private void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("mkdir -p %{buildroot}%{gem_dir}\n");
        buffer.append("cp -a ./%{gem_dir}/* %{buildroot}%{gem_dir}/\n\n");
        buffer.append("mkdir -p %{buildroot}%{_bindir}\n");
        buffer.append("cp -a ./%{_bindir}/* %{buildroot}%{_bindir}\n\n");
        List<String> requirePaths = this.model.getRequirePaths();
        if (!requirePaths.isEmpty()) {
            buffer.append("mkdir -p %{buildroot}%{gem_extdir_mri}/" + requirePaths.get(0) + "\n");
            buffer.append("mv %{buildroot}%{gem_instdir}/" + requirePaths.get(0) + "/shared_object.so %{buildroot}%{gem_extdir_mri}/" + requirePaths.get(0) + "/\n\n");
        }
        buffer.append("\n");
    }

    private static void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%dir %{gem_instdir}\n");
        buffer.append("%{gem_libdir}\n");
        buffer.append("%{gem_spec}\n\n");
        buffer.append("%files doc\n");
        buffer.append("%doc %{gem_docdir}\n\n\n");
    }
}

