/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List<DfsPackFile> srcPacks;
    private final List<PackWriter.ObjectIdSet> exclude;
    private final List<DfsPackDescription> newPacks;
    private final List<PackStatistics> newStats;
    private int autoAddSize;
    private RevWalk rw;
    private RevFlag added;
    private RevFlag isBase;

    public DfsPackCompactor(DfsRepository repository) {
        this.repo = repository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList<DfsPackFile>();
        this.exclude = new ArrayList<PackWriter.ObjectIdSet>(4);
        this.newPacks = new ArrayList<DfsPackDescription>(1);
        this.newStats = new ArrayList<PackStatistics>(1);
    }

    public DfsPackCompactor add(DfsPackFile pack) {
        this.srcPacks.add(pack);
        return this;
    }

    public DfsPackCompactor autoAdd() throws IOException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        for (DfsPackFile pack : objdb.getPacks()) {
            DfsPackDescription d = pack.getPackDescription();
            if (d.getFileSize(PackExt.PACK) < (long)this.autoAddSize) {
                this.add(pack);
                continue;
            }
            this.exclude(pack);
        }
        return this;
    }

    public DfsPackCompactor exclude(PackWriter.ObjectIdSet set) {
        this.exclude.add(set);
        return this;
    }

    public DfsPackCompactor exclude(DfsPackFile pack) throws IOException {
        PackIndex idx;
        try (DfsReader ctx = (DfsReader)this.repo.newObjectReader();){
            idx = pack.getPackIndex(ctx);
        }
        return this.exclude(new PackWriter.ObjectIdSet(){

            @Override
            public boolean contains(AnyObjectId id) {
                return idx.hasObject(id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        try (DfsReader ctx = (DfsReader)objdb.newReader();){
            PackConfig pc = new PackConfig(this.repo);
            pc.setIndexVersion(2);
            pc.setDeltaCompress(false);
            pc.setReuseDeltas(true);
            pc.setReuseObjects(true);
            try (PackWriter pw = new PackWriter(pc, (ObjectReader)ctx);){
                pw.setDeltaBaseAsOffset(true);
                pw.setReuseDeltaCommits(false);
                this.addObjectsToPack(pw, ctx, pm);
                if (pw.getObjectCount() == 0L) {
                    List<DfsPackDescription> remove = this.toPrune();
                    if (remove.size() > 0) {
                        objdb.commitPack(Collections.emptyList(), remove);
                    }
                    return;
                }
                boolean rollback = true;
                DfsPackDescription pack = objdb.newPack(DfsObjDatabase.PackSource.COMPACT);
                try {
                    DfsPackCompactor.writePack(objdb, pack, pw, pm);
                    DfsPackCompactor.writeIndex(objdb, pack, pw);
                    PackStatistics stats = pw.getStatistics();
                    pw.close();
                    pw = null;
                    pack.setPackStats(stats);
                    objdb.commitPack(Collections.singletonList(pack), this.toPrune());
                    this.newPacks.add(pack);
                    this.newStats.add(stats);
                    rollback = false;
                }
                finally {
                    if (rollback) {
                        objdb.rollbackPack(Collections.singletonList(pack));
                    }
                }
            }
        }
        finally {
            this.rw = null;
        }
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPacks;
    }

    public List<PackStatistics> getNewPackStatistics() {
        return this.newStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.srcPacks.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.srcPacks) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    private void addObjectsToPack(PackWriter pw, DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        Collections.sort(this.srcPacks, new Comparator<DfsPackFile>(){

            @Override
            public int compare(DfsPackFile a, DfsPackFile b) {
                return a.getPackDescription().compareTo(b.getPackDescription());
            }
        });
        this.rw = new RevWalk(ctx);
        this.added = this.rw.newFlag("ADDED");
        this.isBase = this.rw.newFlag("IS_BASE");
        BlockList baseObjects = new BlockList();
        pm.beginTask(JGitText.get().countingObjects, 0);
        for (DfsPackFile src : this.srcPacks) {
            List<ObjectIdWithOffset> want = this.toInclude(src, ctx);
            if (want.isEmpty()) continue;
            PackReverseIndex rev = src.getReverseIdx(ctx);
            DfsObjectRepresentation rep = new DfsObjectRepresentation(src);
            for (ObjectIdWithOffset id : want) {
                RevObject base;
                int type;
                RevObject obj = this.rw.lookupAny(id, type = src.getObjectType(ctx, id.offset));
                if (obj.has(this.added)) continue;
                pm.update(1);
                pw.addObject(obj);
                obj.add(this.added);
                src.representation(rep, id.offset, ctx, rev);
                if (rep.getFormat() != 0 || (base = this.rw.lookupAny(rep.getDeltaBase(), type)).has(this.added) || base.has(this.isBase)) continue;
                baseObjects.add(base);
                base.add(this.isBase);
            }
        }
        for (RevObject obj : baseObjects) {
            if (obj.has(this.added)) continue;
            pm.update(1);
            pw.addObject(obj);
            obj.add(this.added);
        }
        pm.endTask();
    }

    private List<ObjectIdWithOffset> toInclude(DfsPackFile src, DfsReader ctx) throws IOException {
        PackIndex srcIdx = src.getPackIndex(ctx);
        BlockList<ObjectIdWithOffset> want = new BlockList<ObjectIdWithOffset>((int)srcIdx.getObjectCount());
        block0: for (PackIndex.MutableEntry ent : srcIdx) {
            ObjectId id = ent.toObjectId();
            RevObject obj = this.rw.lookupOrNull(id);
            if (obj != null && (obj.has(this.added) || obj.has(this.isBase))) continue;
            for (PackWriter.ObjectIdSet e : this.exclude) {
                if (!e.contains(id)) continue;
                continue block0;
            }
            want.add(new ObjectIdWithOffset(id, ent.getOffset()));
        }
        Collections.sort(want, new Comparator<ObjectIdWithOffset>(){

            @Override
            public int compare(ObjectIdWithOffset a, ObjectIdWithOffset b) {
                return Long.signum(a.offset - b.offset);
            }
        });
        return want;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePack(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw, ProgressMonitor pm) throws IOException {
        try (DfsOutputStream out = objdb.writeFile(pack, PackExt.PACK);){
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIndex(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw) throws IOException {
        try (DfsOutputStream out = objdb.writeFile(pack, PackExt.INDEX);){
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
            pack.setIndexVersion(pw.getIndexVersion());
        }
    }

    private static class ObjectIdWithOffset
    extends ObjectId {
        final long offset;

        ObjectIdWithOffset(AnyObjectId id, long ofs) {
            super(id);
            this.offset = ofs;
        }
    }
}

