/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.ui.model;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.internal.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateHandler;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class ComboUpdateModel
extends AbstractUpdateModel
implements ModifyListener,
SelectionListener {
    private final Combo combo;
    private final String itemsFrom;
    private final String[] choices;
    private final String[] translateChoiceAs;

    public ComboUpdateModel(String name, String itemsFrom, IUpdateHandler handler, Combo combo, String choices, String translateChoiceAs) {
        super(name, handler);
        this.combo = combo;
        this.itemsFrom = itemsFrom;
        this.combo.addModifyListener((ModifyListener)this);
        this.combo.addSelectionListener((SelectionListener)this);
        this.choices = choices != null ? choices.split(",") : null;
        this.translateChoiceAs = translateChoiceAs != null ? translateChoiceAs.split(",") : null;
    }

    public Object getControl() {
        return this.combo;
    }

    public Object getValueFromControl() {
        String selection = WidgetActionUtils.getSelected(this.combo);
        if (this.translateChoiceAs != null && this.choices != null) {
            int i = 0;
            while (i < this.choices.length) {
                if (selection.equals(this.choices[i])) {
                    return this.translateChoiceAs[i];
                }
                ++i;
            }
        }
        return selection;
    }

    public void initialize(ILaunchConfiguration configuration, IVariableMap rmMap, IVariableMap lcMap) {
        if (this.itemsFrom != null) {
            String[] items = WidgetActionUtils.getItemsFrom(rmMap, this.itemsFrom);
            if (items.length == 0) {
                items = WidgetActionUtils.getItemsFrom(lcMap, this.itemsFrom);
            }
            if (this.translateChoiceAs != null && this.choices != null) {
                int i = 0;
                while (i < items.length) {
                    int j = 0;
                    while (j < this.translateChoiceAs.length) {
                        if (items[i].equals(this.translateChoiceAs[j])) {
                            items[i] = this.choices[j];
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            items = WidgetBuilderUtils.normalizeComboItems((String[])items);
            this.combo.setItems(items);
        }
        super.initialize(configuration, rmMap, lcMap);
    }

    public void modifyText(ModifyEvent e) {
        if (this.refreshing) {
            return;
        }
        this.validateJob.cancel();
        this.validateJob.schedule(100L);
    }

    public void refreshValueFromMap() {
        this.refreshing = true;
        this.mapValue = this.lcMap.getValue(this.name);
        String s = "";
        if (this.mapValue != null) {
            s = (String)this.mapValue;
            if (this.translateChoiceAs != null && this.choices != null) {
                int i = 0;
                while (i < this.translateChoiceAs.length) {
                    if (s.equals(this.translateChoiceAs[i])) {
                        s = this.choices[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        s = WidgetActionUtils.select(this.combo, s);
        this.refreshing = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.refreshing) {
            return;
        }
        try {
            Object value = this.storeValue();
            this.handleUpdate(value);
        }
        catch (Exception exception) {}
    }
}

