/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CRegisterManagerModelProxy;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CRegisterManagerProxy
implements IDebugEventSetListener,
IDebugContextListener {
    private CRegisterManager fRegisterManager;
    private ICDebugElement fContext;
    private CRegisterManagerModelProxy fModelProxy;

    public CRegisterManagerProxy(CRegisterManager registerManager) {
        this.fRegisterManager = registerManager;
    }

    public void dispose() {
        this.fRegisterManager = null;
        this.fContext = null;
        this.fModelProxy = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        ICDebugElement context = null;
        ISelection s = event.getContext();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)s;
            context = selection.size() == 1 ? (selection.getFirstElement() instanceof ICDebugElement ? (ICDebugElement)selection.getFirstElement() : null) : null;
        }
        this.setContext(context);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        CRegisterManagerModelProxy modelProxy = this.getModelProxy();
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (this.containsEvent(event)) {
                Object source = event.getSource();
                if (source instanceof ICDebugTarget && (event.getKind() == 2 || event.getKind() == 8)) {
                    if (modelProxy != null) {
                        modelProxy.update();
                    }
                } else if (source instanceof ICDebugTarget && event.getKind() == 16 && event.getDetail() == 512) {
                    if (modelProxy != null) {
                        modelProxy.update();
                    }
                } else if (source instanceof IRegisterGroup && event.getKind() == 16) {
                    if (modelProxy != null) {
                        modelProxy.update();
                    }
                } else if (source instanceof IRegister && event.getKind() == 16) {
                    if (modelProxy != null) {
                        modelProxy.update();
                    }
                } else if (source instanceof ICVariable && event.getKind() == 16) {
                    if (modelProxy != null) {
                        modelProxy.update();
                    }
                } else if (source instanceof ICThread && event.getKind() == 2 && modelProxy != null) {
                    modelProxy.update();
                }
            }
            ++i;
        }
    }

    public IRegisterGroup[] getRegisterGroups() {
        return this.fRegisterManager.getRegisterGroups();
    }

    public void setModelProxy(CRegisterManagerModelProxy modelProxy) {
        this.fModelProxy = modelProxy;
    }

    public CRegisterManagerModelProxy getModelProxy() {
        return this.fModelProxy;
    }

    public String getModelIdentifier() {
        return this.fRegisterManager.getDebugTarget().getModelIdentifier();
    }

    public void setContext(ICDebugElement context) {
        if (this.fContext == null || !this.fContext.equals(context)) {
            this.fContext = context;
            try {
                this.fRegisterManager.setCurrentFrame(this.fContext instanceof ICStackFrame ? (ICStackFrame)context : null);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            CRegisterManagerModelProxy modelProxy = this.getModelProxy();
            if (modelProxy != null) {
                modelProxy.update();
            }
        }
    }

    private boolean containsEvent(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof ICDebugElement) {
            return this.fRegisterManager.getDebugTarget().equals(((ICDebugElement)source).getDebugTarget());
        }
        return false;
    }
}

