/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.exception.ConnectionExistsException;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteConnection;
import org.eclipse.remote.internal.core.RemoteConnectionWorkingCopy;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.RemoteServicesManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RemoteConnectionType
implements IRemoteConnectionType {
    private final RemoteServicesManager remoteServicesManager;
    private final String id;
    private final String name;
    private final String scheme;
    private final boolean canAdd;
    private final boolean canEdit;
    private final boolean canRemove;
    private final Map<Class<? extends IRemoteConnectionType.Service>, Object> serviceMap = new HashMap<Class<? extends IRemoteConnectionType.Service>, Object>();
    private final Map<String, IConfigurationElement> serviceDefinitionMap = new HashMap<String, IConfigurationElement>();
    private final Map<String, IConfigurationElement> connectionServiceDefinitionMap = new HashMap<String, IConfigurationElement>();
    private final Map<String, IConfigurationElement> processServiceDefinitionMap = new HashMap<String, IConfigurationElement>();
    private final Map<String, RemoteConnection> connections = new HashMap<String, RemoteConnection>();

    public RemoteConnectionType(IConfigurationElement ce, RemoteServicesManager manager) {
        this.remoteServicesManager = manager;
        this.id = ce.getAttribute("id");
        this.name = ce.getAttribute("name");
        this.scheme = ce.getAttribute("scheme");
        String canAddStr = ce.getAttribute("canAdd");
        this.canAdd = canAddStr != null ? Boolean.parseBoolean(canAddStr) : true;
        String canEditStr = ce.getAttribute("canEdit");
        this.canEdit = canEditStr != null ? Boolean.parseBoolean(canEditStr) : true;
        String canRemoveStr = ce.getAttribute("canRemove");
        this.canRemove = canRemoveStr != null ? Boolean.parseBoolean(canRemoveStr) : true;
        try {
            String[] stringArray = this.getPreferenceNode().childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionName = stringArray[n2];
                this.connections.put(connectionName, new RemoteConnection(this, connectionName));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            RemoteCorePlugin.log(e);
        }
    }

    Preferences getPreferenceNode() {
        return this.remoteServicesManager.getPreferenceNode().node(this.id);
    }

    ISecurePreferences getSecurePreferencesNode() {
        return this.remoteServicesManager.getSecurePreferenceNode().node(this.id);
    }

    @Override
    public IRemoteServicesManager getRemoteServicesManager() {
        return this.remoteServicesManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean canAdd() {
        return this.canAdd;
    }

    @Override
    public boolean canEdit() {
        return this.canEdit;
    }

    @Override
    public boolean canRemove() {
        return this.canRemove;
    }

    @Override
    public <T extends IRemoteConnectionType.Service> T getService(Class<T> service) {
        IConfigurationElement ce;
        IRemoteConnectionType.Service obj = (IRemoteConnectionType.Service)this.serviceMap.get(service);
        if (obj == null && (ce = this.serviceDefinitionMap.get(service.getName())) != null) {
            try {
                IRemoteConnectionType.Service.Factory factory = (IRemoteConnectionType.Service.Factory)ce.createExecutableExtension("factory");
                if (factory != null) {
                    obj = factory.getService(this, service);
                    this.serviceMap.put(service, obj);
                }
            }
            catch (CoreException e) {
                RemoteCorePlugin.log(e.getStatus());
            }
        }
        return (T)obj;
    }

    @Override
    public List<String> getServices() {
        return new ArrayList<String>(this.serviceDefinitionMap.keySet());
    }

    @Override
    public <T extends IRemoteConnectionType.Service> boolean hasService(Class<T> service) {
        return this.serviceDefinitionMap.get(service.getName()) != null;
    }

    public <T extends IRemoteConnection.Service> T getConnectionService(IRemoteConnection connection, Class<T> service) {
        IConfigurationElement ce = this.connectionServiceDefinitionMap.get(service.getName());
        if (ce != null) {
            try {
                IRemoteConnection.Service.Factory factory = (IRemoteConnection.Service.Factory)ce.createExecutableExtension("factory");
                if (factory != null) {
                    return factory.getService(connection, service);
                }
            }
            catch (CoreException e) {
                RemoteCorePlugin.log(e.getStatus());
            }
        }
        return null;
    }

    @Override
    public List<String> getConnectionServices() {
        return new ArrayList<String>(this.connectionServiceDefinitionMap.keySet());
    }

    @Override
    public <T extends IRemoteConnection.Service> boolean hasConnectionService(Class<T> service) {
        return this.connectionServiceDefinitionMap.get(service.getName()) != null;
    }

    public <T extends IRemoteProcess.Service> T getProcessService(IRemoteProcess process, Class<T> service) {
        IConfigurationElement ce = this.processServiceDefinitionMap.get(service.getName());
        if (ce != null) {
            try {
                IRemoteProcess.Service.Factory factory = (IRemoteProcess.Service.Factory)ce.createExecutableExtension("factory");
                if (factory != null) {
                    return factory.getService(process, service);
                }
            }
            catch (CoreException e) {
                RemoteCorePlugin.log(e.getStatus());
            }
        }
        return null;
    }

    @Override
    public List<String> getProcessServices() {
        return new ArrayList<String>(this.processServiceDefinitionMap.keySet());
    }

    @Override
    public <T extends IRemoteProcess.Service> boolean hasProcessService(Class<T> service) {
        return this.processServiceDefinitionMap.get(service.getName()) != null;
    }

    public void addService(IConfigurationElement ce) {
        String name;
        String serviceName = ce.getAttribute("service");
        switch (name = ce.getName()) {
            case "connectionTypeService": {
                this.serviceDefinitionMap.put(serviceName, ce);
                break;
            }
            case "connectionService": {
                this.connectionServiceDefinitionMap.put(serviceName, ce);
                break;
            }
            case "processService": {
                this.processServiceDefinitionMap.put(serviceName, ce);
            }
        }
    }

    protected void connectionAdded(IRemoteConnection connection) {
        RemoteConnectionChangeEvent event = new RemoteConnectionChangeEvent(connection, 16);
        this.remoteServicesManager.fireRemoteConnectionChangeEvent(event);
    }

    protected void connectionRemoved(IRemoteConnection connection) {
        RemoteConnectionChangeEvent event = new RemoteConnectionChangeEvent(connection, 16);
        this.remoteServicesManager.fireRemoteConnectionChangeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRemoteConnection getConnection(String name) {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            return this.connections.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRemoteConnection getConnection(URI uri) {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            IRemoteConnection connection = this.connections.get(uri.getAuthority());
            if (connection != null) {
                return connection;
            }
            if (uri.getScheme().equals("file") && !this.connections.isEmpty()) {
                return this.connections.values().iterator().next();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRemoteConnection> getConnections() {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            return new ArrayList<IRemoteConnection>(this.connections.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRemoteConnectionWorkingCopy newConnection(String name) throws RemoteConnectionException {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            if (this.connections.containsKey(name)) {
                throw new ConnectionExistsException(name);
            }
            return new RemoteConnectionWorkingCopy(this, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(RemoteConnection remoteConnection) {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            this.connections.put(remoteConnection.getName(), remoteConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(String name) {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            this.connections.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(IRemoteConnection connection) throws RemoteConnectionException {
        Map<String, RemoteConnection> map = this.connections;
        synchronized (map) {
            if (connection instanceof RemoteConnection) {
                connection.close();
                RemoteConnection conn = (RemoteConnection)connection;
                try {
                    conn.getPreferences().removeNode();
                }
                catch (BackingStoreException e) {
                    throw new RemoteConnectionException(e);
                }
                conn.getSecurePreferences().removeNode();
                this.connections.remove(conn.getName());
                connection.fireConnectionChangeEvent(32);
            } else {
                RemoteCorePlugin.log("Wrong class for " + connection.getName() + ", was " + connection.getClass().getName());
            }
        }
    }
}

