/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabListContentProvider;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractOverridableTabListPropertySection;
import org.eclipse.ui.views.properties.tabbed.IOverridableTabListContentProvider;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabItem;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class OverridableTabListContentProvider
extends TabListContentProvider
implements IOverridableTabListContentProvider,
ITabSelectionListener {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private TabbedPropertyViewer tabbedPropertyViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OverridableTabListContentProvider(TabbedPropertyRegistry registry) {
        super(registry);
    }

    public Object[] getElements(Object inputElement) {
        if (this.tabbedPropertySheetPage.getCurrentTab() == null) {
            return this.registry.getTabDescriptors(this.currentPart, (ISelection)inputElement);
        }
        return this.getOverrideTabs(inputElement);
    }

    public void dispose() {
        this.stopListening();
        this.tabbedPropertyViewer = null;
        this.currentPart = null;
        this.tabbedPropertySheetPage = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.tabbedPropertyViewer == null) {
            Assert.isTrue((boolean)(viewer instanceof TabbedPropertyViewer));
            this.init((TabbedPropertyViewer)viewer);
        }
    }

    private void init(TabbedPropertyViewer newTabbedPropertyViewer) {
        IPropertySheetPage page;
        this.tabbedPropertyViewer = newTabbedPropertyViewer;
        this.currentPart = this.tabbedPropertyViewer.getWorkbenchPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((page = (IPropertySheetPage)Adapters.adapt((Object)this.currentPart, (Class)clazz)) instanceof TabbedPropertySheetPage) {
            this.tabbedPropertySheetPage = (TabbedPropertySheetPage)page;
        } else {
            IWorkbenchPart part;
            IContributedContentsView view;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IContributedContentsView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (IContributedContentsView)Adapters.adapt((Object)this.currentPart, (Class)clazz2)) != null && (part = view.getContributingPart()) != null) {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((page = (IPropertySheetPage)Adapters.adapt((Object)part, (Class)clazz3)) instanceof TabbedPropertySheetPage) {
                    this.tabbedPropertySheetPage = (TabbedPropertySheetPage)page;
                }
            }
        }
        Assert.isNotNull((Object)((Object)this.tabbedPropertySheetPage), (String)"DynamicTabListContentProvider could not find the TabbedPropertySheetPage for the active part");
        this.startListening();
    }

    private void startListening() {
        this.tabbedPropertySheetPage.addTabSelectionListener(this);
    }

    private void stopListening() {
        this.tabbedPropertySheetPage.removeTabSelectionListener(this);
    }

    public void tabSelected(ITabDescriptor tabDescriptor) {
        AbstractOverridableTabListPropertySection section = this.getOverridableTabListPropertySection();
        Assert.isNotNull((Object)section);
        int selectedIndex = this.tabbedPropertyViewer.getSelectionIndex();
        section.selectTab(selectedIndex);
    }

    private void setSelectedTab() {
        AbstractOverridableTabListPropertySection section;
        TabDescriptor currentSelectedTabInList = null;
        IStructuredSelection selectionFromList = (IStructuredSelection)this.tabbedPropertyViewer.getSelection();
        if (!selectionFromList.equals(StructuredSelection.EMPTY)) {
            currentSelectedTabInList = (TabDescriptor)selectionFromList.getFirstElement();
        }
        if ((section = this.getOverridableTabListPropertySection()) == null) {
            TabDescriptor newSelectedTab;
            if (currentSelectedTabInList == null && (newSelectedTab = (TabDescriptor)this.tabbedPropertyViewer.getElementAt(0)) != null) {
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedTab), true);
            }
            return;
        }
        ITabItem[] dynamicTabItems = section.getTabs();
        if (dynamicTabItems == null) {
            return;
        }
        int selectedTabIndex = -1;
        int i = 0;
        while (i < dynamicTabItems.length) {
            if (dynamicTabItems[i].isSelected()) {
                selectedTabIndex = i;
            }
            ++i;
        }
        if (currentSelectedTabInList == null || !currentSelectedTabInList.getText().equals(dynamicTabItems[selectedTabIndex].getText())) {
            TabDescriptor newSelectedTab = (TabDescriptor)this.tabbedPropertyViewer.getElementAt(selectedTabIndex);
            this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedTab), true);
        }
    }

    private ITabDescriptor[] getOverrideTabs(Object inputElement) {
        ITabDescriptor[] tabDescriptors = this.registry.getTabDescriptors(this.currentPart, (ISelection)inputElement);
        if (tabDescriptors == TabbedPropertyRegistry.EMPTY_DESCRIPTOR_ARRAY) {
            return tabDescriptors;
        }
        AbstractOverridableTabListPropertySection section = this.getOverridableTabListPropertySection();
        Assert.isNotNull((Object)section);
        ITabItem[] tabItems = section.getTabs();
        if (tabItems == null) {
            return tabDescriptors;
        }
        ITabDescriptor[] overrideTabDescriptors = new ITabDescriptor[tabItems.length];
        TabDescriptor target = (TabDescriptor)tabDescriptors[0];
        int i = 0;
        while (i < tabItems.length) {
            TabDescriptor cloneTabDescriptor = (TabDescriptor)target.clone();
            cloneTabDescriptor.setLabel(tabItems[i].getText());
            cloneTabDescriptor.setImage(tabItems[i].getImage());
            cloneTabDescriptor.setIndented(tabItems[i].isIndented());
            cloneTabDescriptor.setSelected(tabItems[i].isSelected());
            overrideTabDescriptors[i] = cloneTabDescriptor;
            ++i;
        }
        return overrideTabDescriptors;
    }

    public void overrideTabs() {
        this.stopListening();
        Object input = this.tabbedPropertyViewer.getInput();
        this.tabbedPropertyViewer.setInput(input);
        this.setSelectedTab();
        this.startListening();
    }

    private AbstractOverridableTabListPropertySection getOverridableTabListPropertySection() {
        ISection section;
        TabContents tab = this.tabbedPropertySheetPage.getCurrentTab();
        Assert.isNotNull((Object)tab);
        if (tab != null && (section = tab.getSectionAtIndex(0)) instanceof AbstractOverridableTabListPropertySection) {
            return (AbstractOverridableTabListPropertySection)section;
        }
        return null;
    }
}

