/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import org.eclipse.cdt.core.build.CConsoleParser;
import org.eclipse.cdt.core.build.CToolChain;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.build.ScannerInfoData;
import org.eclipse.cdt.internal.core.build.ToolChainScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public abstract class CBuildConfiguration
extends PlatformObject {
    private static final String TOOLCHAIN = "cdt.toolChain";
    private final IBuildConfiguration config;
    private CToolChain toolChain;
    private ScannerInfoData scannerInfoData;

    protected CBuildConfiguration(IBuildConfiguration config) {
        this.config = config;
    }

    public IBuildConfiguration getBuildConfiguration() {
        return this.config;
    }

    public String getName() {
        return this.config.getName();
    }

    public IProject getProject() {
        return this.config.getProject();
    }

    public void setActive(IProgressMonitor monitor) throws CoreException {
        IProject project = this.config.getProject();
        if (this.config.equals(project.getActiveBuildConfig())) {
            return;
        }
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setActiveBuildConfig(this.config.getName());
        project.setDescription(projectDesc, monitor);
    }

    protected IEclipsePreferences getSettings() {
        return (IEclipsePreferences)new ProjectScope(this.config.getProject()).getNode("org.eclipse.cdt.core").node("config").node(this.config.getName());
    }

    private synchronized CToolChain getToolChain(String id) throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.cdt.core.ToolChain");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String clsName;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String eid = element.getAttribute("id");
                if (id.equals(eid) && (clsName = element.getAttribute("adaptor")) != null) {
                    try {
                        Class<?> cls = Class.forName(clsName);
                        return (CToolChain)((Object)this.getAdapter(cls));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "creating toolchain", (Throwable)e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void setToolChain(CToolChain toolChain) throws CoreException {
        this.toolChain = toolChain;
        IEclipsePreferences settings = this.getSettings();
        settings.put(TOOLCHAIN, toolChain.getId());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", "saving toolchain id", (Throwable)e));
        }
    }

    public CToolChain getToolChain() throws CoreException {
        if (this.toolChain == null) {
            IEclipsePreferences settings = this.getSettings();
            String id = settings.get(TOOLCHAIN, "");
            if (id.isEmpty()) {
                return null;
            }
            this.toolChain = this.getToolChain(id);
        }
        return this.toolChain;
    }

    public IScannerInfo getScannerInfo(IResource resource) throws CoreException {
        return this.getScannerInfoData().getScannerInfo(resource);
    }

    public void putScannerInfo(ILanguage language, ExtendedScannerInfo info) {
        this.getScannerInfoData().putScannerInfo(language, info);
    }

    public void putScannerInfo(IResource resource, ToolChainScannerInfo info) {
        this.getScannerInfoData().putScannerInfo(resource, info);
    }

    private ScannerInfoData getScannerInfoData() {
        if (this.scannerInfoData == null) {
            this.scannerInfoData = ScannerInfoData.load(this);
        }
        return this.scannerInfoData;
    }

    public void clearScannerInfo() throws CoreException {
        this.scannerInfoData = null;
    }

    public CConsoleParser[] getConsoleParsers() throws CoreException {
        CToolChain toolChain = this.getToolChain();
        return toolChain != null ? toolChain.getConsoleParsers() : null;
    }
}

