/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.build.ScannerInfoSaveParticipant;
import org.eclipse.cdt.internal.core.build.ToolChainScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.osgi.framework.Bundle;

public class ScannerInfoData {
    private Set<ToolChainScannerInfo> perResourceInfo;
    private Map<String, ToolChainScannerInfo> perLanguageInfo;
    private transient Path savePath;
    private transient Map<ToolChainScannerInfo, ToolChainScannerInfo> infoCache;
    private transient Map<String, ToolChainScannerInfo> resourceCache;

    public void createCache() {
        this.infoCache = new HashMap<ToolChainScannerInfo, ToolChainScannerInfo>();
        this.resourceCache = new HashMap<String, ToolChainScannerInfo>();
        if (this.perResourceInfo != null) {
            for (ToolChainScannerInfo info : this.perResourceInfo) {
                this.infoCache.put(info, info);
                for (String path : info.getResourcePaths()) {
                    this.resourceCache.put(path, info);
                }
            }
        }
    }

    private boolean perResource() {
        return this.perResourceInfo != null && !this.perResourceInfo.isEmpty();
    }

    private boolean perLanguage() {
        return this.perLanguageInfo != null && !this.perLanguageInfo.isEmpty();
    }

    public IScannerInfo getScannerInfo(IResource resource) {
        ILanguage language;
        ToolChainScannerInfo info;
        IProject project;
        IContentType contentType;
        ToolChainScannerInfo info2;
        if (this.perResource() && (info2 = this.resourceCache.get(resource.getFullPath().toString())) != null) {
            return info2.getScannerInfo();
        }
        if (this.perLanguage() && (contentType = CCorePlugin.getContentType(project = resource.getProject(), resource.getName())) != null && (info = this.perLanguageInfo.get((language = LanguageManager.getInstance().getLanguage(contentType, project)).getId())) != null) {
            return info.getScannerInfo();
        }
        return null;
    }

    public IScannerInfo getScannerInfo(ILanguage language) {
        ToolChainScannerInfo info;
        if (this.perLanguage() && (info = this.perLanguageInfo.get(language.getId())) != null) {
            return info.getScannerInfo();
        }
        return null;
    }

    public void putScannerInfo(IResource resource, ToolChainScannerInfo info) {
        if (this.perResourceInfo == null) {
            this.perResourceInfo = new HashSet<ToolChainScannerInfo>();
            this.infoCache = new HashMap<ToolChainScannerInfo, ToolChainScannerInfo>();
            this.infoCache.put(info, info);
        } else {
            ToolChainScannerInfo existing = this.infoCache.get(info);
            if (existing != null) {
                info = existing;
            } else {
                this.perResourceInfo.add(info);
                this.infoCache.put(info, info);
            }
        }
        info.addResource(resource);
        this.resourceCache.put(resource.getFullPath().toString(), info);
        this.queueSave();
    }

    public void putScannerInfo(ILanguage language, ExtendedScannerInfo info) {
        if (this.perLanguageInfo == null) {
            this.perLanguageInfo = new HashMap<String, ToolChainScannerInfo>();
        }
        this.perLanguageInfo.put(language.getId(), new ToolChainScannerInfo(info));
        this.queueSave();
    }

    public static ScannerInfoData load(CBuildConfiguration config) {
        IPath stateLoc = Platform.getStateLocation((Bundle)CCorePlugin.getDefault().getBundle());
        IPath scannerInfoPath = stateLoc.append(config.getProject().getName()).append(String.valueOf(config.getName()) + ".scInfo");
        File scannerInfoFile = scannerInfoPath.toFile();
        ScannerInfoData info = null;
        if (scannerInfoFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader reader = new FileReader(scannerInfoFile);){
                    info = (ScannerInfoData)new Gson().fromJson((Reader)reader, ScannerInfoData.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                CCorePlugin.log(e);
            }
        }
        if (info == null) {
            info = new ScannerInfoData();
        }
        info.savePath = scannerInfoFile.toPath();
        info.createCache();
        return info;
    }

    public void save() {
        try {
            String json = new Gson().toJson((Object)this);
            Files.createDirectories(this.savePath.getParent(), new FileAttribute[0]);
            Files.write(this.savePath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    public void queueSave() {
        ScannerInfoSaveParticipant.getInstance().save(this);
    }

    public void clear() {
        this.perLanguageInfo = null;
        this.perResourceInfo = null;
        this.createCache();
        this.queueSave();
    }
}

