/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.macho.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.macho.AR;
import org.eclipse.cdt.utils.macho.MachO;
import org.eclipse.cdt.utils.macho.MachOHelper;
import org.eclipse.cdt.utils.macho.parser.MachOParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

@Deprecated
public class MachOBinaryObject
extends BinaryObjectAdapter {
    protected AR.ARHeader header;
    protected IAddressFactory addressFactory;
    protected MachO.Attribute attributes;
    protected MachOHelper.Sizes sizes;
    protected IBinaryParser.ISymbol[] symbols;
    protected String soname;
    protected String[] needed;
    protected long timeStamp;
    private static final String[] NO_NEEDED = new String[0];

    public MachOBinaryObject(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, 1);
        this.header = header;
    }

    public MachOBinaryObject(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    @Override
    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        return new BinaryObjectAdapter.BinaryObjectInfo(this);
    }

    @Override
    public InputStream getContents() throws IOException {
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        return super.getContents();
    }

    protected MachOHelper getMachOHelper() throws IOException {
        IPath path = this.getPath();
        if (path != null) {
            if (this.header != null) {
                return new MachOHelper(path.toOSString(), this.header.getObjectDataOffset());
            }
            return new MachOHelper(path.toOSString());
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    @Override
    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            this.addressFactory = new Addr32Factory();
        }
        return this.addressFactory;
    }

    protected void clearCachedValues() {
        this.attributes = null;
        this.sizes = null;
        this.symbols = null;
        this.soname = null;
        this.needed = null;
    }

    protected MachO.Attribute internalGetAttributes() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.attributes == null) {
            MachOHelper helper = null;
            try {
                try {
                    helper = this.getMachOHelper();
                    if (helper != null) {
                        this.attributes = helper.getMachO().getAttributes();
                    }
                }
                catch (IOException iOException) {
                    if (helper != null) {
                        helper.dispose();
                    }
                }
            }
            finally {
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        return this.attributes;
    }

    protected MachOHelper.Sizes internalGetSizes() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.sizes == null) {
            MachOHelper helper = null;
            try {
                try {
                    helper = this.getMachOHelper();
                    if (helper != null) {
                        this.sizes = helper.getSizes();
                        if (this.attributes == null) {
                            this.attributes = helper.getMachO().getAttributes();
                        }
                    }
                }
                catch (IOException iOException) {
                    if (helper != null) {
                        helper.dispose();
                    }
                }
            }
            finally {
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        return this.sizes;
    }

    protected IBinaryParser.ISymbol[] internalGetSymbols() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.symbols == null) {
            this.loadBinaryInfo();
        }
        return this.symbols;
    }

    protected String internalGetSoName() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.soname == null) {
            this.loadBinaryInfo();
        }
        return this.soname;
    }

    protected String[] internalGetNeeded() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.needed == null) {
            this.loadBinaryInfo();
        }
        return this.needed;
    }

    protected void loadBinaryInfo() {
        MachOHelper helper = null;
        try {
            try {
                helper = this.getMachOHelper();
                if (helper != null) {
                    this.symbols = this.loadSymbols(helper);
                    Arrays.sort(this.symbols);
                    this.soname = helper.getSoname();
                    this.needed = helper.getNeeded();
                    if (this.sizes == null) {
                        this.sizes = helper.getSizes();
                    }
                    if (this.attributes == null) {
                        this.attributes = helper.getMachO().getAttributes();
                    }
                }
            }
            catch (IOException e) {
                this.symbols = this.NO_SYMBOLS;
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    protected IBinaryParser.ISymbol[] loadSymbols(MachOHelper helper) throws IOException {
        CPPFilt cppfilt = null;
        try {
            ArrayList<Symbol> list = new ArrayList<Symbol>();
            helper.getMachO().setCppFilter(false);
            cppfilt = this.getCPPFilt();
            this.addSymbols(helper.getExternalFunctions(), 1, cppfilt, list);
            this.addSymbols(helper.getLocalFunctions(), 1, cppfilt, list);
            this.addSymbols(helper.getExternalObjects(), 2, cppfilt, list);
            this.addSymbols(helper.getLocalObjects(), 2, cppfilt, list);
            IBinaryParser.ISymbol[] iSymbolArray = list.toArray(new IBinaryParser.ISymbol[list.size()]);
            return iSymbolArray;
        }
        finally {
            if (cppfilt != null) {
                cppfilt.dispose();
            }
        }
    }

    protected CPPFilt getCPPFilt() {
        MachOParser parser = (MachOParser)this.getBinaryParser();
        return parser.getCPPFilt();
    }

    private void addSymbols(MachO.Symbol[] array, int type, CPPFilt cppfilt, List<Symbol> list) {
        MachO.Symbol[] symbolArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            MachO.Symbol element = symbolArray[n2];
            String name = element.toString();
            if (cppfilt != null) {
                try {
                    name = cppfilt.getFunction(name);
                }
                catch (IOException e1) {
                    cppfilt = null;
                }
            }
            long addr = element.n_value;
            int size = 0;
            String filename = element.getFilename();
            Path filePath = filename != null ? new Path(filename) : null;
            list.add(new Symbol(this, name, type, new Addr32(element.n_value), size, (IPath)filePath, element.getLineNumber(addr), element.getLineNumber(addr + (long)size - 1L)));
            ++n2;
        }
    }

    @Override
    public String getCPU() {
        MachO.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.getCPU();
        }
        return "";
    }

    @Override
    public boolean hasDebug() {
        MachO.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.hasDebug();
        }
        return false;
    }

    @Override
    public boolean isLittleEndian() {
        MachO.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.isLittleEndian();
        }
        return false;
    }

    @Override
    public long getBSS() {
        MachOHelper.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.bss;
        }
        return 0L;
    }

    @Override
    public long getData() {
        MachOHelper.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.data;
        }
        return 0L;
    }

    @Override
    public long getText() {
        MachOHelper.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.text;
        }
        return 0L;
    }

    @Override
    public IBinaryParser.ISymbol[] getSymbols() {
        IBinaryParser.ISymbol[] syms = this.internalGetSymbols();
        if (syms != null) {
            return syms;
        }
        return this.NO_SYMBOLS;
    }

    @Override
    public IBinaryParser.ISymbol getSymbol(IAddress addr) {
        return super.getSymbol(addr);
    }

    @Override
    public String[] getNeededSharedLibs() {
        String[] libs = this.internalGetNeeded();
        if (libs != null) {
            return libs;
        }
        return NO_NEEDED;
    }

    @Override
    public String getSoName() {
        String name = this.internalGetSoName();
        if (name != null) {
            return name;
        }
        return "";
    }

    @Override
    protected boolean hasChanged() {
        long modification;
        File file;
        IPath path = this.getPath();
        if (path != null && (file = path.toFile()) != null && (modification = file.lastModified()) != this.timeStamp) {
            this.timeStamp = modification;
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        MachO macho;
        if (adapter.equals(MachO.class)) {
            try {
                return new MachO(this.getPath().toOSString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (adapter.equals(ISymbolReader.class) && (macho = (MachO)this.getAdapter(MachO.class)) != null) {
            return macho.getSymbolReader();
        }
        return super.getAdapter(adapter);
    }
}

