/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemotePortForwardingService;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IUserAuthenticatorService;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.AddressInUseException;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.exception.UnableToForwardPortException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchConnectionProxyFactory;
import org.eclipse.remote.internal.jsch.core.JSchProcessBuilder;
import org.eclipse.remote.internal.jsch.core.commands.ExecCommand;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchConnection
implements IRemoteConnectionControlService,
IRemoteConnectionPropertyService,
IRemotePortForwardingService,
IRemoteProcessService,
IRemoteConnectionHostService,
IRemoteConnectionChangeListener {
    public static final String JSCH_ID = "org.eclipse.remote.JSch";
    public static final String ADDRESS_ATTR = "JSCH_ADDRESS_ATTR";
    public static final String USERNAME_ATTR = "JSCH_USERNAME_ATTR";
    public static final String PASSWORD_ATTR = "JSCH_PASSWORD_ATTR";
    public static final String PORT_ATTR = "JSCH_PORT_ATTR";
    public static final String PROXYCONNECTION_ATTR = "JSCH_PROXYCONNECTION_ATTR";
    public static final String PROXYCOMMAND_ATTR = "JSCH_PROXYCOMMAND_ATTR";
    public static final String IS_PASSWORD_ATTR = "JSCH_IS_PASSWORD_ATTR";
    public static final String PASSPHRASE_ATTR = "JSCH_PASSPHRASE_ATTR";
    public static final String TIMEOUT_ATTR = "JSCH_TIMEOUT_ATTR";
    public static final String USE_LOGIN_SHELL_ATTR = "JSCH_USE_LOGIN_SHELL_ATTR";
    public static final String LOGIN_SHELL_COMMAND_ATTR = "JSCH_LOGIN_SHELL_COMMAND_ATTR";
    private final boolean logging = false;
    public static final int DEFAULT_PORT = 22;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final boolean DEFAULT_IS_PASSWORD = false;
    public static final boolean DEFAULT_USE_LOGIN_SHELL = true;
    public static final String DEFAULT_LOGIN_SHELL_COMMAND = "/bin/bash -l -c '{0}'";
    public static final String EMPTY_STRING = "";
    private String fWorkingDir;
    private final IRemoteConnection fRemoteConnection;
    private final IJSchService fJSchService;
    private final Map<String, String> fEnv = new HashMap<String, String>();
    private final Map<String, String> fProperties = new HashMap<String, String>();
    private final List<Session> fSessions = new ArrayList<Session>();
    private ChannelSftp fSftpChannel;
    private boolean isFullySetup;
    private static final Map<IRemoteConnection, JSchConnection> connectionMap = new HashMap<IRemoteConnection, JSchConnection>();

    public JSchConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
        this.fJSchService = Activator.getDefault().getService();
        connection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(RemoteConnectionChangeEvent event) {
        if (event.getType() == 32) {
            Map<IRemoteConnection, JSchConnection> map = connectionMap;
            synchronized (map) {
                connectionMap.remove(event.getConnection());
            }
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fRemoteConnection;
    }

    private boolean checkConfiguration(Session session, IProgressMonitor monitor) throws RemoteConnectionException {
        ChannelSftp sftp;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            sftp = this.openSftpChannel(session);
        }
        catch (RemoteConnectionException remoteConnectionException) {
            throw new RemoteConnectionException(Messages.JSchConnection_Remote_host_does_not_support_sftp);
        }
        try {
            try {
                this.loadEnv((IProgressMonitor)subMon.newChild(10));
            }
            catch (RemoteConnectionException e) {
                if (e.getMessage().contains("channel is not opened")) {
                    if (sftp != null) {
                        sftp.disconnect();
                    }
                    return false;
                }
                if (sftp != null) {
                    sftp.disconnect();
                }
            }
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
        return true;
    }

    private void checkIsConfigured() throws RemoteConnectionException {
        if (this.fRemoteConnection.getAttribute(ADDRESS_ATTR) == null) {
            throw new RemoteConnectionException(Messages.JSchConnection_remote_address_must_be_set);
        }
        if (this.fRemoteConnection.getAttribute(USERNAME_ATTR) == null) {
            throw new RemoteConnectionException(Messages.JSchConnection_username_must_be_set);
        }
    }

    private synchronized void cleanup() {
        if (this.fSftpChannel != null) {
            if (this.fSftpChannel.isConnected()) {
                this.fSftpChannel.disconnect();
            }
            this.fSftpChannel = null;
        }
        for (Session session : this.fSessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        this.fSessions.clear();
    }

    public synchronized void close() {
        this.cleanup();
        this.fRemoteConnection.fireConnectionChangeEvent(1);
    }

    private String executeCommand(String cmd, IProgressMonitor monitor) throws RemoteConnectionException {
        ExecCommand exec = new ExecCommand(this);
        monitor.subTask(NLS.bind((String)Messages.JSchConnection_Executing_command, (Object)cmd));
        return exec.setCommand(cmd).getResult(monitor).trim();
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).setPortForwardingL(localPort, fwdAddress, fwdPort);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.JSchConnection_forwarding, 10);
        int localPort = fwdPort + 1;
        if (!progress.isCanceled()) {
            try {
                this.forwardLocalPort(localPort, fwdAddress, fwdPort);
            }
            catch (AddressInUseException addressInUseException) {
                if (++localPort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.JSchConnection_remotePort);
                }
                progress.worked(1);
            }
            return localPort;
        }
        return -1;
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).setPortForwardingR(remotePort, fwdAddress, fwdPort);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.beginTask(Messages.JSchConnection_forwarding, 10);
        int remotePort = fwdPort + 1;
        while (!progress.isCanceled()) {
            try {
                this.forwardRemotePort(remotePort, fwdAddress, fwdPort);
                return remotePort;
            }
            catch (AddressInUseException addressInUseException) {
                if (++remotePort == fwdPort) {
                    throw new UnableToForwardPortException(Messages.JSchConnection_remotePort);
                }
                progress.worked(1);
            }
        }
        return -1;
    }

    public String getHostname() {
        return this.fRemoteConnection.getAttribute(ADDRESS_ATTR);
    }

    private String getCwd(IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            return this.executeCommand("pwd", (IProgressMonitor)subMon.newChild(10));
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return null;
        }
    }

    public Map<String, String> getEnv() {
        return Collections.unmodifiableMap(this.fEnv);
    }

    public String getEnv(String name) {
        return this.getEnv().get(name);
    }

    public ChannelExec getExecChannel() throws RemoteConnectionException {
        try {
            return (ChannelExec)this.fSessions.get(0).openChannel("exec");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public ChannelShell getShellChannel() throws RemoteConnectionException {
        try {
            return (ChannelShell)this.fSessions.get(0).openChannel("shell");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public String getPassphrase() {
        return this.fRemoteConnection.getSecureAttribute(PASSPHRASE_ATTR);
    }

    public String getPassword() {
        return this.fRemoteConnection.getSecureAttribute(PASSWORD_ATTR);
    }

    public int getPort() {
        String portStr = this.fRemoteConnection.getAttribute(PORT_ATTR);
        return !portStr.isEmpty() ? Integer.parseInt(portStr) : 22;
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new JSchProcessBuilder(this.getRemoteConnection(), command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new JSchProcessBuilder(this.getRemoteConnection(), command);
    }

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public String getLoginShellCommand() {
        String loginShell = this.fRemoteConnection.getAttribute(LOGIN_SHELL_COMMAND_ATTR);
        return loginShell.isEmpty() ? DEFAULT_LOGIN_SHELL_COMMAND : loginShell;
    }

    public String getProxyCommand() {
        return this.fRemoteConnection.getAttribute(PROXYCOMMAND_ATTR);
    }

    public JSchConnection getProxyConnection() {
        String proxyConnectionName = this.getProxyConnectionName();
        if (proxyConnectionName.isEmpty()) {
            return null;
        }
        return (JSchConnection)this.fRemoteConnection.getConnectionType().getConnection(proxyConnectionName).getService(JSchConnection.class);
    }

    public String getProxyConnectionName() {
        return this.fRemoteConnection.getAttribute(PROXYCONNECTION_ATTR);
    }

    public ChannelSftp getSftpChannel() throws RemoteConnectionException {
        if (this.fSftpChannel == null || this.fSftpChannel.isClosed()) {
            Session session = this.fSessions.get(0);
            if (this.fSessions.size() > 1) {
                session = this.fSessions.get(1);
            }
            this.fSftpChannel = this.openSftpChannel(session);
            if (this.fSftpChannel == null) {
                throw new RemoteConnectionException(Messages.JSchConnection_Unable_to_open_sftp_channel);
            }
        }
        return this.fSftpChannel;
    }

    public Channel getStreamForwarder(String host, int port) throws RemoteConnectionException {
        try {
            Channel channel = this.fSessions.get(0).getStreamForwarder(host, port);
            channel.connect();
            return channel;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException((Throwable)e);
        }
    }

    public int getTimeout() {
        String str = this.fRemoteConnection.getAttribute(TIMEOUT_ATTR);
        return !str.isEmpty() ? Integer.parseInt(str) : 0;
    }

    public String getUsername() {
        return this.fRemoteConnection.getAttribute(USERNAME_ATTR);
    }

    public String getWorkingDirectory() {
        if (!this.isOpen()) {
            return "/";
        }
        if (this.fWorkingDir == null) {
            return "/";
        }
        return this.fWorkingDir;
    }

    public boolean hasOpenSession() {
        boolean hasOpenSession;
        boolean bl = hasOpenSession = this.fSessions.size() > 0;
        if (hasOpenSession) {
            for (Session session : this.fSessions) {
                hasOpenSession &= session.isConnected();
            }
        }
        if (!hasOpenSession) {
            this.cleanup();
        }
        return hasOpenSession;
    }

    public boolean isOpen() {
        return this.hasOpenSession() && this.isFullySetup;
    }

    public boolean isPasswordAuth() {
        String str = this.fRemoteConnection.getAttribute(IS_PASSWORD_ATTR);
        return !str.isEmpty() ? Boolean.parseBoolean(str) : false;
    }

    private void loadEnv(IProgressMonitor monitor) throws RemoteConnectionException {
        String[] vars;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        String env = this.executeCommand("printenv", (IProgressMonitor)subMon.newChild(10));
        String[] stringArray = vars = env.split("\n");
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            String[] kv = var.split("=");
            if (kv.length == 2) {
                this.fEnv.put(kv[0], kv[1]);
            }
            ++n2;
        }
    }

    private void loadProperties(IProgressMonitor monitor) throws RemoteConnectionException {
        String encoding;
        String osVersion;
        String osArch;
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.fProperties.put("file.separator", "/");
        this.fProperties.put("path.separator", ":");
        this.fProperties.put("line.separator", "\n");
        this.fProperties.put("user.home", this.getWorkingDirectory());
        String osName = this.executeCommand("uname", (IProgressMonitor)subMon.newChild(10));
        switch (osName.toLowerCase()) {
            case "linux": {
                osArch = this.executeCommand("uname -m", (IProgressMonitor)subMon.newChild(10));
                osVersion = this.executeCommand("uname -r", (IProgressMonitor)subMon.newChild(10));
                encoding = this.executeCommand("locale charmap", (IProgressMonitor)subMon.newChild(10));
                break;
            }
            case "darwin": {
                String opt;
                osName = this.executeCommand("sw_vers -productName", (IProgressMonitor)subMon.newChild(10));
                osVersion = this.executeCommand("sw_vers -productVersion", (IProgressMonitor)subMon.newChild(10));
                osArch = this.executeCommand("uname -m", (IProgressMonitor)subMon.newChild(10));
                if (osArch.equalsIgnoreCase("i386") && (opt = this.executeCommand("sysctl -n hw.optional.x86_64", (IProgressMonitor)subMon.newChild(10))).equals("1")) {
                    osArch = "x86_64";
                }
                encoding = this.executeCommand("locale charmap", (IProgressMonitor)subMon.newChild(10));
                break;
            }
            case "aix": {
                osArch = this.executeCommand("uname -p", (IProgressMonitor)subMon.newChild(10));
                osVersion = this.executeCommand("oslevel", (IProgressMonitor)subMon.newChild(10));
                if (osArch.equalsIgnoreCase("powerpc")) {
                    osArch = "ppc";
                    String opt = this.executeCommand("prtconf -k", (IProgressMonitor)subMon.newChild(10));
                    if (opt.indexOf("64-bit") > 0) {
                        osArch = String.valueOf(osArch) + "64";
                    }
                }
                encoding = this.executeCommand("locale charmap", (IProgressMonitor)subMon.newChild(10));
                break;
            }
            default: {
                osVersion = "unknown";
                osArch = "unknown";
                encoding = "unknown";
            }
        }
        this.fProperties.put("os.name", osName);
        this.fProperties.put("os.version", osVersion);
        this.fProperties.put("os.arch", osArch);
        this.fProperties.put("locale.charmap", encoding);
    }

    private Session newSession(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Session session = this.fJSchService.createSession(this.getHostname(), this.getPort(), this.getUsername());
            session.setUserInfo((UserInfo)new JSchUserInfo());
            if (this.isPasswordAuth()) {
                session.setConfig("PreferredAuthentications", "password,keyboard-interactive,gssapi-with-mic,publickey");
            } else {
                session.setConfig("PreferredAuthentications", "publickey,gssapi-with-mic,password,keyboard-interactive");
            }
            String password = this.getPassword();
            if (!password.isEmpty()) {
                session.setPassword(password);
            }
            if (this.getProxyCommand().isEmpty() && this.getProxyConnectionName().isEmpty()) {
                this.fJSchService.connect(session, this.getTimeout() * 1000, (IProgressMonitor)progress.newChild(10));
            } else if (this.getProxyCommand().isEmpty()) {
                session.setProxy(JSchConnectionProxyFactory.createForwardProxy(this.getProxyConnection(), (IProgressMonitor)progress.newChild(10)));
                this.fJSchService.connect(session, this.getTimeout() * 1000, (IProgressMonitor)progress.newChild(10));
            } else {
                session.setProxy(JSchConnectionProxyFactory.createCommandProxy(this.getProxyConnection(), this.getProxyCommand(), (IProgressMonitor)progress.newChild(10)));
                session.connect(this.getTimeout() * 1000);
            }
            if (!progress.isCanceled()) {
                this.fSessions.add(session);
                return session;
            }
            return null;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        this.open(monitor, true);
    }

    public void openMinimal(IProgressMonitor monitor) throws RemoteConnectionException {
        this.open(monitor, false);
    }

    private void open(IProgressMonitor monitor, boolean setupFully) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
        if (!this.hasOpenSession()) {
            this.checkIsConfigured();
            this.newSession((IProgressMonitor)subMon.newChild(10));
            if (subMon.isCanceled()) {
                throw new RemoteConnectionException(Messages.JSchConnection_Connection_was_cancelled);
            }
            this.isFullySetup = false;
        }
        if (setupFully && !this.isFullySetup) {
            this.isFullySetup = true;
            this.fWorkingDir = this.getCwd((IProgressMonitor)subMon.newChild(10));
            if (!this.checkConfiguration(this.fSessions.get(0), (IProgressMonitor)subMon.newChild(20))) {
                this.newSession((IProgressMonitor)subMon.newChild(10));
                this.loadEnv((IProgressMonitor)subMon.newChild(10));
            }
            this.loadProperties((IProgressMonitor)subMon.newChild(10));
            this.fRemoteConnection.fireConnectionChangeEvent(2);
        }
    }

    private ChannelSftp openSftpChannel(Session session) throws RemoteConnectionException {
        try {
            ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            return channel;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void removeLocalPortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).delPortForwardingL(port);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void removeRemotePortForwarding(int port) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnection_connectionNotOpen);
        }
        try {
            this.fSessions.get(0).delPortForwardingR(port);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public void setWorkingDirectory(String path) {
        if (RemoteServicesUtils.posixPath((String)path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public boolean useLoginShell() {
        String str = this.fRemoteConnection.getAttribute(USE_LOGIN_SHELL_ATTR);
        return !str.isEmpty() ? Boolean.parseBoolean(str) : true;
    }

    public void setHostname(String hostname) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(ADDRESS_ATTR, hostname);
        }
    }

    public void setPassphrase(String passphrase) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setSecureAttribute(PASSPHRASE_ATTR, passphrase);
        }
    }

    public void setPassword(String password) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setSecureAttribute(PASSWORD_ATTR, password);
        }
    }

    public void setPort(int port) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(PORT_ATTR, Integer.toString(port));
        }
    }

    public void setTimeout(int timeout) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(TIMEOUT_ATTR, Integer.toString(timeout));
        }
    }

    public void setUseLoginShell(boolean useLogingShell) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(USE_LOGIN_SHELL_ATTR, Boolean.toString(useLogingShell));
        }
    }

    public void setUsePassword(boolean usePassword) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(IS_PASSWORD_ATTR, Boolean.toString(usePassword));
        }
    }

    public void setUsername(String username) {
        if (this.fRemoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.fRemoteConnection;
            wc.setAttribute(USERNAME_ATTR, username);
        }
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection connection, Class<T> service) {
            if (JSchConnection.class.equals(service)) {
                Map map = connectionMap;
                synchronized (map) {
                    JSchConnection jschConnection = (JSchConnection)connectionMap.get(connection);
                    if (jschConnection == null) {
                        jschConnection = new JSchConnection(connection);
                        connectionMap.put(connection, jschConnection);
                    }
                    return (T)jschConnection;
                }
            }
            if (IRemoteConnectionControlService.class.equals(service) || IRemoteConnectionPropertyService.class.equals(service) || IRemotePortForwardingService.class.equals(service) || IRemoteProcessService.class.equals(service) || IRemoteConnectionHostService.class.equals(service)) {
                return (T)connection.getService(JSchConnection.class);
            }
            return null;
        }
    }

    private class JSchUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private boolean firstTryPassphrase = true;

        private JSchUserInfo() {
        }

        public String getPassphrase() {
            return JSchConnection.this.getPassphrase();
        }

        public String getPassword() {
            return JSchConnection.this.getPassword();
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            IUserAuthenticatorService authService = (IUserAuthenticatorService)JSchConnection.this.fRemoteConnection.getService(IUserAuthenticatorService.class);
            if (authService != null) {
                String[] result = authService.prompt(destination, name, instruction, prompt, echo);
                if (result != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    IRemoteConnectionWorkingCopy wc = JSchConnection.this.fRemoteConnection.getWorkingCopy();
                    wc.setSecureAttribute(JSchConnection.PASSWORD_ATTR, result[0]);
                    try {
                        wc.save();
                    }
                    catch (RemoteConnectionException e) {
                        Activator.log(e.getStatus());
                    }
                }
                return result;
            }
            return null;
        }

        public boolean promptPassphrase(String message) {
            if (this.firstTryPassphrase && !this.getPassphrase().equals(JSchConnection.EMPTY_STRING)) {
                this.firstTryPassphrase = false;
                return true;
            }
            IUserAuthenticatorService authService = (IUserAuthenticatorService)JSchConnection.this.fRemoteConnection.getService(IUserAuthenticatorService.class);
            if (authService != null) {
                PasswordAuthentication auth = authService.prompt(JSchConnection.this.getUsername(), message);
                if (auth == null) {
                    return false;
                }
                IRemoteConnectionWorkingCopy wc = JSchConnection.this.fRemoteConnection.getWorkingCopy();
                wc.setAttribute(JSchConnection.USERNAME_ATTR, auth.getUserName());
                wc.setSecureAttribute(JSchConnection.PASSPHRASE_ATTR, new String(auth.getPassword()));
                try {
                    wc.save();
                }
                catch (RemoteConnectionException e) {
                    Activator.log(e.getStatus());
                }
                return true;
            }
            return false;
        }

        public boolean promptPassword(String message) {
            IUserAuthenticatorService authService = (IUserAuthenticatorService)JSchConnection.this.fRemoteConnection.getService(IUserAuthenticatorService.class);
            if (authService != null) {
                PasswordAuthentication auth = authService.prompt(JSchConnection.this.getUsername(), message);
                if (auth == null) {
                    return false;
                }
                IRemoteConnectionWorkingCopy wc = JSchConnection.this.fRemoteConnection.getWorkingCopy();
                wc.setAttribute(JSchConnection.USERNAME_ATTR, auth.getUserName());
                wc.setSecureAttribute(JSchConnection.PASSWORD_ATTR, new String(auth.getPassword()));
                try {
                    wc.save();
                }
                catch (RemoteConnectionException e) {
                    Activator.log(e.getStatus());
                }
                return true;
            }
            return false;
        }

        public boolean promptYesNo(String message) {
            IUserAuthenticatorService authService = (IUserAuthenticatorService)JSchConnection.this.fRemoteConnection.getService(IUserAuthenticatorService.class);
            if (authService != null) {
                int prompt = authService.prompt(3, Messages.AuthInfo_Authentication_message, message, new int[]{2, 3}, 2);
                return prompt == 2;
            }
            return true;
        }

        public void showMessage(String message) {
            IUserAuthenticatorService authService = (IUserAuthenticatorService)JSchConnection.this.fRemoteConnection.getService(IUserAuthenticatorService.class);
            if (authService != null) {
                authService.prompt(2, Messages.AuthInfo_Authentication_message, message, new int[1], 0);
            }
        }
    }
}

