/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.preferences.formatter.CPreview;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.TextEdit;

public class SnippetPreview
extends CPreview {
    private ArrayList<PreviewSnippet> fSnippets = new ArrayList();

    public SnippetPreview(Map<String, String> workingValues, Composite parent) {
        super(workingValues, parent);
    }

    @Override
    protected void doFormatPreview() {
        if (this.fSnippets.isEmpty()) {
            this.fPreviewDocument.set("");
            return;
        }
        String delimiter = "\n";
        StringBuffer buffer = new StringBuffer();
        for (PreviewSnippet snippet : this.fSnippets) {
            String formattedSource;
            try {
                TextEdit edit = CodeFormatterUtil.format(snippet.kind, snippet.source, 0, "\n", this.fWorkingValues);
                if (edit == null) {
                    formattedSource = snippet.source;
                } else {
                    Document document = new Document(snippet.source);
                    edit.apply((IDocument)document, 0);
                    formattedSource = document.get();
                }
            }
            catch (Exception e) {
                Status status = new Status(4, CUIPlugin.getPluginId(), 10001, FormatterMessages.CPreview_formatter_exception, (Throwable)e);
                CUIPlugin.log((IStatus)status);
                continue;
            }
            buffer.append("\n");
            buffer.append(formattedSource);
            buffer.append("\n");
            buffer.append("\n");
        }
        this.fPreviewDocument.set(buffer.toString());
    }

    public void add(PreviewSnippet snippet) {
        this.fSnippets.add(snippet);
    }

    public void remove(PreviewSnippet snippet) {
        this.fSnippets.remove(snippet);
    }

    public void addAll(Collection<PreviewSnippet> snippets) {
        this.fSnippets.addAll(snippets);
    }

    public void clear() {
        this.fSnippets.clear();
    }

    public static final class PreviewSnippet {
        public String header;
        public final String source;
        public final int kind;

        public PreviewSnippet(int kind, String source) {
            this.kind = kind;
            this.source = source;
        }
    }
}

