/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.handlers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.IDEPreferenceInitializer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ShowInSystemExplorerHandler
extends AbstractHandler {
    public static final String ID = "org.eclipse.ui.showIn.systemExplorer";
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

    public Object execute(ExecutionEvent event) {
        IResource item = this.getResource(event);
        if (item == null) {
            return null;
        }
        StatusReporter statusReporter = (StatusReporter)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(StatusReporter.class);
        Job job = Job.create((String)IDEWorkbenchMessages.ShowInSystemExplorerHandler_jobTitle, monitor -> {
            String logMsgPrefix;
            try {
                logMsgPrefix = String.valueOf(event.getCommand().getName()) + ": ";
            }
            catch (NotDefinedException notDefinedException) {
                logMsgPrefix = String.valueOf(event.getCommand().getId()) + ": ";
            }
            try {
                File canonicalPath = this.getSystemExplorerPath(item);
                if (canonicalPath == null) {
                    return statusReporter.newStatus(4, String.valueOf(logMsgPrefix) + IDEWorkbenchMessages.ShowInSystemExplorerHandler_notDetermineLocation, null);
                }
                String launchCmd = this.formShowInSytemExplorerCommand(canonicalPath);
                if ("".equals(launchCmd)) {
                    return statusReporter.newStatus(4, String.valueOf(logMsgPrefix) + IDEWorkbenchMessages.ShowInSystemExplorerHandler_commandUnavailable, null);
                }
                File dir = item.getWorkspace().getRoot().getLocation().toFile();
                Process p = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, dir) : Runtime.getRuntime().exec(launchCmd, null, dir);
                int retCode = p.waitFor();
                if (retCode != 0 && !Util.isWindows()) {
                    return statusReporter.newStatus(4, "Execution of '" + launchCmd + "' failed with return code: " + retCode, null);
                }
            }
            catch (IOException | InterruptedException e2) {
                return statusReporter.newStatus(4, String.valueOf(logMsgPrefix) + "Unhandled failure.", (Throwable)e2);
            }
            return Status.OK_STATUS;
        });
        job.schedule();
        return null;
    }

    private IResource getResource(ExecutionEvent event) {
        IResource resource = this.getSelectionResource(event);
        if (resource == null) {
            resource = this.getEditorInputResource(event);
        }
        return resource;
    }

    private IResource getSelectionResource(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        IResource item = (IResource)Adapters.adapt((Object)selectedObject, IResource.class);
        return item;
    }

    private IResource getEditorInputResource(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof IEditorPart)) {
            return null;
        }
        IEditorInput input = ((IEditorPart)activePart).getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return (IResource)Adapters.adapt((Object)input, IResource.class);
    }

    private String formShowInSytemExplorerCommand(File path) throws IOException {
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
        File parent = path.getParentFile();
        if (parent != null) {
            command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
        }
        return command;
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }

    private File getSystemExplorerPath(IResource resource) throws IOException {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return location.toFile();
    }

    public static String getDefaultCommand() {
        return IDEPreferenceInitializer.getShowInSystemExplorerCommand();
    }
}

