/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.internal.workbench.swt.E4Testable;
import org.eclipse.e4.ui.internal.workbench.swt.IEventLoopAdvisor;
import org.eclipse.e4.ui.internal.workbench.swt.ResourceUtility;
import org.eclipse.e4.ui.internal.workbench.swt.ShellActivationListener;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class PartRenderingEngine
implements IPresentationEngine {
    public static final String EARLY_STARTUP_HOOK = "runEarlyStartup";
    public static final String engineURI = "bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
    private static final String defaultFactoryUrl = "bundleclass://org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.WorkbenchRendererFactory";
    public static final String ENABLED_THEME_KEY = "themeEnabled";
    private static boolean enableThemePreference;
    private String factoryUrl;
    IRendererFactory curFactory = null;
    private Map<String, AbstractPartRenderer> customRendererMap = new HashMap<String, AbstractPartRenderer>();
    Listener keyListener;
    private IEclipseContext appContext;
    protected Shell testShell;
    protected MApplication theApp;
    @Inject
    EModelService modelService;
    @Inject
    protected Logger logger;
    private Shell limbo;
    private MUIElement removeRoot = null;
    @Inject
    @Optional
    IEventBroker eventBroker;
    private StylingPreferencesHandler cssThemeChangedHandler;

    @Inject
    @Optional
    private void subscribeTopicToBeRendered(@EventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") Event event) {
        boolean okToRender;
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MElementContainer parent = changedElement.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)changedElement).eContainer();
        }
        if (parent instanceof MMenu) {
            return;
        }
        boolean bl = okToRender = parent instanceof MApplication || parent.getWidget() != null;
        if (changedElement.isToBeRendered() && okToRender) {
            Activator.trace((String)"/trace/renderer", (String)"visible -> true", null);
            Object w = this.createGui(changedElement);
            if (w instanceof Control && !(w instanceof Shell)) {
                this.fixZOrder(changedElement);
            }
        } else {
            MElementContainer container;
            Activator.trace((String)"/trace/renderer", (String)"visible -> false", null);
            if (parent instanceof MElementContainer && (container = parent).getSelectedElement() == changedElement) {
                container.setSelectedElement(null);
            }
            if (okToRender) {
                if (changedElement.getTags().contains("Maximized")) {
                    changedElement.getTags().remove("Maximized");
                }
                this.removeGui(changedElement);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeVisibilityHandler(@EventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/visible/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MElementContainer parent = changedElement.getParent();
        if (parent == null && (parent = (MUIElement)((EObject)changedElement).eContainer()) == null) {
            return;
        }
        AbstractPartRenderer renderer = (AbstractPartRenderer)parent.getRenderer();
        if (renderer == null || parent instanceof MToolBar) {
            return;
        }
        if (changedElement.isVisible()) {
            if (changedElement.isToBeRendered()) {
                if (changedElement.getWidget() instanceof Control) {
                    Composite realComp = (Composite)renderer.getUIContainer(changedElement);
                    Control ctrl = (Control)changedElement.getWidget();
                    ctrl.setParent(realComp);
                    this.fixZOrder(changedElement);
                }
                if (parent instanceof MElementContainer) {
                    MElementContainer container = parent;
                    renderer.childRendered((MElementContainer<MUIElement>)container, changedElement);
                }
            }
        } else {
            if (changedElement.getWidget() instanceof Control) {
                Control ctrl = (Control)changedElement.getWidget();
                if (!(ctrl instanceof Shell)) {
                    ctrl.getShell().layout(new Control[]{ctrl}, 4);
                }
                ctrl.setParent((Composite)this.getLimboShell());
            }
            if (parent instanceof MElementContainer) {
                MElementContainer container = parent;
                renderer.hideChild((MElementContainer<MUIElement>)container, changedElement);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTrimHandler(@EventTopic(value="org/eclipse/e4/ui/model/basic/TrimmedWindow/trimBars/*") Event event) {
        block5: {
            block4: {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MTrimmedWindow)) {
                    return;
                }
                MTrimmedWindow window = (MTrimmedWindow)changedObj;
                if (window.getWidget() == null) {
                    return;
                }
                if (!UIEvents.isADD((Event)event)) break block4;
                for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    MUIElement added = (MUIElement)o;
                    if (!added.isToBeRendered()) continue;
                    this.createGui(added, window.getWidget(), window.getContext());
                }
                break block5;
            }
            if (!UIEvents.isREMOVE((Event)event)) break block5;
            for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                MUIElement removed = (MUIElement)o;
                if (removed.getRenderer() == null) continue;
                this.removeGui(removed);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeChildrenHandler(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        block12: {
            AbstractPartRenderer renderer;
            MElementContainer changedElement;
            block11: {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MElementContainer)) {
                    return;
                }
                changedElement = (MElementContainer)changedObj;
                boolean isApplication = changedObj instanceof MApplication;
                boolean menuChild = changedObj instanceof MMenu;
                renderer = this.getRendererFor((MUIElement)changedElement);
                if (!isApplication && renderer == null || menuChild) {
                    return;
                }
                if (!UIEvents.isADD((Event)event)) break block11;
                Activator.trace((String)"/trace/renderer", (String)"Child Added", null);
                for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    int newLocation;
                    boolean renderIt;
                    MUIElement added = (MUIElement)o;
                    boolean isStack = changedObj instanceof MGenericStack;
                    boolean hasWidget = added.getWidget() != null;
                    boolean isSelected = added == changedElement.getSelectedElement();
                    boolean bl = renderIt = !isStack || hasWidget || isSelected;
                    if (renderIt) {
                        Object w = this.createGui(added);
                        if (w instanceof Control && !(w instanceof Shell)) {
                            Control ctrl = (Control)w;
                            this.fixZOrder(added);
                            if (!ctrl.isDisposed()) {
                                ctrl.getShell().layout(new Control[]{ctrl}, 4);
                            }
                        }
                    } else if (renderer != null && added.isToBeRendered()) {
                        renderer.childRendered((MElementContainer<MUIElement>)changedElement, added);
                    }
                    if ((newLocation = this.modelService.getElementLocation(added)) != 8 && newLocation != 1) continue;
                    MWindow topWin = this.modelService.getTopLevelWindowFor(added);
                    this.modelService.hideLocalPlaceholders(topWin, null);
                }
                break block12;
            }
            if (!UIEvents.isREMOVE((Event)event)) break block12;
            Activator.trace((String)"/trace/renderer", (String)"Child Removed", null);
            for (Object o : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MUIElement removed = (MUIElement)o;
                if (!removed.isToBeRendered()) continue;
                if (removed.getWidget() instanceof Control) {
                    Control ctrl = (Control)removed.getWidget();
                    ctrl.setLayoutData(null);
                    ctrl.getParent().layout(new Control[]{ctrl}, 6);
                }
                if (changedElement.getSelectedElement() == removed) {
                    changedElement.setSelectedElement(null);
                }
                if (renderer == null) continue;
                renderer.hideChild((MElementContainer<MUIElement>)changedElement, removed);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeWindowsHandler(@EventTopic(value="org/eclipse/e4/ui/model/basic/Window/windows/*") Event event) {
        this.subscribeChildrenHandler(event);
    }

    @Inject
    @Optional
    private void subscribePerspectiveWindowsHandler(@EventTopic(value="org/eclipse/e4/ui/model/advanced/Perspective/windows/*") Event event) {
        this.subscribeChildrenHandler(event);
    }

    @Inject
    @Optional
    private void subscribeCssThemeChanged(@EventTopic(value="org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged") Event event) {
        this.cssThemeChangedHandler.handleEvent(event);
    }

    @Inject
    public PartRenderingEngine(@Named(value="rendererFactoryUri") @Optional String factoryUrl) {
        if (factoryUrl == null) {
            factoryUrl = defaultFactoryUrl;
        }
        this.factoryUrl = factoryUrl;
    }

    protected void fixZOrder(MUIElement element) {
        Composite composite;
        EObject econtainer;
        MElementContainer parent = element.getParent();
        if (parent == null && (econtainer = ((EObject)element).eContainer()) instanceof MElementContainer) {
            MElementContainer container;
            parent = container = (MElementContainer)econtainer;
        }
        if (parent == null || !(element.getWidget() instanceof Control)) {
            return;
        }
        Control elementCtrl = (Control)element.getWidget();
        Control prevCtrl = null;
        for (MUIElement kid : parent.getChildren()) {
            if (kid == element) {
                if (prevCtrl != null) {
                    elementCtrl.moveBelow(prevCtrl);
                    break;
                }
                elementCtrl.moveAbove(null);
                break;
            }
            if (!(kid.getWidget() instanceof Control) || !kid.isVisible()) continue;
            prevCtrl = (Control)kid.getWidget();
        }
        Object widget = parent.getWidget();
        if (widget instanceof Composite && (composite = (Composite)widget).getShell() == elementCtrl.getShell()) {
            Composite temp = elementCtrl.getParent();
            while (temp != composite) {
                if (temp == null) {
                    return;
                }
                temp = temp.getParent();
            }
            composite.layout(true, true);
        }
    }

    @PostConstruct
    void initialize(IEclipseContext context) {
        this.appContext = context;
        KeyFormatterFactory.setDefault((IKeyFormatter)SWTKeySupport.getKeyFormatterForPlatform());
        context.set(IPresentationEngine.class, (Object)this);
        IRendererFactory factory = null;
        IContributionFactory contribFactory = (IContributionFactory)context.get(IContributionFactory.class);
        try {
            factory = (IRendererFactory)contribFactory.create(this.factoryUrl, context);
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Could not create rendering factory");
        }
        if (factory == null) {
            try {
                factory = (IRendererFactory)contribFactory.create(defaultFactoryUrl, context);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Could not create default rendering factory");
            }
        }
        if (factory == null) {
            throw new IllegalStateException("Could not create any rendering factory. Aborting ...");
        }
        this.curFactory = factory;
        context.set(IRendererFactory.class, (Object)this.curFactory);
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.workbench.renderers.swt");
        enableThemePreference = node.getBoolean(ENABLED_THEME_KEY, true);
        this.cssThemeChangedHandler = new StylingPreferencesHandler((Display)context.get(Display.class));
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            PartRenderingEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    private String getContextName(MUIElement element) {
        StringBuilder builder = new StringBuilder(element.getClass().getSimpleName());
        String elementId = element.getElementId();
        if (elementId != null && elementId.length() != 0) {
            builder.append(" (").append(elementId).append(") ");
        }
        builder.append("Context");
        return builder.toString();
    }

    public Object createGui(final MUIElement element, final Object parentWidget, final IEclipseContext parentContext) {
        final Object[] gui = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while rendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                gui[0] = PartRenderingEngine.this.safeCreateGui(element, parentWidget, parentContext);
            }
        });
        return gui[0];
    }

    public Object safeCreateGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MContext ctxt;
        IEclipseContext lclContext;
        MContext ctxt2;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (this.removeRoot != null) {
            return null;
        }
        Object currentWidget = element.getWidget();
        if (currentWidget != null) {
            AbstractPartRenderer parentRenderer;
            MElementContainer parentElement;
            if (currentWidget instanceof Control) {
                Composite currentParent;
                Control control = (Control)currentWidget;
                MElementContainer elementParent = element.getParent();
                if (!(element instanceof MPlaceholder) || !(elementParent instanceof MPartStack)) {
                    control.setVisible(true);
                }
                if (parentWidget instanceof Composite && (currentParent = control.getParent()) != parentWidget) {
                    CTabFolder folder;
                    if (currentParent instanceof CTabFolder && (folder = (CTabFolder)currentParent).getTopRight() == control) {
                        folder.setTopRight(null);
                    }
                    control.setParent((Composite)parentWidget);
                }
            }
            if (element instanceof MContext) {
                IEclipseContext ctxt3 = ((MContext)element).getContext();
                if (ctxt3 != null) {
                    ctxt3.setParent(parentContext);
                }
            } else {
                List childContexts = this.modelService.findElements(element, null, MContext.class, null);
                for (MContext c : childContexts) {
                    MUIElement kid = (MUIElement)c;
                    MElementContainer parent = kid.getParent();
                    if (parent == null && kid.getCurSharedRef() != null) {
                        parent = kid.getCurSharedRef().getParent();
                    }
                    if (!(element instanceof MPlaceholder) && parent != element || c.getContext() == null || c.getContext().getParent() == parentContext) continue;
                    c.getContext().setParent(parentContext);
                }
            }
            if ((parentElement = element.getParent()) != null && (parentRenderer = this.getRendererFor((MUIElement)parentElement)) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
            return element.getWidget();
        }
        if (element instanceof MContext && (ctxt2 = (MContext)element).getContext() == null) {
            IEclipseContext lclContext2 = parentContext.createChild(this.getContextName(element));
            PartRenderingEngine.populateModelInterfaces(ctxt2, lclContext2, element.getClass().getInterfaces());
            ctxt2.setContext(lclContext2);
            for (String variable : ctxt2.getVariables()) {
                lclContext2.declareModifiable(variable);
            }
            Map props = ctxt2.getProperties();
            for (String key : props.keySet()) {
                lclContext2.set(key, props.get(key));
            }
        }
        if (element.getWidget() != null) {
            return this.safeCreateGui(element, parentWidget, parentContext);
        }
        Object newWidget = this.createWidget(element, parentWidget);
        if (newWidget != null) {
            AbstractPartRenderer parentRenderer;
            AbstractPartRenderer renderer = this.getRendererFor(element);
            renderer.hookControllerLogic(element);
            if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                renderer.processContents((MElementContainer<MUIElement>)container);
            }
            renderer.postProcess(element);
            MElementContainer parentElement = element.getParent();
            if (parentElement != null && (parentRenderer = this.getRendererFor((MUIElement)parentElement)) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
        } else if (element instanceof MContext && (lclContext = (ctxt = (MContext)element).getContext()) != null) {
            lclContext.dispose();
            ctxt.setContext(null);
        }
        return newWidget;
    }

    private IEclipseContext getContext(MUIElement parent) {
        if (parent instanceof MContext) {
            return ((MContext)parent).getContext();
        }
        return this.modelService.getContainingContext(parent);
    }

    public Object createGui(final MUIElement element) {
        final Object[] gui = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while rendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                gui[0] = PartRenderingEngine.this.safeCreateGui(element);
            }
        });
        return gui[0];
    }

    private Object safeCreateGui(MUIElement element) {
        AbstractPartRenderer renderer;
        Object parent = null;
        MElementContainer parentME = element.getParent();
        if (parentME == null) {
            parentME = (MUIElement)((EObject)element).eContainer();
        }
        if (parentME != null && (renderer = this.getRendererFor((MUIElement)parentME)) != null) {
            parent = !element.isVisible() ? this.getLimboShell() : renderer.getUIContainer(element);
        }
        IEclipseContext parentContext = null;
        if (element.getCurSharedRef() != null) {
            MPlaceholder ph = element.getCurSharedRef();
            parentContext = this.getContext((MUIElement)ph.getParent());
        } else if (parentContext == null && element.getParent() != null) {
            parentContext = this.getContext((MUIElement)element.getParent());
        } else if (parentContext == null && element.getParent() == null) {
            parentContext = this.getContext((MUIElement)((EObject)element).eContainer());
        }
        return this.safeCreateGui(element, parent, parentContext);
    }

    public void focusGui(MUIElement element) {
        Object implementation;
        AbstractPartRenderer renderer = (AbstractPartRenderer)element.getRenderer();
        if (renderer == null || element.getWidget() == null) {
            return;
        }
        Object object = implementation = element instanceof MContribution ? ((MContribution)element).getObject() : null;
        if (implementation == null) {
            renderer.forceFocus(element);
            return;
        }
        try {
            IEclipseContext context = this.getContext(element);
            Object defaultValue = new Object();
            Object returnValue = ContextInjectionFactory.invoke((Object)implementation, Focus.class, (IEclipseContext)context, (Object)defaultValue);
            if (returnValue == defaultValue) {
                renderer.forceFocus(element);
            }
        }
        catch (InjectionException e) {
            this.log("Failed to grant focus to element", "Failed to grant focus to element ({0})", element.getElementId(), (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.log("Failed to grant focus to element via DI", "Failed to grant focus via DI to element ({0})", element.getElementId(), e);
        }
    }

    private void log(String unidentifiedMessage, String identifiedMessage, String id, Exception e) {
        if (id == null || id.length() == 0) {
            this.logger.error((Throwable)e, unidentifiedMessage);
        } else {
            this.logger.error((Throwable)e, NLS.bind((String)identifiedMessage, (Object)id));
        }
    }

    private Shell getLimboShell() {
        if (this.limbo == null) {
            this.limbo = new Shell(Display.getCurrent(), 0);
            this.limbo.setText("PartRenderingEngine's limbo");
            this.limbo.setLocation(0, 10000);
            this.limbo.setBackgroundMode(1);
            this.limbo.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        }
        return this.limbo;
    }

    public void removeGui(final MUIElement element) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while unrendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                PartRenderingEngine.this.safeRemoveGui(element);
            }
        });
    }

    private void safeRemoveGui(MUIElement element) {
        MPlaceholder ph;
        AbstractPartRenderer renderer;
        MElementContainer parent;
        AbstractPartRenderer parentRenderer;
        if (this.removeRoot == null) {
            this.removeRoot = element;
        }
        AbstractPartRenderer abstractPartRenderer = parentRenderer = (parent = element.getParent()) != null ? this.getRendererFor((MUIElement)parent) : null;
        if (parentRenderer != null) {
            parentRenderer.hideChild((MElementContainer<MUIElement>)element.getParent(), element);
        }
        if ((renderer = this.getRendererFor(element)) != null) {
            IEclipseContext parentContext;
            Object client;
            MContribution contribution;
            block24: {
                if (element instanceof MElementContainer) {
                    MElementContainer container = (MElementContainer)element;
                    MUIElement selectedElement = container.getSelectedElement();
                    Iterator children = container.getChildren();
                    for (Object child : new ArrayList(children)) {
                        if (child == selectedElement) continue;
                        this.removeGui((MUIElement)child);
                    }
                    if (selectedElement != null && children.contains(selectedElement)) {
                        this.removeGui(selectedElement);
                    }
                }
                if (element instanceof MPerspective) {
                    MPerspective perspective = (MPerspective)element;
                    for (MWindow subWindow : perspective.getWindows()) {
                        this.removeGui((MUIElement)subWindow);
                    }
                } else if (element instanceof MWindow) {
                    MWindow window = (MWindow)element;
                    for (MWindow subWindow : window.getWindows()) {
                        this.removeGui((MUIElement)subWindow);
                    }
                    if (window instanceof MTrimmedWindow) {
                        MTrimmedWindow trimmedWindow = (MTrimmedWindow)window;
                        for (MUIElement trimBar : trimmedWindow.getTrimBars()) {
                            this.removeGui(trimBar);
                        }
                    }
                }
                if (element instanceof MContribution) {
                    contribution = (MContribution)element;
                    client = contribution.getObject();
                    parentContext = renderer.getContext(element);
                    if (parentContext != null && client != null) {
                        try {
                            ContextInjectionFactory.invoke((Object)client, PersistState.class, (IEclipseContext)parentContext, null);
                        }
                        catch (Exception e) {
                            if (this.logger == null) break block24;
                            this.logger.error((Throwable)e);
                        }
                    }
                }
            }
            renderer.disposeWidget(element);
            if (element instanceof MContribution) {
                block25: {
                    contribution = (MContribution)element;
                    client = contribution.getObject();
                    parentContext = renderer.getContext(element);
                    if (parentContext != null && client != null) {
                        try {
                            ContextInjectionFactory.uninject((Object)client, (IEclipseContext)parentContext);
                        }
                        catch (Exception e) {
                            if (this.logger == null) break block25;
                            this.logger.error((Throwable)e);
                        }
                    }
                }
                contribution.setObject(null);
            }
            if (element instanceof MContext) {
                this.clearContext((MContext)element);
            }
        }
        if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() != null && ph.getRef().getCurSharedRef() == ph) {
            ph.getRef().setCurSharedRef(null);
        }
        if (this.removeRoot == element) {
            this.removeRoot = null;
        }
    }

    private void clearContext(MContext contextME) {
        MContext ctxt = contextME;
        IEclipseContext lclContext = ctxt.getContext();
        if (lclContext != null) {
            IEclipseContext child;
            IEclipseContext parentContext = lclContext.getParent();
            IEclipseContext iEclipseContext = child = parentContext != null ? parentContext.getActiveChild() : null;
            if (child == lclContext) {
                child.deactivate();
            }
            ctxt.setContext(null);
            lclContext.dispose();
        }
    }

    protected Object createWidget(MUIElement element, Object parent) {
        AbstractPartRenderer renderer = this.getRenderer(element, parent);
        if (renderer != null) {
            element.setRenderer((Object)renderer);
            Object newWidget = renderer.createWidget(element, parent);
            if (newWidget != null) {
                renderer.bindWidget(element, newWidget);
                return newWidget;
            }
        }
        return null;
    }

    private AbstractPartRenderer getRenderer(MUIElement uiElement, Object parent) {
        String customURI = (String)uiElement.getPersistedState().get("Custom Renderer");
        if (customURI != null) {
            AbstractPartRenderer abstractPartRenderer = this.customRendererMap.get(customURI);
            if (abstractPartRenderer != null) {
                return abstractPartRenderer;
            }
            IEclipseContext owningContext = this.modelService.getContainingContext(uiElement);
            IContributionFactory contributionFactory = (IContributionFactory)owningContext.get(IContributionFactory.class);
            Object customRenderer = contributionFactory.create(customURI, owningContext);
            if (customRenderer instanceof AbstractPartRenderer) {
                this.customRendererMap.put(customURI, (AbstractPartRenderer)customRenderer);
                return (AbstractPartRenderer)customRenderer;
            }
        }
        return this.curFactory.getRenderer(uiElement, parent);
    }

    protected AbstractPartRenderer getRendererFor(MUIElement element) {
        return (AbstractPartRenderer)element.getRenderer();
    }

    @Inject
    @Optional
    public Object run(final MApplicationElement uiRoot, final IEclipseContext runContext) {
        Display display;
        if (runContext.get(Display.class) != null) {
            display = (Display)runContext.get(Display.class);
        } else {
            display = Display.getDefault();
            runContext.set(Display.class, (Object)display);
        }
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                IEventLoopAdvisor advisor;
                TestableObject testableObject;
                Runnable earlyStartup;
                PartRenderingEngine.initializeStyling(display, runContext);
                runContext.set(IResourceUtilities.class, (Object)new ResourceUtility());
                KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)runContext);
                runContext.set(KeyBindingDispatcher.class, (Object)dispatcher);
                PartRenderingEngine.this.keyListener = dispatcher.getKeyDownFilter();
                display.addFilter(1, PartRenderingEngine.this.keyListener);
                display.addFilter(31, PartRenderingEngine.this.keyListener);
                Shell limbo = PartRenderingEngine.this.getLimboShell();
                runContext.set("limbo", (Object)limbo);
                PartRenderingEngine.this.testShell = null;
                PartRenderingEngine.this.theApp = null;
                boolean spinOnce = true;
                if (uiRoot instanceof MApplication) {
                    ShellActivationListener shellDialogListener = new ShellActivationListener((MApplication)uiRoot);
                    display.addFilter(26, (Listener)shellDialogListener);
                    display.addFilter(27, (Listener)shellDialogListener);
                    spinOnce = false;
                    PartRenderingEngine.this.theApp = (MApplication)uiRoot;
                    MWindow selected = (MWindow)PartRenderingEngine.this.theApp.getSelectedElement();
                    if (selected == null) {
                        for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                            PartRenderingEngine.this.createGui((MUIElement)window);
                        }
                    } else {
                        PartRenderingEngine.this.createGui((MUIElement)selected);
                        for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                            if (selected == window) continue;
                            PartRenderingEngine.this.createGui((MUIElement)window);
                        }
                    }
                    IApplicationContext ac = (IApplicationContext)PartRenderingEngine.this.appContext.get(IApplicationContext.class);
                    if (ac != null) {
                        ac.applicationRunning();
                        if (PartRenderingEngine.this.eventBroker != null) {
                            PartRenderingEngine.this.eventBroker.post("org/eclipse/e4/ui/LifeCycle/appStartupComplete", (Object)PartRenderingEngine.this.theApp);
                        }
                    }
                } else if (uiRoot instanceof MUIElement) {
                    if (uiRoot instanceof MWindow) {
                        PartRenderingEngine.this.testShell = (Shell)PartRenderingEngine.this.createGui((MUIElement)uiRoot);
                    } else {
                        PartRenderingEngine.this.testShell = new Shell(display, 1264);
                        PartRenderingEngine.this.createGui((MUIElement)uiRoot, PartRenderingEngine.this.testShell, null);
                    }
                }
                if ((earlyStartup = (Runnable)runContext.get(PartRenderingEngine.EARLY_STARTUP_HOOK)) != null) {
                    earlyStartup.run();
                }
                if ((testableObject = (TestableObject)runContext.get(TestableObject.class)) instanceof E4Testable) {
                    ((E4Testable)testableObject).init(display, (IWorkbench)runContext.get(IWorkbench.class));
                }
                if ((advisor = (IEventLoopAdvisor)runContext.getActiveLeaf().get(IEventLoopAdvisor.class)) == null) {
                    advisor = new IEventLoopAdvisor(){

                        @Override
                        public void eventLoopIdle(Display display) {
                            display.sleep();
                        }

                        @Override
                        public void eventLoopException(Throwable exception) {
                            StatusReporter statusReporter = (StatusReporter)PartRenderingEngine.this.appContext.get(StatusReporter.class);
                            if (statusReporter != null) {
                                statusReporter.show(4, "Internal Error", exception, new Object[0]);
                            } else if ((this).PartRenderingEngine.this.logger != null) {
                                (this).PartRenderingEngine.this.logger.error(exception);
                            }
                        }
                    };
                }
                while ((PartRenderingEngine.this.testShell != null && !PartRenderingEngine.this.testShell.isDisposed() || PartRenderingEngine.this.theApp != null && PartRenderingEngine.this.someAreVisible(PartRenderingEngine.this.theApp.getChildren())) && !display.isDisposed()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        runContext.processWaiting();
                        if (spinOnce) {
                            return;
                        }
                        advisor.eventLoopIdle(display);
                    }
                    catch (ThreadDeath th) {
                        throw th;
                    }
                    catch (Exception ex) {
                        this.handle(ex, advisor);
                    }
                    catch (Error err) {
                        this.handle(err, advisor);
                    }
                }
                if (!spinOnce) {
                    PartRenderingEngine.this.cleanUp();
                }
            }

            private void handle(Throwable ex, IEventLoopAdvisor advisor) {
                try {
                    advisor.eventLoopException(ex);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    t.printStackTrace();
                }
            }
        });
        return IApplication.EXIT_OK;
    }

    protected boolean someAreVisible(List<MWindow> windows) {
        int limit = windows.size();
        int i = 0;
        while (i < limit) {
            MWindow win = windows.get(i);
            if (win.isToBeRendered() && win.getWidget() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void stop() {
        this.cleanUp();
        if (this.theApp != null) {
            for (MWindow window : this.theApp.getChildren()) {
                if (window.getWidget() == null) continue;
                this.removeGui((MUIElement)window);
            }
        } else if (this.testShell != null && !this.testShell.isDisposed()) {
            Object model = this.testShell.getData("modelElement");
            if (model instanceof MUIElement) {
                this.removeGui((MUIElement)model);
            } else {
                this.testShell.close();
            }
        }
    }

    private void cleanUp() {
        Display display;
        if (this.keyListener != null && !(display = Display.getDefault()).isDisposed()) {
            display.removeFilter(1, this.keyListener);
            display.removeFilter(31, this.keyListener);
            this.keyListener = null;
        }
    }

    public static void initializeStyling(Display display, IEclipseContext appContext) {
        String cssTheme = (String)appContext.get("cssTheme");
        String cssURI = (String)appContext.get("applicationCSS");
        if ("none".equals(cssTheme) || !enableThemePreference) {
            appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                public void setClassname(Object widget, String classname) {
                    WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                }

                public void setId(Object widget, String id) {
                    WidgetElement.setID((Widget)((Widget)widget), (String)id);
                }

                public void style(Object widget) {
                }

                public CSSStyleDeclaration getStyle(Object widget) {
                    return null;
                }

                public void setClassnameAndId(Object widget, String classname, String id) {
                    WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                    WidgetElement.setID((Widget)((Widget)widget), (String)id);
                }
            });
        } else if (cssTheme != null) {
            final IThemeEngine themeEngine = PartRenderingEngine.createThemeEngine(display, appContext);
            String cssResourcesURI = (String)appContext.get("applicationCSSResources");
            if (cssResourcesURI != null) {
                themeEngine.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI), new String[0]);
            }
            appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                public void setClassname(Object widget, String classname) {
                    WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                    themeEngine.applyStyles(widget, true);
                }

                public void setId(Object widget, String id) {
                    WidgetElement.setID((Widget)((Widget)widget), (String)id);
                    themeEngine.applyStyles(widget, true);
                }

                public void style(Object widget) {
                    themeEngine.applyStyles(widget, true);
                }

                public CSSStyleDeclaration getStyle(Object widget) {
                    return themeEngine.getStyle(widget);
                }

                public void setClassnameAndId(Object widget, String classname, String id) {
                    WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                    WidgetElement.setID((Widget)((Widget)widget), (String)id);
                    themeEngine.applyStyles(widget, true);
                }
            });
            PartRenderingEngine.setCSSTheme(display, themeEngine, cssTheme);
        } else if (cssURI != null) {
            Shell[] shells;
            CSSSWTEngineImpl cssEngine;
            block29: {
                String cssResourcesURI = (String)appContext.get("applicationCSSResources");
                cssEngine = new CSSSWTEngineImpl(display, true);
                WidgetElement.setEngine((Display)display, (CSSEngine)cssEngine);
                if (cssResourcesURI != null) {
                    cssEngine.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI.toString()));
                }
                display.setData("org.eclipse.e4.ui.css.context", (Object)appContext);
                appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                    public void setClassname(Object widget, String classname) {
                        WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                        cssEngine.applyStyles(widget, true);
                    }

                    public void setId(Object widget, String id) {
                        WidgetElement.setID((Widget)((Widget)widget), (String)id);
                        cssEngine.applyStyles(widget, true);
                    }

                    public void style(Object widget) {
                        cssEngine.applyStyles(widget, true);
                    }

                    public CSSStyleDeclaration getStyle(Object widget) {
                        Element e = cssEngine.getCSSElementContext(widget).getElement();
                        if (e == null) {
                            return null;
                        }
                        return cssEngine.getViewCSS().getComputedStyle(e, null);
                    }

                    public void setClassnameAndId(Object widget, String classname, String id) {
                        WidgetElement.setCSSClass((Widget)((Widget)widget), (String)classname);
                        WidgetElement.setID((Widget)((Widget)widget), (String)id);
                        cssEngine.applyStyles(widget, true);
                    }
                });
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(cssURI));
                    stream = url.openStream();
                    cssEngine.parseStyleSheet(stream);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block29;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block29;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                if (stream == null) break block29;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                block31: {
                    Shell s = shellArray[n2];
                    try {
                        try {
                            s.setRedraw(false);
                            s.reskin(1);
                            cssEngine.applyStyles((Object)s, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            s.setRedraw(true);
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        s.setRedraw(true);
                        throw throwable;
                    }
                    s.setRedraw(true);
                }
                ++n2;
            }
        }
        CSSRenderingUtils cssUtils = (CSSRenderingUtils)ContextInjectionFactory.make(CSSRenderingUtils.class, (IEclipseContext)appContext);
        appContext.set(CSSRenderingUtils.class, (Object)cssUtils);
    }

    private static IThemeEngine createThemeEngine(Display display, IEclipseContext appContext) {
        IContributionFactory contribution = (IContributionFactory)appContext.get(IContributionFactory.class);
        IEclipseContext cssContext = EclipseContextFactory.create();
        cssContext.set(IContributionFactory.class, (Object)contribution);
        display.setData("org.eclipse.e4.ui.css.context", (Object)cssContext);
        IThemeManager mgr = (IThemeManager)appContext.get(IThemeManager.class);
        IThemeEngine themeEngine = mgr.getEngineForDisplay(display);
        appContext.set(IThemeEngine.class, (Object)themeEngine);
        return themeEngine;
    }

    private static void setCSSTheme(Display display, IThemeEngine themeEngine, String cssTheme) {
        if (display.getHighContrast()) {
            themeEngine.setTheme(cssTheme, false);
        } else {
            themeEngine.restore(cssTheme);
        }
    }

    public static class StylingPreferencesHandler
    implements EventHandler {
        private HashSet<IEclipsePreferences> prefs = null;

        public StylingPreferencesHandler(Display display) {
            if (display != null) {
                display.addListener(12, this.createOnDisplayDisposedListener());
            }
        }

        protected Listener createOnDisplayDisposedListener() {
            return new Listener(){

                public void handleEvent(org.eclipse.swt.widgets.Event event) {
                    this.resetOverriddenPreferences();
                }
            };
        }

        public void handleEvent(Event event) {
            this.resetOverriddenPreferences();
            this.overridePreferences(this.getThemeEngine(event));
        }

        protected void resetOverriddenPreferences() {
            for (IEclipsePreferences preferences : this.getPreferences()) {
                this.resetOverriddenPreferences(preferences);
            }
        }

        protected void resetOverriddenPreferences(IEclipsePreferences preferences) {
            for (String name : this.getOverriddenPropertyNames(preferences)) {
                preferences.remove(name);
            }
            this.removeOverriddenPropertyNames(preferences);
        }

        protected void removeOverriddenPropertyNames(IEclipsePreferences preferences) {
            EclipsePreferencesHelper.removeOverriddenPropertyNames((IEclipsePreferences)preferences);
        }

        protected List<String> getOverriddenPropertyNames(IEclipsePreferences preferences) {
            return EclipsePreferencesHelper.getOverriddenPropertyNames((IEclipsePreferences)preferences);
        }

        protected Set<IEclipsePreferences> getPreferences() {
            if (this.prefs == null) {
                this.prefs = new HashSet();
                BundleContext context = WorkbenchSWTActivator.getDefault().getContext();
                Bundle[] bundleArray = context.getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    if (bundle.getSymbolicName() != null) {
                        this.prefs.add(InstanceScope.INSTANCE.getNode(bundle.getSymbolicName()));
                    }
                    ++n2;
                }
            }
            return this.prefs;
        }

        private void overridePreferences(IThemeEngine themeEngine) {
            if (themeEngine != null) {
                for (IEclipsePreferences preferences : this.getPreferences()) {
                    themeEngine.applyStyles((Object)preferences, false);
                }
            }
        }

        private IThemeEngine getThemeEngine(Event event) {
            return (IThemeEngine)event.getProperty("themeEngine");
        }
    }
}

