/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IDEWorkspacePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IEclipseContext e4Context;
    private Button autoBuildButton;
    private Button autoSaveAllButton;
    private IntegerFieldEditor saveInterval;
    private FieldEditor workspaceName;
    private Button showLocationInWindowTitle;
    private Button autoRefreshButton;
    private Button lightweightRefreshButton;
    private Button closeUnrelatedProjectButton;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineSeparatorEditor;
    private boolean clearUserSettings = false;
    private RadioGroupFieldEditor openReferencesEditor;
    private StringFieldEditor systemExplorer;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.workspace_preference_page_context");
        Composite composite = this.createComposite(parent);
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.Startup", IDEWorkbenchMessages.IDEWorkspacePreference_relatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        area.getControl().setLayoutData((Object)data);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createAutoBuildPref(composite);
        this.createAutoRefreshControls(composite);
        this.createSaveAllBeforeBuildPref(composite);
        this.createCloseUnrelatedProjPrefControls(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createSaveIntervalGroup(composite);
        this.createWindowTitleGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createWorkspaceLocationGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createOpenPrefControls(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createSystemExplorerGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        Composite lower = new Composite(composite, 0);
        GridLayout lowerLayout = new GridLayout();
        lowerLayout.marginWidth = 0;
        lowerLayout.numColumns = 2;
        lowerLayout.makeColumnsEqualWidth = true;
        lower.setLayout((Layout)lowerLayout);
        lower.setLayoutData((Object)new GridData(768));
        this.createEncodingEditorControls(lower);
        this.createLineSeparatorEditorControls(lower);
        this.applyDialogFont(composite);
        return composite;
    }

    private void createOpenPrefControls(Composite parent) {
        String name = "OPEN_REQUIRED_PROJECTS";
        String label = IDEWorkbenchMessages.IDEWorkspacePreference_openReferencedProjects;
        String[][] namesAndValues = new String[][]{{IDEWorkbenchMessages.Always, "always"}, {IDEWorkbenchMessages.Never, "never"}, {IDEWorkbenchMessages.Prompt, "prompt"}};
        this.openReferencesEditor = new RadioGroupFieldEditor(name, label, 3, namesAndValues, parent, true);
        this.openReferencesEditor.setPreferenceStore(this.getIDEPreferenceStore());
        this.openReferencesEditor.setPage((DialogPage)this);
        this.openReferencesEditor.load();
    }

    private void createCloseUnrelatedProjPrefControls(Composite parent) {
        this.closeUnrelatedProjectButton = new Button(parent, 32);
        this.closeUnrelatedProjectButton.setText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_AlwaysCloseWithoutPrompt);
        this.closeUnrelatedProjectButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_closeUnrelatedProjectsToolTip);
        this.closeUnrelatedProjectButton.setSelection(this.getIDEPreferenceStore().getBoolean("CLOSE_UNRELATED_PROJECTS"));
    }

    protected void createSaveAllBeforeBuildPref(Composite composite) {
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuilding);
        this.autoSaveAllButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuildingToolTip);
        this.autoSaveAllButton.setSelection(this.getIDEPreferenceStore().getBoolean("SAVE_ALL_BEFORE_BUILD"));
    }

    protected void createAutoBuildPref(Composite composite) {
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuild);
        this.autoBuildButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuildToolTip);
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
    }

    private void createWorkspaceLocationGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)groupComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(groupComposite);
        Label locationLabel = new Label(groupComposite, 0);
        locationLabel.setText(IDEWorkbenchMessages.IDEWorkspacePreference_workspaceLocation);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)locationLabel);
        Text workspacePath = new Text(groupComposite, 8);
        workspacePath.setBackground(workspacePath.getDisplay().getSystemColor(22));
        workspacePath.setText(TextProcessor.process((String)Platform.getLocation().toOSString()));
        workspacePath.setSelection(workspacePath.getText().length());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(this.convertHorizontalDLUsToPixels(200), -1).applyTo((Control)workspacePath);
        boolean showLocationIsSetOnCommandLine = this.e4Context.containsKey("forcedShowLocation");
        this.showLocationInWindowTitle = new Button(groupComposite, 32);
        this.showLocationInWindowTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showLocationInWindowTitle);
        this.showLocationInWindowTitle.setSelection(showLocationIsSetOnCommandLine || this.getIDEPreferenceStore().getBoolean("SHOW_LOCATION"));
        this.showLocationInWindowTitle.setEnabled(!showLocationIsSetOnCommandLine);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.showLocationInWindowTitle);
        if (showLocationIsSetOnCommandLine) {
            Composite noteComposite = this.createNoteComposite(composite.getFont(), groupComposite, WorkbenchMessages.Preference_note, IDEWorkbenchMessages.IDEWorkspacePreference_showLocationInWindowTitle_lockedByCommandLine);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)noteComposite);
        }
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.saveInterval = new IntegerFieldEditor("saveInterval", IDEWorkbenchMessages.WorkbenchPreference_saveInterval, groupComposite);
        this.saveInterval.setPreferenceStore(this.getIDEPreferenceStore());
        this.saveInterval.setPage((DialogPage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_saveIntervalError, (Object)new Integer(9999)));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        long interval = description.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(interval));
        this.saveInterval.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.saveInterval.isValid());
            }
        });
    }

    private void createWindowTitleGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.workspaceName = new StringFieldEditor("WORKSPACE_NAME", IDEWorkbenchMessages.IDEWorkspacePreference_workspaceName, groupComposite);
        this.workspaceName.setPreferenceStore(this.getIDEPreferenceStore());
        this.workspaceName.load();
        this.workspaceName.setPage((DialogPage)this);
    }

    private void createAutoRefreshControls(Composite parent) {
        this.autoRefreshButton = new Button(parent, 32);
        this.autoRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonText);
        this.autoRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonToolTip);
        this.lightweightRefreshButton = new Button(parent, 32);
        this.lightweightRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshLightweightButtonText);
        this.lightweightRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshLightweightButtonToolTip);
        boolean lightweightRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
        boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.enabled", false, null);
        this.autoRefreshButton.setSelection(autoRefresh);
        this.lightweightRefreshButton.setSelection(lightweightRefresh);
    }

    private void createEncodingEditorControls(Composite parent) {
        Composite encodingComposite = new Composite(parent, 0);
        encodingComposite.setLayout((Layout)new GridLayout());
        encodingComposite.setLayoutData((Object)new GridData(768));
        this.encodingEditor = new ResourceEncodingFieldEditor(IDEWorkbenchMessages.WorkbenchPreference_encoding, encodingComposite, (IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.encodingEditor.isValid());
            }
        });
    }

    private void createLineSeparatorEditorControls(Composite parent) {
        Composite lineComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        lineComposite.setLayout((Layout)gridLayout);
        lineComposite.setLayoutData((Object)new GridData(768));
        this.lineSeparatorEditor = new LineDelimiterEditor(lineComposite);
        this.lineSeparatorEditor.doLoad();
    }

    protected void createSystemExplorerGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.systemExplorer = new StringFieldEditor("SYSTEM_EXPLORER", IDEWorkbenchMessages.IDEWorkbenchPreference_workbenchSystemExplorer, 40, groupComposite);
        Text textControl = this.systemExplorer.getTextControl(groupComposite);
        BidiUtils.applyBidiProcessing((Text)textControl, (String)"ltr");
        gd = (GridData)textControl.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.systemExplorer.setPreferenceStore(this.getIDEPreferenceStore());
        this.systemExplorer.setPage((DialogPage)this);
        this.systemExplorer.load();
        this.systemExplorer.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.systemExplorer.isValid());
            }
        });
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.e4Context = (IEclipseContext)workbench.getService(IEclipseContext.class);
    }

    protected void performDefaults() {
        boolean autoBuild = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("description.autobuilding");
        this.autoBuildButton.setSelection(autoBuild);
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.autoSaveAllButton.setSelection(store.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        this.saveInterval.loadDefault();
        this.showLocationInWindowTitle.setSelection(store.getDefaultBoolean("SHOW_LOCATION"));
        this.workspaceName.loadDefault();
        boolean closeUnrelatedProj = store.getDefaultBoolean("CLOSE_UNRELATED_PROJECTS");
        this.closeUnrelatedProjectButton.setSelection(closeUnrelatedProj);
        boolean lightweightRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.lightweight.enabled");
        boolean autoRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(autoRefresh);
        this.lightweightRefreshButton.setSelection(lightweightRefresh);
        this.clearUserSettings = true;
        List encodings = WorkbenchEncoding.getDefinedEncodings();
        Collections.sort(encodings);
        this.encodingEditor.loadDefault();
        this.lineSeparatorEditor.loadDefault();
        this.openReferencesEditor.loadDefault();
        this.systemExplorer.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (this.autoBuildButton.getSelection() != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            try {
                description.setAutoBuilding(this.autoBuildButton.getSelection());
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing auto build workspace setting.", e.getStatus());
            }
        }
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        long oldSaveInterval = description.getSnapshotInterval() / 60000L;
        long newSaveInterval = new Long(this.saveInterval.getStringValue());
        if (oldSaveInterval != newSaveInterval) {
            try {
                description.setSnapshotInterval(newSaveInterval * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(description);
                store.firePropertyChangeEvent("saveInterval", (Object)new Integer((int)oldSaveInterval), (Object)new Integer((int)newSaveInterval));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing save interval preference", e.getStatus());
            }
        }
        store.setValue("SHOW_LOCATION", this.showLocationInWindowTitle.getSelection());
        this.workspaceName.store();
        this.systemExplorer.store();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean autoRefresh = this.autoRefreshButton.getSelection();
        preferences.setValue("refresh.enabled", autoRefresh);
        boolean lightweightRefresh = this.lightweightRefreshButton.getSelection();
        preferences.setValue("refresh.lightweight.enabled", lightweightRefresh);
        boolean closeUnrelatedProj = this.closeUnrelatedProjectButton.getSelection();
        this.getIDEPreferenceStore().setValue("CLOSE_UNRELATED_PROJECTS", closeUnrelatedProj);
        if (this.clearUserSettings) {
            IDEEncoding.clearUserEncodings();
        }
        this.encodingEditor.store();
        this.lineSeparatorEditor.store();
        this.openReferencesEditor.store();
        return super.performOk();
    }
}

