/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.build;

import org.eclipse.cdt.core.build.CConsoleParser;
import org.eclipse.cdt.internal.ui.build.CConsoleService;
import org.eclipse.cdt.internal.ui.build.CHyperlink;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class CPatternMatchListener
implements IPatternMatchListener {
    protected final CConsoleService console;
    protected final CConsoleParser parser;
    protected TextConsole textConsole;

    public CPatternMatchListener(CConsoleService console, CConsoleParser parser) {
        this.console = console;
        this.parser = parser;
    }

    public void connect(TextConsole console) {
        this.textConsole = console;
    }

    public void disconnect() {
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            String text = this.textConsole.getDocument().get(event.getOffset(), event.getLength());
            IMarker marker = this.parser.generateMarker(this.console.getBuildDirectory(), text);
            if (marker != null) {
                this.textConsole.addHyperlink((IHyperlink)new CHyperlink(marker), event.getOffset() + marker.getAttribute("cdt.link.offset", 0), marker.getAttribute("cdt.link.length", event.getLength()));
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    public String getPattern() {
        return this.parser.getPattern();
    }

    public int getCompilerFlags() {
        return this.parser.getCompilerFlags();
    }

    public String getLineQualifier() {
        return this.parser.getLineQualifier();
    }
}

