/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.renderers.swt.AbstractContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

public class DirectContributionItem
extends AbstractContributionItem {
    private static final String DCI_STATIC_CONTEXT = "DCI-staticContext";
    private static final Object missingExecute = new Object();
    private IEclipseContext infoContext;
    @Inject
    private IContributionFactory contribFactory;

    @Override
    protected void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        String text = this.getModel().getLocalizedLabel();
        if (text != null) {
            item.setText(text);
        } else {
            item.setText("");
        }
        String tooltip = this.getModel().getLocalizedTooltip();
        item.setToolTipText(tooltip);
        item.setSelection(this.getModel().isSelected());
        item.setEnabled(this.getModel().isEnabled());
    }

    @Override
    protected void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        String text = this.getModel().getLocalizedLabel();
        Image icon = item.getImage();
        boolean mode = this.getModel().getTags().contains("FORCE_TEXT");
        if ((icon == null || mode) && text != null) {
            item.setText(text);
        } else {
            item.setText("");
        }
        String tooltip = this.getModel().getLocalizedTooltip();
        item.setToolTipText(tooltip);
        item.setSelection(this.getModel().isSelected());
        item.setEnabled(this.getModel().isEnabled());
    }

    @Override
    protected void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            ToolItemUpdater updater;
            if (this.infoContext != null) {
                this.infoContext.dispose();
                this.infoContext = null;
            }
            if ((updater = this.getUpdater()) != null) {
                updater.removeItem(this);
            }
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget.removeListener(14, this.getItemListener());
            this.widget = null;
            Object obj = this.getModel().getTransientData().get("IDisposable");
            if (obj instanceof Runnable) {
                ((Runnable)obj).run();
            }
            this.getModel().setWidget(null);
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
            this.getModel().setWidget(null);
        }
    }

    private IEclipseContext getStaticContext(Event event) {
        if (this.infoContext == null) {
            this.infoContext = EclipseContextFactory.create((String)DCI_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.getModel(), (IEclipseContext)this.infoContext, (Class[])this.getModel().getClass().getInterfaces());
        }
        if (event == null) {
            this.infoContext.remove(Event.class);
        } else {
            this.infoContext.set(Event.class, (Object)event);
        }
        return this.infoContext;
    }

    @Override
    protected void executeItem(Event trigger) {
        IEclipseContext lclContext = this.getContext((MUIElement)this.getModel());
        if (!this.checkContribution(lclContext)) {
            return;
        }
        MContribution contrib = (MContribution)this.getModel();
        IEclipseContext staticContext = this.getStaticContext(trigger);
        Object result = ContextInjectionFactory.invoke((Object)contrib.getObject(), Execute.class, (IEclipseContext)this.getExecutionContext(lclContext), (IEclipseContext)staticContext, (Object)missingExecute);
        if (result == missingExecute && this.logger != null) {
            this.logger.error("Contribution is missing @Execute: " + contrib.getContributionURI());
        }
    }

    @Override
    protected boolean canExecuteItem(Event trigger) {
        IEclipseContext lclContext = this.getContext((MUIElement)this.getModel());
        if (!this.checkContribution(lclContext)) {
            return false;
        }
        MContribution contrib = (MContribution)this.getModel();
        IEclipseContext staticContext = this.getStaticContext(trigger);
        Boolean result = (Boolean)ContextInjectionFactory.invoke((Object)contrib.getObject(), CanExecute.class, (IEclipseContext)this.getExecutionContext(lclContext), (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        return result;
    }

    private IEclipseContext getExecutionContext(IEclipseContext context) {
        if (context == null) {
            return null;
        }
        return context.getActiveLeaf();
    }

    private boolean checkContribution(IEclipseContext lclContext) {
        if (!(this.getModel() instanceof MContribution)) {
            return false;
        }
        MContribution contrib = (MContribution)this.getModel();
        if (contrib.getObject() == null) {
            contrib.setObject(this.contribFactory.create(contrib.getContributionURI(), lclContext));
        }
        return contrib.getObject() != null;
    }

    @Override
    protected void handleHelpRequest() {
    }
}

