/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class FolderDescription
extends ContainerDescription {
    private boolean virtual = false;

    public FolderDescription(IFolder folder, boolean virtual) {
        super((IContainer)folder);
        this.virtual = virtual;
    }

    public FolderDescription(IFolder folder, URI linkLocation) {
        super((IContainer)folder);
        this.name = folder.getName();
        this.location = linkLocation;
    }

    @Override
    public IResource createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.getWorkspace().getRoot();
        IPath folderPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFolder(folderPath);
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor mon) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IFolder));
        if (resource.exists()) {
            return;
        }
        IFolder folderHandle = (IFolder)resource;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)300);
        subMonitor.setTaskName(UndoMessages.FolderDescription_NewFolderProgress);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.filters != null) {
            SubMonitor loopMonitor = subMonitor.split(100).setWorkRemaining(this.filters.length);
            int i = 0;
            while (i < this.filters.length) {
                folderHandle.createFilter(this.filters[i].getType(), this.filters[i].getFileInfoMatcherDescription(), 0, (IProgressMonitor)loopMonitor.split(1));
                ++i;
            }
        }
        subMonitor.setWorkRemaining(200);
        if (this.location != null) {
            folderHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.split(100));
        } else {
            folderHandle.create(this.virtual ? 8192 : 0, true, (IProgressMonitor)subMonitor.split(100));
        }
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.createChildResources((IContainer)folderHandle, (IProgressMonitor)subMonitor.split(100));
    }
}

