/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class ProjectDescription
extends ContainerDescription {
    private IProjectDescription projectDescription;
    private boolean openOnCreate = true;

    public ProjectDescription(IProject project) {
        super((IContainer)project);
        Assert.isLegal((boolean)project.exists());
        if (project.isOpen()) {
            try {
                this.projectDescription = project.getDescription();
            }
            catch (CoreException coreException) {}
        } else {
            this.openOnCreate = false;
        }
    }

    public ProjectDescription(IProjectDescription projectDescription) {
        this.projectDescription = projectDescription;
    }

    @Override
    public IResource createResourceHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        Assert.isLegal((boolean)(resource instanceof IProject));
        if (resource.exists()) {
            return;
        }
        IProject projectHandle = (IProject)resource;
        subMonitor.setTaskName(UndoMessages.FolderDescription_NewFolderProgress);
        if (this.projectDescription == null) {
            projectHandle.create((IProgressMonitor)subMonitor.split(100));
        } else {
            projectHandle.create(this.projectDescription, (IProgressMonitor)subMonitor.split(100));
        }
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.openOnCreate) {
            projectHandle.open(0, (IProgressMonitor)subMonitor.split(100));
        }
    }

    @Override
    public String getName() {
        if (this.projectDescription != null) {
            return this.projectDescription.getName();
        }
        return super.getName();
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        IProject projectHandle = (IProject)this.createResourceHandle();
        if (projectHandle.isAccessible()) {
            return super.verifyExistence(checkMembers);
        }
        return super.verifyExistence(false);
    }
}

