/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.IErrorParser3;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.internal.core.ProblemMarkerFilterManager;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.errorparsers.ErrorParserExtensionManager;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.service.prefs.BackingStoreException;

public class ErrorParserManager
extends OutputStream
implements IConsoleParser,
IWorkingDirectoryTracker {
    @Deprecated
    public static final String PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    public static final char ERROR_PARSER_DELIMITER = ';';
    public static final String BUILD_CONTEXT = "build";
    private int nOpens;
    private int lineCounter = 0;
    private final IProject fProject;
    private final IMarkerGenerator fMarkerGenerator;
    private Map<String, IErrorParser[]> fErrorParsers;
    private final List<ProblemMarkerInfo> fErrors;
    private final Vector<URI> fDirectoryStack;
    private final URI fBaseDirectoryURI;
    private String previousLine;
    private OutputStream outputStream;
    private final StringBuilder currentLine = new StringBuilder();
    private final StringBuilder scratchBuffer = new StringBuilder();
    private boolean hasErrors = false;
    private String cachedFileName = null;
    private URI cachedWorkingDirectory = null;
    private IFile cachedFile = null;
    private static boolean isCygwin = true;

    public ErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), builder);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, (URI)null, markerGenerator, parsersIDs);
    }

    @Deprecated
    public ErrorParserManager(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, workingDirectory == null || workingDirectory.isEmpty() ? null : URIUtil.toURI((IPath)workingDirectory), markerGenerator, parsersIDs);
    }

    public ErrorParserManager(IProject project, URI baseDirectoryURI, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList<ProblemMarkerInfo>();
        this.enableErrorParsers(parsersIDs);
        this.fBaseDirectoryURI = baseDirectoryURI != null ? baseDirectoryURI : (project != null ? project.getLocationURI() : URIUtil.toURI((String)System.getProperty("user.dir")));
    }

    private void enableErrorParsers(String[] parserIDs) {
        if (parserIDs == null) {
            parserIDs = ErrorParserExtensionManager.getDefaultErrorParserIds();
        }
        this.fErrorParsers = new LinkedHashMap<String, IErrorParser[]>(parserIDs.length);
        String[] stringArray = parserIDs;
        int n = parserIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String parsersID = stringArray[n2];
            IErrorParserNamed errorParser = ErrorParserManager.getErrorParserCopy(parsersID);
            if (errorParser != null) {
                this.fErrorParsers.put(parsersID, new IErrorParser[]{errorParser});
            }
            ++n2;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Deprecated
    public IPath getWorkingDirectory() {
        return URIUtil.toPath((URI)this.getWorkingDirectoryURI());
    }

    @Override
    public URI getWorkingDirectoryURI() {
        if (!this.fDirectoryStack.isEmpty()) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectoryURI;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            URI uri = this.toURI(dir);
            this.pushDirectoryURI(uri);
        }
    }

    public void pushDirectoryURI(URI dir) {
        if (dir != null) {
            if (dir.isAbsolute()) {
                this.fDirectoryStack.addElement(dir);
            } else {
                this.fDirectoryStack.addElement(org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)dir, (URI)this.getWorkingDirectoryURI()));
            }
        }
    }

    @Deprecated
    public IPath popDirectory() {
        return URIUtil.toPath((URI)this.popDirectoryURI());
    }

    public URI popDirectoryURI() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            URI dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return this.fBaseDirectoryURI;
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    @Deprecated
    protected void collectFiles(IProject parent, final List<IResource> result) {
        try {
            parent.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    if (proxy.getType() == 1) {
                        result.add(proxy.requestResource());
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    @Override
    public boolean processLine(String line) {
        String lineTrimmed = line.trim();
        ++this.lineCounter;
        ProblemMarkerInfo marker = null;
        Iterator<IErrorParser[]> iterator = this.fErrorParsers.values().iterator();
        block4: while (iterator.hasNext()) {
            IErrorParser[] parsers;
            IErrorParser[] iErrorParserArray = parsers = iterator.next();
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                IErrorParser parser;
                IErrorParser curr = parser = iErrorParserArray[n2];
                if (parser instanceof ErrorParserNamedWrapper) {
                    curr = ((ErrorParserNamedWrapper)parser).getErrorParser();
                }
                int types = 0;
                if (curr instanceof IErrorParser2) {
                    types = ((IErrorParser2)curr).getProcessLineBehaviour();
                }
                if ((types & 4) != 0 || lineTrimmed.length() <= 1000) {
                    boolean consume;
                    block18: {
                        String lineToParse = lineTrimmed;
                        if ((types & 1) != 0) {
                            lineToParse = line;
                        }
                        consume = false;
                        try {
                            try {
                                consume = curr.processLine(lineToParse, this);
                            }
                            catch (Exception e) {
                                String id = "";
                                if (parser instanceof IErrorParserNamed) {
                                    id = ((IErrorParserNamed)parser).getId();
                                }
                                String message = "Errorparser " + id + " failed parsing line [" + lineToParse + "]";
                                CCorePlugin.log(message, e);
                                if (this.fErrors.size() > 0) {
                                    if (marker == null) {
                                        marker = this.fErrors.get(0);
                                    }
                                    this.fErrors.clear();
                                }
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.fErrors.size() > 0) {
                                if (marker == null) {
                                    marker = this.fErrors.get(0);
                                }
                                this.fErrors.clear();
                            }
                            throw throwable;
                        }
                        if (this.fErrors.size() > 0) {
                            if (marker == null) {
                                marker = this.fErrors.get(0);
                            }
                            this.fErrors.clear();
                        }
                    }
                    if (consume) break block4;
                }
                ++n2;
            }
        }
        this.outputLine(line, marker);
        return false;
    }

    private void outputLine(String line, ProblemMarkerInfo marker) {
        String l = String.valueOf(line) + "\n";
        if (this.outputStream == null) {
            return;
        }
        try {
            if (marker != null && this.outputStream instanceof IErrorMarkeredOutputStream) {
                IErrorMarkeredOutputStream s = (IErrorMarkeredOutputStream)((Object)this.outputStream);
                s.write(l, marker);
            } else {
                byte[] b = l.getBytes();
                this.outputStream.write(b, 0, b.length);
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    public IFile findFileName(String partialLoc) {
        if (partialLoc.equals(this.cachedFileName) && this.cachedWorkingDirectory != null && URIUtil.equals((URI)this.getWorkingDirectoryURI(), (URI)this.cachedWorkingDirectory)) {
            return this.cachedFile;
        }
        Path path = new Path(partialLoc.replace('\\', '/'));
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null) {
            IProject[] prjs;
            path = path.setDevice(null);
            IFile[] files = null;
            if (this.fProject != null && (files = ResourceLookup.findFilesByName((IPath)path, prjs = new IProject[]{this.fProject}, false)).length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, prjs, true);
            }
            if ((files == null || files.length == 0) && (files = ResourceLookup.findFilesByName((IPath)path, prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects(), false)).length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, prjs, true);
            }
            if (files.length == 1) {
                file = files[0];
            }
        }
        if (file == null && isCygwin && path.isAbsolute()) {
            file = this.findCygwinFile(partialLoc);
        }
        this.cachedFileName = partialLoc;
        this.cachedWorkingDirectory = this.getWorkingDirectoryURI();
        this.cachedFile = file;
        return file;
    }

    protected IFile findFileInWorkspace(IPath path) {
        URI uri = this.toURI(path);
        IFile file = this.findFileInWorkspace(uri);
        return file;
    }

    protected IFile findFileInWorkspace(URI uri) {
        IFile f;
        if (!uri.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI());
        }
        if ((f = ResourceLookup.selectFileForLocationURI(uri, this.fProject)) != null && f.isAccessible()) {
            return f;
        }
        return null;
    }

    @Deprecated
    public boolean isConflictingName(String fileName) {
        return ResourceLookup.findFilesByName((IPath)new Path(fileName), new IProject[]{this.fProject}, false).length > 1;
    }

    @Deprecated
    public IFile findFilePath(String filePath) {
        Path path = new Path(filePath);
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null && isCygwin) {
            file = this.findCygwinFile(filePath);
        }
        return file != null && file.exists() ? file : null;
    }

    private IFile findCygwinFile(String filePath) {
        IFile file = null;
        try {
            Path path = new Path(Cygwin.cygwinToWindowsPath(filePath));
            file = this.findFileInWorkspace((IPath)path);
        }
        catch (UnsupportedOperationException e) {
            isCygwin = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null);
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        if (file == null) {
            file = this.fProject;
        }
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.addProblemMarker(problemMarkerInfo);
    }

    public void addProblemMarker(ProblemMarkerInfo problemMarkerInfo) {
        if (!ProblemMarkerFilterManager.getInstance().acceptMarker(problemMarkerInfo)) {
            return;
        }
        this.fErrors.add(problemMarkerInfo);
        this.fMarkerGenerator.addMarker(problemMarkerInfo);
        if (problemMarkerInfo.severity == 2) {
            this.hasErrors = true;
        }
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            this.processLine(line);
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    @Deprecated
    public boolean reportProblems() {
        return false;
    }

    private URI toURI(IPath path) {
        URI uri = null;
        URI workingDirectoryURI = this.getWorkingDirectoryURI();
        uri = path.isAbsolute() ? EFSExtensionManager.getDefault().createNewURIFromPath(workingDirectoryURI, path.toString()) : EFSExtensionManager.getDefault().append(workingDirectoryURI, path.toString());
        return uri;
    }

    @Deprecated
    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    @Deprecated
    public void appendToScratchBuffer(String line) {
        this.scratchBuffer.append(line);
    }

    @Deprecated
    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    @Deprecated
    public boolean hasErrors() {
        return this.hasErrors;
    }

    public static String[] getUserDefinedErrorParserIds() {
        return ErrorParserExtensionManager.getUserDefinedErrorParserIds();
    }

    public static void setUserDefinedErrorParsers(IErrorParserNamed[] errorParsers) throws CoreException {
        ErrorParserExtensionManager.setUserDefinedErrorParsers(errorParsers);
    }

    public static String[] getErrorParserAvailableIds() {
        return ErrorParserExtensionManager.getErrorParserAvailableIds();
    }

    public static String[] getErrorParserAvailableIdsInContext(String context) {
        return ErrorParserExtensionManager.getErrorParserAvailableIdsInContext(context);
    }

    public static String[] getErrorParserExtensionIds() {
        return ErrorParserExtensionManager.getErrorParserExtensionIds();
    }

    public static void setDefaultErrorParserIds(String[] ids) throws BackingStoreException {
        ErrorParserExtensionManager.setDefaultErrorParserIds(ids);
    }

    public static String[] getDefaultErrorParserIds() {
        return ErrorParserExtensionManager.getDefaultErrorParserIds();
    }

    public static IErrorParserNamed getErrorParserCopy(String id) {
        return ErrorParserExtensionManager.getErrorParserCopy(id, false);
    }

    public static IErrorParserNamed getErrorParserExtensionCopy(String id) {
        return ErrorParserExtensionManager.getErrorParserCopy(id, true);
    }

    public static String toDelimitedString(String[] ids) {
        String result = "";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            result = result.length() == 0 ? id : String.valueOf(result) + ';' + id;
            ++n2;
        }
        return result;
    }

    @Override
    public void shutdown() {
        Iterator<IErrorParser[]> iterator = this.fErrorParsers.values().iterator();
        while (iterator.hasNext()) {
            IErrorParser[] parsers;
            IErrorParser[] iErrorParserArray = parsers = iterator.next();
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                IErrorParser parser = iErrorParserArray[n2];
                if (parser instanceof IErrorParser3) {
                    ((IErrorParser3)parser).shutdown();
                }
                ++n2;
            }
        }
    }
}

