/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalUnary
extends CPPDependentEvaluation {
    private static final ICPPEvaluation ZERO_EVAL = new EvalFixed(CPPSemantics.INT_TYPE, IASTExpression.ValueCategory.PRVALUE, Value.create(0L));
    private final int fOperator;
    private final ICPPEvaluation fArgument;
    private final IBinding fAddressOfQualifiedNameBinding;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;

    public EvalUnary(int operator, ICPPEvaluation operand, IBinding addressOfQualifiedNameBinding, IASTNode pointOfDefinition) {
        this(operator, operand, addressOfQualifiedNameBinding, EvalUnary.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalUnary(int operator, ICPPEvaluation operand, IBinding addressOfQualifiedNameBinding, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fArgument = operand;
        this.fAddressOfQualifiedNameBinding = addressOfQualifiedNameBinding;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public ICPPEvaluation getArgument() {
        return this.fArgument;
    }

    public IBinding getAddressOfQualifiedNameBinding() {
        return this.fAddressOfQualifiedNameBinding;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        switch (this.fOperator) {
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return this.fArgument.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        switch (this.fOperator) {
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                return this.fArgument.isTypeDependent();
            }
            case 17: {
                return this.fArgument.referencesTemplateParameter();
            }
            case 12: {
                return false;
            }
        }
        return this.fArgument.isValueDependent();
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return this.fArgument.isConstantExpression(point) && EvalUnary.isNullOrConstexprFunc(this.getOverload(point));
    }

    public ICPPFunction getOverload(IASTNode point) {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload(point);
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload(IASTNode point) {
        ICPPMember member;
        OverloadableOperator op = OverloadableOperator.fromUnaryExpression(this.fOperator);
        if (op == null) {
            return null;
        }
        if (this.fArgument.isTypeDependent()) {
            return null;
        }
        if (this.fAddressOfQualifiedNameBinding instanceof ICPPMember && !(member = (ICPPMember)this.fAddressOfQualifiedNameBinding).isStatic()) {
            return null;
        }
        IType type = this.fArgument.getTypeOrFunctionSet(point);
        if (!CPPSemantics.isUserDefined(type = SemanticUtil.getNestedType(type, 13))) {
            return null;
        }
        ICPPEvaluation[] args = this.fOperator == 10 || this.fOperator == 9 ? new ICPPEvaluation[]{this.fArgument, ZERO_EVAL} : new ICPPEvaluation[]{this.fArgument};
        return CPPSemantics.findOverloadedOperator(point, this.getTemplateDefinitionScope(), args, type, op, CPPSemantics.LookupMode.LIMITED_GLOBALS);
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 8: 
            case 16: {
                return CPPVisitor.get_SIZE_T(point);
            }
            case 13: {
                return CPPVisitor.get_type_info(point);
            }
            case 12: {
                return CPPSemantics.VOID_TYPE;
            }
            case 5: {
                ICPPMember member;
                if (this.fAddressOfQualifiedNameBinding instanceof ICPPMember && !(member = (ICPPMember)this.fAddressOfQualifiedNameBinding).isStatic()) {
                    try {
                        return new CPPPointerToMemberType(member.getType(), member.getClassOwner(), false, false, false);
                    }
                    catch (DOMException e) {
                        return e.getProblem();
                    }
                }
                return new CPPPointerType(this.fArgument.getTypeOrFunctionSet(point));
            }
            case 4: {
                IType type = this.fArgument.getTypeOrFunctionSet(point);
                type = ExpressionTypes.prvalueTypeWithResolvedTypedefs(type);
                if (type instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type).getType());
                }
                if (type instanceof ISemanticProblem) {
                    return type;
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
            case 7: 
            case 17: {
                return CPPBasicType.BOOLEAN;
            }
            case 9: 
            case 10: {
                return ExpressionTypes.prvalueType(this.fArgument.getTypeOrFunctionSet(point));
            }
            case 2: {
                return this.promoteType(this.fArgument.getTypeOrFunctionSet(point), true);
            }
            case 3: 
            case 6: {
                return this.promoteType(this.fArgument.getTypeOrFunctionSet(point), false);
            }
        }
        return this.fArgument.getTypeOrFunctionSet(point);
    }

    private IType promoteType(IType type, boolean allowPointer) {
        IType t3;
        IType t1 = ExpressionTypes.prvalueType(type);
        IType t2 = SemanticUtil.getNestedType(t1, 1);
        if (allowPointer) {
            if (t2 instanceof CPPClosureType) {
                ICPPMethod conversionOperator = ((CPPClosureType)t2).getConversionOperator();
                if (conversionOperator == null) {
                    return ProblemType.UNKNOWN_FOR_EXPRESSION;
                }
                return new CPPPointerType(conversionOperator.getType().getReturnType());
            }
            if (t2 instanceof IPointerType) {
                return t1;
            }
        }
        if ((t3 = CPPArithmeticConversion.promoteCppType(t2)) == null && !(t2 instanceof IBasicType)) {
            return ProblemType.UNKNOWN_FOR_EXPRESSION;
        }
        return t3 == null || t3 == t2 ? t1 : t3;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        if (this.getOverload(point) != null) {
            return Value.create(this);
        }
        switch (this.fOperator) {
            case 8: {
                SizeofCalculator.SizeAndAlignment info = SizeofCalculator.getSizeAndAlignment(this.fArgument.getTypeOrFunctionSet(point), point);
                return info == null ? Value.UNKNOWN : Value.create(info.size);
            }
            case 15: {
                SizeofCalculator.SizeAndAlignment info = SizeofCalculator.getSizeAndAlignment(this.fArgument.getTypeOrFunctionSet(point), point);
                return info == null ? Value.UNKNOWN : Value.create(info.alignment);
            }
            case 17: {
                return Value.UNKNOWN;
            }
            case 16: {
                return Value.UNKNOWN;
            }
            case 13: {
                return Value.UNKNOWN;
            }
            case 12: {
                return Value.UNKNOWN;
            }
        }
        IValue val = this.fArgument.getValue(point);
        if (val == null) {
            return Value.UNKNOWN;
        }
        Long num = val.numericalValue();
        if (num != null) {
            return Value.evaluateUnaryExpression(this.fOperator, num);
        }
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        ICPPFunction overload = this.getOverload(point);
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 0: 
            case 1: 
            case 4: 
            case 13: {
                return IASTExpression.ValueCategory.LVALUE;
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)15);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalEvaluation(this.fArgument, includeValue);
        buffer.marshalBinding(this.fAddressOfQualifiedNameBinding);
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        ICPPEvaluation arg = (ICPPEvaluation)buffer.unmarshalEvaluation();
        IBinding binding = buffer.unmarshalBinding();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalUnary(op, arg, binding, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPTypeSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation argument = this.fArgument.instantiate(tpMap, packOffset, within, maxdepth, point);
        IBinding binding = this.fAddressOfQualifiedNameBinding;
        if (binding instanceof ICPPUnknownBinding) {
            try {
                binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)binding, tpMap, packOffset, within, point);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (argument == this.fArgument && binding == this.fAddressOfQualifiedNameBinding) {
            return this;
        }
        return new EvalUnary(this.fOperator, argument, binding, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation argument = this.fArgument.computeForFunctionCall(parameterMap, context.recordStep());
        if (argument == this.fArgument) {
            return this;
        }
        return new EvalUnary(this.fOperator, argument, this.fAddressOfQualifiedNameBinding, this.getTemplateDefinition());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return this.fArgument.determinePackSize(tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fArgument.referencesTemplateParameter();
    }
}

