/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.etfw.toolopts.ToolApp;
import org.eclipse.ptp.etfw.ui.AbstractToolConfigurationTab;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.messages.Messages;
import org.eclipse.ptp.internal.etfw.toolopts.ToolMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETFWUtils {
    private static ExternalToolProcess[] tools = null;
    private static ArrayList<IFileStore> workflowList = null;
    private static ArrayList<AbstractToolConfigurationTab> perfConfTabs = null;
    private static ArrayList<IToolUITab> toolUITabs = null;
    private static ArrayList<AbstractToolDataManager> perfConfManagers = null;

    private static ArrayList<IFileStore> getInternalXMLWorkflows() {
        IExtension[] extensions;
        if (workflowList != null) {
            return workflowList;
        }
        workflowList = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.workflows");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            IFileStore ifs = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    String plugspace = ext.getNamespaceIdentifier();
                    String aGetter = ce.getAttribute("XMLFile");
                    URI iuri = new URI(FileLocator.toFileURL((URL)Platform.getBundle((String)plugspace).getEntry(aGetter)).toString().replaceAll(" ", "%20"));
                    ifs = EFS.getLocalFileSystem().getStore(iuri);
                    workflowList.add(ifs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
        return workflowList;
    }

    public static ArrayList<AbstractToolDataManager> getPerfConfManagers() {
        IExtension[] extensions;
        if (perfConfManagers != null) {
            return perfConfManagers;
        }
        perfConfManagers = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.dataManagers");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    AbstractToolDataManager aGetter = (AbstractToolDataManager)ce.createExecutableExtension("class");
                    perfConfManagers.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
        return perfConfManagers;
    }

    public static AbstractToolDataManager getPerfDataManager(String name) {
        if (name == null) {
            return null;
        }
        AbstractToolDataManager check2 = null;
        for (AbstractToolDataManager check2 : perfConfManagers) {
            if (!check2.getName().equals(name)) continue;
            return check2;
        }
        return null;
    }

    public static ArrayList<AbstractToolConfigurationTab> getPerfTabs() {
        IExtension[] extensions;
        if (perfConfTabs != null) {
            return perfConfTabs;
        }
        perfConfTabs = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.configurationTabs");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    AbstractToolConfigurationTab aGetter = (AbstractToolConfigurationTab)((Object)ce.createExecutableExtension("class"));
                    perfConfTabs.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
        return perfConfTabs;
    }

    public static ExternalToolProcess getTool(int dex) {
        if (dex < tools.length) {
            return tools[dex];
        }
        return null;
    }

    public static ExternalToolProcess getTool(String toolName) {
        ExternalToolProcess[] externalToolProcessArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalToolProcess tool = externalToolProcessArray[n2];
            if (tool.toolName.equals(toolName)) {
                return tool;
            }
            ++n2;
        }
        return null;
    }

    public static IToolUITab[] getToolPanes() {
        ArrayList<IToolUITab> paneList = new ArrayList<IToolUITab>();
        IToolUITab[] panes = null;
        if (tools.length <= 0) {
            return null;
        }
        ExternalToolProcess[] externalToolProcessArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalToolProcess tool = externalToolProcessArray[n2];
            int j = 0;
            while (j < tool.externalTools.size()) {
                int n3;
                int n4;
                ToolApp[] toolAppArray;
                ExternalTool t = (ExternalTool)tool.externalTools.get(j);
                if (t instanceof BuildTool) {
                    BuildTool bt = (BuildTool)t;
                    ETFWUtils.insertPanes(bt.getAllCompilerPanes(), paneList);
                } else if (t instanceof ExecTool) {
                    ExecTool et = (ExecTool)t;
                    toolAppArray = et.execUtils;
                    n4 = et.execUtils.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ToolApp execUtil = toolAppArray[n3];
                        ETFWUtils.insertPanes((IToolUITab[])execUtil.toolPanes, paneList);
                        ++n3;
                    }
                } else if (t instanceof PostProcTool) {
                    PostProcTool pt = (PostProcTool)t;
                    toolAppArray = pt.analysisCommands;
                    n4 = pt.analysisCommands.length;
                    n3 = 0;
                    while (n3 < n4) {
                        ToolApp analysisCommand = toolAppArray[n3];
                        ETFWUtils.insertPanes((IToolUITab[])analysisCommand.toolPanes, paneList);
                        ++n3;
                    }
                }
                if (t.global != null) {
                    ETFWUtils.insertPanes((IToolUITab[])t.global.toolPanes, paneList);
                }
                ++j;
            }
            ++n2;
        }
        ArrayList<IToolUITab> uitList = ETFWUtils.getToolUITabs();
        if (uitList != null && uitList.size() > 0) {
            int i = 0;
            while (i < uitList.size()) {
                paneList.add(uitList.get(i));
                ++i;
            }
        }
        panes = new IToolUITab[paneList.size()];
        paneList.toArray(panes);
        return panes;
    }

    public static ExternalToolProcess[] getTools() {
        return tools;
    }

    public static ArrayList<IToolUITab> getToolUITabs() {
        if (toolUITabs == null) {
            IExtension[] extensions;
            toolUITabs = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.toolUITabs");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    try {
                        IToolUITab aGetter = (IToolUITab)ce.createExecutableExtension("class");
                        toolUITabs.add(aGetter);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return toolUITabs;
    }

    private static void insertPanes(IToolUITab[] panes, List<IToolUITab> paneList) {
        if (panes != null && panes.length > 0) {
            int k = 0;
            while (k < panes.length) {
                if (!panes[k].isVirtual()) {
                    paneList.add(panes[k]);
                }
                ++k;
            }
        }
    }

    private static void insertPanes(List<IToolUITab> panes, List<IToolUITab> paneList) {
        if (panes != null && panes.size() > 0) {
            int k = 0;
            while (k < panes.size()) {
                if (!panes.get(k).isVirtual()) {
                    paneList.add(panes.get(k));
                }
                ++k;
            }
        }
    }

    public static void refreshTools(IPreferenceStore store) {
        ExternalToolProcess[] externalToolProcessArray;
        IFileStore toolxml;
        IFileInfo finf;
        String epath;
        ETFWUtils.getInternalXMLWorkflows();
        ArrayList<ExternalToolProcess> theTools = new ArrayList<ExternalToolProcess>();
        IFileSystem loc = EFS.getLocalFileSystem();
        String fiList = store.getString("tool_def_xml_location");
        String[] fiLocs = fiList.split(",,,");
        ArrayList<IFileStore> files = new ArrayList<IFileStore>();
        IFileStore fi = null;
        String[] stringArray = fiLocs;
        int n = fiLocs.length;
        int n2 = 0;
        while (n2 < n) {
            String fiLoc = stringArray[n2];
            try {
                fi = loc.getStore(new URI(fiLoc));
            }
            catch (URISyntaxException uRISyntaxException) {
                fi = EFS.getLocalFileSystem().getStore((IPath)new Path(fiLoc));
            }
            IFileInfo finf2 = fi.fetchInfo();
            if (finf2.exists() && !finf2.isDirectory()) {
                files.add(fi);
            }
            ++n2;
        }
        if (files.size() == 0 && (epath = BuildLaunchUtils.checkLocalToolEnvPath("eclipse")) != null && (finf = (toolxml = loc.getStore((IPath)new Path(epath))).fetchInfo()).exists() && (finf = (toolxml = toolxml.getChild("tool.xml")).fetchInfo()).exists()) {
            files.add(toolxml);
            store.setValue("tool_def_xml_location", toolxml.toURI().toString());
        }
        int i = 0;
        while (i < workflowList.size()) {
            tools = ToolMaker.makeTools((IFileStore)workflowList.get(i));
            if (tools != null) {
                externalToolProcessArray = tools;
                int n3 = tools.length;
                n = 0;
                while (n < n3) {
                    ExternalToolProcess tool = externalToolProcessArray[n];
                    theTools.add(tool);
                    ++n;
                }
            }
            ++i;
        }
        i = 0;
        while (i < files.size()) {
            try {
                tools = ToolMaker.makeTools((IFileStore)((IFileStore)files.get(i)));
            }
            catch (Exception e) {
                tools = null;
                e.printStackTrace();
                System.out.println(String.valueOf(Messages.Activator_ProblemReading) + ((IFileStore)files.get(i)).toString());
            }
            if (tools != null) {
                externalToolProcessArray = tools;
                int n4 = tools.length;
                n = 0;
                while (n < n4) {
                    ExternalToolProcess tool = externalToolProcessArray[n];
                    theTools.add(tool);
                    ++n;
                }
            }
            tools = null;
            ++i;
        }
        tools = theTools.toArray(new ExternalToolProcess[theTools.size()]);
        stringArray = tools;
        n = tools.length;
        int n5 = 0;
        while (n5 < n) {
            String tool = stringArray[n5];
            BuildLaunchUtils.verifyLocalEnvToolPath((ExternalToolProcess)tool);
            ++n5;
        }
    }
}

