/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.gem;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ptp.internal.gem.util.GemUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GemPlugin
extends AbstractUIPlugin {
    private static GemPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.ptp.gem";
    private IEclipsePreferences gemPreferences;
    private static Map<ImageDescriptor, Image> imageCache;

    static {
        imageCache = new HashMap<ImageDescriptor, Image>();
    }

    public static GemPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return GemPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public URI getConfigDir() {
        URL configURL;
        Location location = Platform.getConfigurationLocation();
        if (location != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            try {
                return configURL.toURI();
            }
            catch (URISyntaxException e) {
                GemUtilities.logExceptionDetail(e);
            }
        }
        return null;
    }

    public Preferences getConfigPrefs() {
        if (this.gemPreferences == null) {
            this.gemPreferences = (IEclipsePreferences)ConfigurationScope.INSTANCE;
        }
        return this.gemPreferences;
    }

    public Version getVersion() {
        return new Version((String)this.getBundle().getHeaders().get("Bundle-Version"));
    }

    public void saveConfigPrefs() {
        if (this.gemPreferences != null) {
            try {
                this.gemPreferences.flush();
            }
            catch (BackingStoreException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        this.saveConfigPrefs();
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        Iterator<Image> iter = imageCache.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
        imageCache.clear();
        iter = null;
        imageCache = null;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

