/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryComparator;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPageContainer;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskSearchPage
extends DialogPage
implements ISearchPage {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.search.page";
    private static final String PAGE_KEY = "page";
    private static final String PAGE_NAME = "TaskSearchPage";
    private static final String STORE_REPO_ID = "TaskSearchPage.REPO";
    private Combo repositoryCombo;
    private Text keyText;
    private TaskRepository repository;
    private Composite fParentComposite;
    private IDialogSettings fDialogSettings;
    private int currentPageIndex = -1;
    private boolean firstView = true;
    private Control[] queryPages;
    private ISearchPageContainer pageContainer;
    private ITaskSearchPageContainer taskSearchPageContainer;
    private ImageHyperlink clearKey;

    public boolean performAction() {
        this.saveDialogSettings();
        String key = this.keyText.getText();
        if (key != null && key.trim().length() > 0) {
            boolean openSuccessful = TasksUiInternal.openTaskByIdOrKey((TaskRepository)this.repository, (String)(key = key.trim()), null);
            if (!openSuccessful) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TaskSearchPage_Task_Search, (String)(String.valueOf(Messages.TaskSearchPage_No_task_found_matching_key_) + key));
            }
            return openSuccessful;
        }
        ITaskSearchPage page = (ITaskSearchPage)this.queryPages[this.currentPageIndex].getData(PAGE_KEY);
        return page.performSearch();
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
        this.taskSearchPageContainer = new ITaskSearchPageContainer(){

            public IRunnableContext getRunnableContext() {
                return TaskSearchPage.this.pageContainer.getRunnableContext();
            }

            public void setPerformActionEnabled(boolean enabled) {
                TaskSearchPage.this.pageContainer.setPerformActionEnabled(enabled);
            }
        };
    }

    public void createControl(Composite parent) {
        this.fParentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.fParentComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.fParentComposite.setLayoutData((Object)gd);
        this.createRepositoryGroup(this.fParentComposite);
        this.setControl((Control)this.fParentComposite);
        Dialog.applyDialogFont((Control)this.fParentComposite);
    }

    private void createRepositoryGroup(Composite control) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText(Messages.TaskSearchPage_Repository);
        this.repositoryCombo = new Combo(group, 2060);
        this.repositoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskSearchPage.this.displayQueryPage(TaskSearchPage.this.repositoryCombo.getSelectionIndex());
            }
        });
        label = new Label(group, 0);
        label.setText("  ");
        Label labelKey = new Label(group, 0);
        labelKey.setText(Messages.TaskSearchPage_Task_Key_ID);
        this.keyText = new Text(group, 2048);
        this.keyText.setLayoutData((Object)new GridData(768));
        String findText = null;
        TaskListView taskListView = TaskListView.getFromActivePerspective();
        if (taskListView != null && (findText = taskListView.getFilteredTree().getFilterControl().getText()) != null && findText.trim().length() > 0 && this.isTaskKeyCandidate(findText.trim())) {
            this.pageContainer.setPerformActionEnabled(true);
            this.keyText.setText(findText.trim());
            this.keyText.setFocus();
        }
        this.keyText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TaskSearchPage.this.updatePageEnablement();
            }
        });
        this.clearKey = new ImageHyperlink(group, 0);
        this.clearKey.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
        this.clearKey.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskSearchPage.this.keyText.setText("");
                TaskSearchPage.this.updatePageEnablement();
            }
        });
    }

    private void updatePageEnablement() {
        if (this.keyText.getText() != null && this.keyText.getText().trim().length() > 0) {
            if (this.queryPages != null && this.queryPages[this.currentPageIndex] != null && this.queryPages[this.currentPageIndex].getData(PAGE_KEY) instanceof AbstractRepositoryQueryPage) {
                ((AbstractRepositoryQueryPage)this.queryPages[this.currentPageIndex].getData(PAGE_KEY)).setControlsEnabled(false);
            }
            if (this.repositoryCombo.getSelectionIndex() > -1) {
                this.pageContainer.setPerformActionEnabled(true);
            }
        } else if (this.queryPages != null && this.queryPages[this.currentPageIndex] != null && this.queryPages[this.currentPageIndex].getData(PAGE_KEY) instanceof AbstractRepositoryQueryPage) {
            ((AbstractRepositoryQueryPage)this.queryPages[this.currentPageIndex].getData(PAGE_KEY)).setControlsEnabled(true);
        }
        if (this.keyText != null && this.repositoryCombo != null && this.clearKey != null) {
            boolean hasRepos = this.repositoryCombo.getItemCount() > 0;
            this.keyText.setEnabled(hasRepos);
            this.repositoryCombo.setEnabled(hasRepos);
            this.clearKey.setEnabled(hasRepos);
        }
    }

    private Control createPage(TaskRepository repository, ITaskSearchPage searchPage) {
        Composite pageWrapper = new Composite(this.fParentComposite, 0);
        pageWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageWrapper.setLayout((Layout)layout);
        try {
            searchPage.setContainer(this.taskSearchPageContainer);
            searchPage.createControl(pageWrapper);
        }
        catch (Exception e) {
            pageWrapper.dispose();
            searchPage.dispose();
            searchPage = this.createErrorPage(repository, e);
            return searchPage.getControl();
        }
        IDialogSettings searchDialogSettings = SearchPlugin.getDefault().getDialogSettingsSection("DialogBounds_SearchDialog");
        if (searchDialogSettings.get("DIALOG_WIDTH") == null) {
            this.fParentComposite.getParent().getShell().pack();
        }
        pageWrapper.setData(PAGE_KEY, (Object)searchPage);
        return pageWrapper;
    }

    private ITaskSearchPage createErrorPage(TaskRepository repository, Throwable e) {
        Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", "Error occurred while constructing search page for " + repository.getRepositoryUrl() + " [" + repository.getConnectorKind() + "]", e);
        StatusHandler.log((IStatus)status);
        DeadSearchPage searchPage = new DeadSearchPage(repository, status);
        searchPage.setContainer(this.taskSearchPageContainer);
        searchPage.createControl(this.fParentComposite);
        searchPage.getControl().setData(PAGE_KEY, (Object)searchPage);
        return searchPage;
    }

    private void displayQueryPage(final int pageIndex) {
        AbstractRepositoryConnectorUi connectorUi;
        GridData data;
        if (this.currentPageIndex == pageIndex || pageIndex < 0) {
            return;
        }
        if (this.currentPageIndex != -1 && this.queryPages[this.currentPageIndex] != null) {
            this.queryPages[this.currentPageIndex].setVisible(false);
            ITaskSearchPage page = (ITaskSearchPage)this.queryPages[this.currentPageIndex].getData(PAGE_KEY);
            page.setVisible(false);
            data = (GridData)this.queryPages[this.currentPageIndex].getLayoutData();
            data.exclude = true;
            this.queryPages[this.currentPageIndex].setLayoutData((Object)data);
        }
        String repositoryLabel = this.repositoryCombo.getItem(pageIndex);
        this.repository = (TaskRepository)this.repositoryCombo.getData(repositoryLabel);
        if (this.queryPages[pageIndex] == null && this.repository != null && (connectorUi = TasksUiPlugin.getConnectorUi((String)this.repository.getConnectorKind())) != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ITaskSearchPage searchPage = TaskSearchPage.this.getSearchPage(connectorUi);
                    if (searchPage != null) {
                        ((TaskSearchPage)TaskSearchPage.this).queryPages[pageIndex] = TaskSearchPage.this.createPage(TaskSearchPage.this.repository, searchPage);
                    } else {
                        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(TaskSearchPage.this.repository.getConnectorKind());
                        if (connector.canCreateTaskFromKey(TaskSearchPage.this.repository)) {
                            ((TaskSearchPage)TaskSearchPage.this).queryPages[pageIndex] = TaskSearchPage.this.createPage(TaskSearchPage.this.repository, (ITaskSearchPage)new NoSearchPage(TaskSearchPage.this.repository));
                        }
                    }
                }

                public void handleException(Throwable e) {
                    ITaskSearchPage page = TaskSearchPage.this.createErrorPage(TaskSearchPage.this.repository, e);
                    ((TaskSearchPage)TaskSearchPage.this).queryPages[pageIndex] = page.getControl();
                }
            });
        }
        if (this.repository != null) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector.canCreateTaskFromKey(this.repository)) {
                this.keyText.setEnabled(true);
            } else {
                this.keyText.setEnabled(false);
            }
        }
        if (this.queryPages[pageIndex] != null) {
            data = (GridData)this.queryPages[pageIndex].getLayoutData();
            if (data == null) {
                data = new GridData();
            }
            data.exclude = false;
            this.queryPages[pageIndex].setLayoutData((Object)data);
            this.queryPages[pageIndex].setVisible(true);
            ITaskSearchPage page = (ITaskSearchPage)this.queryPages[pageIndex].getData(PAGE_KEY);
            page.setVisible(true);
        }
        this.currentPageIndex = pageIndex;
        this.fParentComposite.getParent().layout(true, true);
        this.updatePageEnablement();
    }

    private ITaskSearchPage getSearchPage(AbstractRepositoryConnectorUi connectorUi) {
        if (connectorUi.hasSearchPage()) {
            return connectorUi.getSearchPage(this.repository, null);
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (this.firstView) {
            this.firstView = false;
            this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            List repositories = TasksUi.getRepositoryManager().getAllRepositories();
            ArrayList<TaskRepository> searchableRepositories = new ArrayList<TaskRepository>(repositories.size());
            for (TaskRepository repository : repositories) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi((String)repository.getConnectorKind());
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                if ((connectorUi == null || !connectorUi.hasSearchPage() || repository.isOffline()) && !connector.canCreateTaskFromKey(repository)) continue;
                searchableRepositories.add(repository);
            }
            Collections.sort(searchableRepositories, new TaskRepositoryComparator());
            String[] repositoryUrls = new String[searchableRepositories.size()];
            int i = 0;
            int indexToSelect = 0;
            for (TaskRepository currRepsitory : searchableRepositories) {
                if (this.repository != null && this.repository.equals((Object)currRepsitory)) {
                    indexToSelect = i;
                }
                repositoryUrls[i] = currRepsitory.getRepositoryUrl();
                ++i;
            }
            IDialogSettings settings = this.getDialogSettings();
            if (this.repositoryCombo != null) {
                int x = 0;
                while (x < searchableRepositories.size()) {
                    this.repositoryCombo.add(((TaskRepository)searchableRepositories.get(x)).getRepositoryLabel());
                    this.repositoryCombo.setData(((TaskRepository)searchableRepositories.get(x)).getRepositoryLabel(), searchableRepositories.get(x));
                    ++x;
                }
                if (searchableRepositories.isEmpty()) {
                    if (repositories.isEmpty()) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TaskSearchPage_Repository_Search, (String)Messages.TaskSearchPage_no_available_repositories);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TaskSearchPage_Repository_Search, (String)Messages.TaskSearchPage_no_searchable_repositories);
                    }
                } else {
                    String selectRepo = settings.get(STORE_REPO_ID);
                    if (selectRepo != null && this.repositoryCombo.indexOf(selectRepo) > -1) {
                        this.repositoryCombo.select(this.repositoryCombo.indexOf(selectRepo));
                        this.repository = (TaskRepository)this.repositoryCombo.getData(selectRepo);
                    } else {
                        this.repositoryCombo.select(indexToSelect);
                    }
                    this.queryPages = new Control[repositoryUrls.length];
                    this.displayQueryPage(this.repositoryCombo.getSelectionIndex());
                }
            }
        }
        if (this.queryPages == null) {
            this.pageContainer.setPerformActionEnabled(false);
        }
        super.setVisible(visible);
        this.setDefaultValuesAndFocus();
    }

    private void setDefaultValuesAndFocus() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TaskRepository repository;
            ISearchQuery[] queries;
            String repositoryUrl = null;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof ISearchResultViewPart && (queries = NewSearchUI.getQueries()).length > 0 && queries[0] instanceof SearchHitCollector) {
                repositoryUrl = ((SearchHitCollector)queries[0]).getRepositoryQuery().getRepositoryUrl();
            }
            if (repositoryUrl != null && (repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl)) != null) {
                int index = 0;
                String[] stringArray = this.repositoryCombo.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String repositoryLabel = stringArray[n2];
                    if (repositoryLabel.equals(repository.getRepositoryLabel())) {
                        this.repositoryCombo.select(index);
                    }
                    ++index;
                    ++n2;
                }
                this.displayQueryPage(this.repositoryCombo.getSelectionIndex());
            }
        }
        if (this.keyText.getText() != null && this.keyText.getText().trim().length() > 0) {
            this.keyText.setFocus();
            this.keyText.setSelection(0, this.keyText.getText().length());
        } else {
            TextTransfer transfer;
            Clipboard clipboard = new Clipboard(Display.getDefault());
            String contents = (String)clipboard.getContents((Transfer)(transfer = TextTransfer.getInstance()));
            if (contents != null && this.isTaskKeyCandidate(contents.trim())) {
                this.keyText.setText(contents.trim());
                this.keyText.setFocus();
                this.keyText.setSelection(0, this.keyText.getText().length());
            }
        }
        this.updatePageEnablement();
    }

    private boolean isTaskKeyCandidate(String contents) {
        boolean looksLikeKey = false;
        try {
            Integer.parseInt(contents);
            looksLikeKey = true;
        }
        catch (NumberFormatException numberFormatException) {}
        if (!looksLikeKey) {
            try {
                Integer.parseInt(contents.substring(contents.lastIndexOf(45)));
                looksLikeKey = true;
            }
            catch (Exception exception) {}
        }
        return looksLikeKey;
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_REPO_ID, this.repositoryCombo.getText());
    }

    public void dispose() {
        if (this.queryPages != null) {
            Control[] controlArray = this.queryPages;
            int n = this.queryPages.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null) {
                    ITaskSearchPage page = (ITaskSearchPage)control.getData(PAGE_KEY);
                    page.dispose();
                }
                ++n2;
            }
        }
        super.dispose();
    }

    private class DeadSearchPage
    extends AbstractRepositoryQueryPage {
        public DeadSearchPage(TaskRepository rep, Status status) {
            super("Search page error", rep);
        }

        public void createControl(Composite parent) {
            Hyperlink hyperlink = new Hyperlink(parent, 0);
            hyperlink.setText(Messages.TaskSearchPage_ERROR_Unable_to_present_query_page);
            hyperlink.setUnderlined(true);
            hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TaskSearchPage.this.getControl().getShell().close();
                    TasksUiUtil.openEditRepositoryWizard((TaskRepository)DeadSearchPage.this.getTaskRepository());
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)hyperlink);
            this.setControl((Control)hyperlink);
        }

        public IRepositoryQuery getQuery() {
            return null;
        }

        public boolean isPageComplete() {
            return false;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.getSearchContainer().setPerformActionEnabled(false);
            }
        }

        public String getQueryTitle() {
            return null;
        }

        public void applyTo(IRepositoryQuery query) {
        }
    }

    private class NoSearchPage
    extends AbstractRepositoryQueryPage {
        public NoSearchPage(TaskRepository rep) {
            super("No search page", rep);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }

        public IRepositoryQuery getQuery() {
            return null;
        }

        public boolean isPageComplete() {
            return false;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.getSearchContainer().setPerformActionEnabled(false);
            }
        }

        public String getQueryTitle() {
            return null;
        }

        public void applyTo(IRepositoryQuery query) {
        }
    }
}

