/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.osgi.util.NLS;

public final class OpControlErrorHandler {
    private static OpControlErrorHandler singleton = new OpControlErrorHandler();
    private String errorFilePath = String.valueOf(OprofileCorePlugin.getDefault().getPluginLocation()) + "op_error_key";
    private Map<String, String> errorMap = new HashMap<String, String>();

    private OpControlErrorHandler() {
    }

    public static OpControlErrorHandler getInstance() {
        return singleton;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpcontrolException handleError(String stdout, String stderr) {
        String fullErr;
        String type;
        block20: {
            type = "";
            fullErr = "";
            IRemoteFileProxy proxy = null;
            if (!stderr.trim().equals("")) {
                fullErr = stderr;
                type = "process.log.stderr";
            } else {
                if (stdout.trim().equals("")) return new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolNonZeroExitCode", null));
                fullErr = stdout;
                type = "process.log.stdout";
            }
            try {
                proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
                IFileStore fileStore = proxy.getResource(this.errorFilePath);
                String line = "";
                Object object = null;
                Object var9_11 = null;
                try {
                    InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                    try {
                        try (BufferedReader buff = new BufferedReader(new InputStreamReader(is));){
                            while ((line = buff.readLine()) != null) {
                                String[] parts = line.split("=");
                                this.errorMap.put(parts[0], parts[1]);
                            }
                        }
                        if (is == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        if (is == null) throw object;
                        is.close();
                        throw object;
                    }
                    is.close();
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                        throw object;
                    }
                    if (object == throwable) throw object;
                    ((Throwable)object).addSuppressed(throwable);
                    throw object;
                }
            }
            catch (IOException | CoreException e) {
                e.printStackTrace();
            }
        }
        String error = null;
        for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
            if (stderr.contains(entry.getKey())) {
                fullErr = stderr;
                type = "process.log.stderr";
                error = entry.getValue();
                break;
            }
            if (!stdout.contains(entry.getKey())) continue;
            fullErr = stdout;
            type = "process.log.stdout";
            error = entry.getValue();
            break;
        }
        OprofileCorePlugin.log(4, NLS.bind((String)OprofileProperties.getString(type), (Object)"opcontrol", (Object)fullErr));
        if (error == null) return new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolNonZeroExitCodeExtraInfo", null));
        return new OpcontrolException(OprofileCorePlugin.createErrorStatus(error, null));
    }
}

