/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.build.gcc.core.internal.Activator;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;

public class GCCPathToolChainProvider
implements IToolChainProvider {
    private static final String ID = "org.eclipse.cdt.build.gcc.core.gccPathProvider";
    private static final Pattern gccPattern = Pattern.compile("(.*-)?(gcc|g\\+\\+|clang|clang\\+\\+)");
    private static final Pattern versionPattern = Pattern.compile(".*(gcc|LLVM) version .*");
    private static final Pattern targetPattern = Pattern.compile("Target: (.*)");

    public String getId() {
        return ID;
    }

    public void init(IToolChainManager manager) {
        HashSet<String> names = new HashSet<String>();
        String path = System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dirStr = stringArray[n2];
            File dir = new File(dirStr);
            if (dir.isDirectory()) {
                String[] stringArray2 = dir.list();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String file = stringArray2[n4];
                    Matcher matcher = gccPattern.matcher(file);
                    if (matcher.matches()) {
                        String prefix = matcher.group(1);
                        String command = String.valueOf(dirStr) + File.separatorChar + file;
                        try {
                            String name;
                            Process proc = new ProcessBuilder(command, "-v").redirectErrorStream(true).start();
                            String version = null;
                            String target = null;
                            Throwable throwable = null;
                            Object var20_22 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                                String line = reader.readLine();
                                while (line != null) {
                                    Matcher versionMatcher = versionPattern.matcher(line);
                                    if (versionMatcher.matches()) {
                                        version = line.trim();
                                    } else {
                                        Matcher targetMatcher = targetPattern.matcher(line);
                                        if (targetMatcher.matches()) {
                                            target = targetMatcher.group(1);
                                        }
                                    }
                                    line = reader.readLine();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            if (target != null && version != null && !names.contains(name = String.valueOf(target) + " - " + version)) {
                                names.add(name);
                                manager.addToolChain((IToolChain)new GCCToolChain(this, target, version, new Path[]{dir.toPath()}, prefix));
                            }
                        }
                        catch (IOException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

