/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.local.showin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.internal.ExternalExecutablesState;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class ExternalExecutablesManager {
    private static boolean gitBashSearchDone = false;

    /*
     * WARNING - void declaration
     */
    public static List<Map<String, String>> load() {
        ArrayList<Map<String, String>> l;
        block32: {
            File f;
            l = new ArrayList<Map<String, String>>();
            IPath stateLocation = UIPlugin.getDefault().getStateLocation();
            if (stateLocation != null && (f = stateLocation.append(".executables/data.properties").toFile()).canRead()) {
                FileReader fileReader;
                InputStreamReader inputStreamReader = null;
                try {
                    try {
                        Properties data = new Properties();
                        fileReader = new FileReader(f);
                        data.load(fileReader);
                        HashMap<Integer, HashMap<String, String>> c = new HashMap<Integer, HashMap<String, String>>();
                        for (String name : data.stringPropertyNames()) {
                            String k;
                            if (name == null || name.indexOf(46) == -1) continue;
                            int ix = name.indexOf(46);
                            String n = name.substring(0, ix);
                            String string = k = ix + 1 < name.length() ? name.substring(ix + 1) : null;
                            if (n == null || k == null) continue;
                            Integer i = null;
                            try {
                                i = Integer.decode(n);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            if (i == null) continue;
                            HashMap<String, String> m = (HashMap<String, String>)c.get(i);
                            if (m == null) {
                                m = new HashMap<String, String>();
                                c.put(i, m);
                            }
                            Assert.isNotNull((Object)m);
                            m.put(k, data.getProperty(name));
                        }
                        ArrayList k = new ArrayList(c.keySet());
                        Collections.sort(k);
                        for (Integer i : k) {
                            Map m = (Map)c.get(i);
                            if (m == null || m.isEmpty()) continue;
                            l.add(m);
                        }
                    }
                    catch (Exception e) {
                        if (Platform.inDebugMode()) {
                            e.printStackTrace();
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!gitBashSearchDone && "win32".equals(Platform.getOS())) {
            HashMap<String, Object> m = null;
            for (HashMap<String, Object> hashMap : l) {
                String name = (String)hashMap.get("Name");
                if (!"Git Bash".equals(name)) continue;
                m = hashMap;
                break;
            }
            if (m == null) {
                void var3_12;
                void var3_10;
                Object var3_8 = null;
                String iconPath = null;
                String path = System.getenv("PATH");
                if (path != null) {
                    StringTokenizer tokenizer = new StringTokenizer(path, ";");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        File f = new File(token, "git.exe");
                        if (!f.canRead()) continue;
                        File f2 = new File(f.getParentFile().getParentFile(), "bin/sh.exe");
                        if (f2.canExecute()) {
                            String string = f2.getAbsolutePath();
                        }
                        iconPath = ExternalExecutablesManager.getGitIconPath(f.getParentFile().getParentFile());
                        break;
                    }
                }
                if (var3_10 == null) {
                    File f = new File("C:/Program Files (x86)/Git/bin/sh.exe");
                    if (!f.exists()) {
                        f = new File("C:/Program Files/Git/bin/sh.exe");
                    }
                    if (f.exists() && f.canExecute()) {
                        String string = f.getAbsolutePath();
                        iconPath = ExternalExecutablesManager.getGitIconPath(f.getParentFile().getParentFile());
                    }
                }
                if (var3_12 != null) {
                    m = new HashMap<String, Object>();
                    m.put("Name", "Git Bash");
                    m.put("Path", var3_12);
                    m.put("Args", "--login -i");
                    if (iconPath != null) {
                        m.put("Icon", iconPath);
                    }
                    m.put("Translate", Boolean.TRUE.toString());
                    l.add(m);
                    ExternalExecutablesManager.save(l);
                }
            }
            gitBashSearchDone = true;
        }
        return l;
    }

    private static String getGitIconPath(File parent) {
        File f = new File(parent, "etc/git.ico");
        if (f.canRead()) {
            return f.getAbsolutePath();
        }
        f = new File(parent, "mingw32/share/git/git-for-windows.ico");
        if (f.canRead()) {
            return f.getAbsolutePath();
        }
        f = new File(parent, "mingw64/share/git/git-for-windows.ico");
        if (f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public static void save(List<Map<String, String>> l) {
        block23: {
            ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
            ExternalExecutablesState stateService = (ExternalExecutablesState)sourceProviderService.getSourceProvider("org.eclipse.tm.terminal.external.executable.configured");
            IPath stateLocation = UIPlugin.getDefault().getStateLocation();
            if (stateLocation != null) {
                File f = stateLocation.append(".executables/data.properties").toFile();
                if (f.isFile() && (l == null || l.isEmpty())) {
                    f.delete();
                    if (stateService != null) {
                        stateService.disable();
                    }
                } else {
                    OutputStreamWriter w = null;
                    try {
                        try {
                            Properties data = new Properties();
                            int i = 0;
                            while (i < l.size()) {
                                Map<String, String> m = l.get(i);
                                for (Map.Entry<String, String> e : m.entrySet()) {
                                    String key = String.valueOf(Integer.toString(i)) + "." + e.getKey();
                                    data.setProperty(key, e.getValue());
                                }
                                ++i;
                            }
                            if (!f.exists()) {
                                f.getParentFile().mkdirs();
                                f.createNewFile();
                            }
                            w = new FileWriter(f);
                            data.store(w, null);
                            if (stateService != null) {
                                stateService.enable();
                            }
                        }
                        catch (Exception e) {
                            if (Platform.inDebugMode()) {
                                e.printStackTrace();
                            }
                            if (w != null) {
                                try {
                                    w.flush();
                                    w.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (w != null) {
                            try {
                                w.flush();
                                w.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (w != null) {
                        try {
                            w.flush();
                            w.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public static ImageData loadImage(String path) {
        Assert.isNotNull((Object)path);
        ImageData id = null;
        ImageData biggest = null;
        ImageLoader loader = new ImageLoader();
        ImageData[] data = loader.load(path);
        if (data != null) {
            ImageData[] imageDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                ImageData d = imageDataArray[n2];
                if (d.height == 16 && d.width == 16) {
                    if (id == null || id.height != 16 && id.width != 16) {
                        id = d;
                    } else if (d.depth < id.depth && d.depth >= 8) {
                        id = d;
                    }
                } else if (id == null) {
                    id = d;
                    biggest = d;
                } else if (id.height != 16 && d.height < id.height && id.width != 16 && d.width < id.width) {
                    id = d;
                } else if (biggest == null || d.height > biggest.height && d.width > biggest.width) {
                    biggest = d;
                }
                ++n2;
            }
        }
        if (id.height > 16 && id.width > 16) {
            id = biggest.scaledTo(16, 16);
        }
        return id;
    }
}

