/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.extensions;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.JAXBControlUIConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.WidgetActionUtils;
import org.eclipse.ptp.internal.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.extensions.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeViewerType;
import org.eclipse.ptp.rm.jaxb.core.data.LaunchTabType;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JAXBImportedScriptLaunchConfigurationTab
extends JAXBDynamicLaunchConfigurationTab {
    private final String rmPrefix;
    private final StringBuffer contents;
    private final AttributeViewerType viewerType;
    private Text choice;
    private Text editor;
    private Button browseWorkspace;
    private Button clear;
    private String selected;

    public JAXBImportedScriptLaunchConfigurationTab(ILaunchController control, LaunchTabType.Import importTab, JAXBControllerLaunchConfigurationTab parentTab) {
        super(control, parentTab);
        this.title = importTab.getTitle();
        this.viewerType = importTab.getExportForOverride();
        this.shared = new String[0];
        this.rmPrefix = String.valueOf(control.getControlId()) + ".";
        this.contents = new StringBuffer();
    }

    @Override
    public RMLaunchValidation canSave(Control control) {
        return super.canSave(control);
    }

    @Override
    public void createControl(final Composite parent, String id) throws CoreException {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)WidgetBuilderUtils.createGridLayout((Integer)1, (Boolean)false));
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)6, (Boolean)false);
        GridData gd = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)false, (Boolean)false, (Integer)600, (Integer)-1, (Integer)6, (Integer)-1);
        gd.verticalAlignment = 0x1000000;
        Group group = WidgetBuilderUtils.createGroup((Composite)this.control, (Integer)0, (Layout)layout, (Object)gd);
        WidgetBuilderUtils.createLabel((Composite)group, (String)Messages.BatchScriptPath, (Integer)16384, (Integer)1);
        WidgetBuilderUtils.createLabel((Composite)group, (String)"", (Integer)16384, (Integer)1);
        gd = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)true, (Boolean)false, (Integer)-1, (Integer)-1, (Integer)2, (Integer)-1);
        gd.verticalAlignment = 0x1000000;
        String s = this.selected == null ? "" : this.selected.toString();
        this.choice = WidgetBuilderUtils.createText((Composite)group, (Integer)2048, (Object)gd, (Boolean)true, (String)s);
        this.browseWorkspace = WidgetBuilderUtils.createPushButton((Composite)group, (String)Messages.JAXBRMConfigurationSelectionWizardPage_1, (SelectionListener)this);
        WidgetBuilderUtils.setButtonDimensionHint((Button)this.browseWorkspace);
        this.clear = WidgetBuilderUtils.createPushButton((Composite)group, (String)Messages.ClearScript, (SelectionListener)this);
        WidgetBuilderUtils.setButtonDimensionHint((Button)this.clear);
        if (this.viewerType != null) {
            try {
                LaunchTabBuilder builder = new LaunchTabBuilder((IJAXBLaunchConfigurationTab)this);
                if (this.listeners != null) {
                    this.listeners.clear();
                }
                this.localWidgets.clear();
                layout = WidgetBuilderUtils.createGridLayout((Integer)1, (Boolean)true);
                gd = WidgetBuilderUtils.createGridData((Integer)768, (Boolean)true, (Boolean)false, (Integer)-1, (Integer)-1, (Integer)2, (Integer)-1);
                gd.verticalAlignment = 0x1000000;
                group = WidgetBuilderUtils.createGroup((Composite)this.control, (Integer)0, (Layout)layout, (Object)gd);
                group.setText(Messages.OverrideEnvironment);
                group.setToolTipText(Messages.OverrideEnvironmentTooltip);
                builder.addAttributeViewer(this.viewerType, (Composite)group);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.CreateControlConfigurableError) + " " + this.title), (Throwable)t);
            }
        }
        layout = WidgetBuilderUtils.createGridLayout((Integer)1, (Boolean)true);
        gd = WidgetBuilderUtils.createGridData((Integer)1808, (Boolean)true, (Boolean)true, (Integer)-1, (Integer)-1, (Integer)1, (Integer)-1);
        group = WidgetBuilderUtils.createGroup((Composite)this.control, (Integer)0, (Layout)layout, (Object)gd);
        int style = 2818;
        this.editor = WidgetBuilderUtils.createText((Composite)group, (Integer)style, (Object)gd, (Boolean)true, (String)"", null, null);
        WidgetBuilderUtils.applyMonospace((Text)this.editor);
        this.editor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.ReadOnlyWarning_title, (String)Messages.ReadOnlyWarning);
            }
        });
        this.createViewScriptGroup(this.control);
        this.control.layout(true, true);
        this.selected = null;
        this.updateControls();
    }

    @Override
    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        try {
            RMLaunchValidation validation = super.initializeFrom(configuration);
            if (!validation.isSuccess()) {
                return validation;
            }
            String value = this.getAttribute("script_path", configuration);
            this.selected = !"".equals(value) ? value : null;
            this.uploadScript();
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage((Shell)this.control.getShell(), (Throwable)t, (String)Messages.ErrorOnLoadFromStore, (String)Messages.ErrorOnLoadTitle, (boolean)false);
        }
        return new RMLaunchValidation(true, null);
    }

    @Override
    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig) {
        return super.isValid(launchConfig);
    }

    @Override
    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        return super.setDefaults(configuration);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        try {
            if (source == this.browseWorkspace) {
                this.selected = WidgetActionUtils.browseWorkspace((Shell)this.control.getShell());
                this.updateContents();
            } else if (source == this.clear) {
                this.selected = null;
                this.updateContents();
            } else {
                super.widgetSelected(e);
            }
        }
        catch (Throwable t) {
            WidgetActionUtils.errorMessage((Shell)this.control.getShell(), (Throwable)t, (String)Messages.WidgetSelectedError, (String)Messages.WidgetSelectedErrorTitle, (boolean)false);
        }
    }

    @Override
    protected void doRefreshLocal() {
        super.doRefreshLocal();
        this.parentTab.getVariableMap().putValue("script_path", (Object)this.selected);
    }

    @Override
    protected Set<String> getLocalInvalid() {
        Set<String> localInvalid = super.getLocalInvalid();
        localInvalid.remove("script_path");
        return localInvalid;
    }

    @Override
    protected void writeLocalProperties() {
        if (this.selected != null && !"".equals(this.selected)) {
            this.validSet.add("script_path");
        }
        super.writeLocalProperties();
    }

    private void createViewScriptGroup(Composite control) {
        GridLayout layout = WidgetBuilderUtils.createGridLayout((Integer)4, (Boolean)true, (Integer)5, (Integer)5, (Integer)2, (Integer)2);
        GridData gd = WidgetBuilderUtils.createGridData((Integer)0, (Integer)4);
        Group grp = WidgetBuilderUtils.createGroup((Composite)control, (Integer)0, (Layout)layout, (Object)gd);
        Button b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.ViewConfig, (SelectionListener)this);
        WidgetBuilderUtils.setButtonDimensionHint((Button)b);
        b.setToolTipText(Messages.ViewConfigTooltip);
        b = WidgetBuilderUtils.createPushButton((Composite)grp, (String)Messages.DefaultValues, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JAXBImportedScriptLaunchConfigurationTab.this.resetDefaults();
            }
        });
        WidgetBuilderUtils.setButtonDimensionHint((Button)b);
    }

    private String getAttribute(String name, ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(String.valueOf(this.rmPrefix) + name, "");
    }

    private void updateContents() throws Throwable {
        this.uploadScript();
        this.fireContentsChanged();
    }

    private void updateControls() {
        if (this.selected != null) {
            this.choice.setText(this.selected);
        } else {
            this.choice.setText("");
        }
        this.editor.setText(this.contents.toString());
        if ("".equals(this.contents)) {
            this.clear.setEnabled(false);
        } else {
            this.clear.setEnabled(true);
        }
    }

    private void uploadScript() throws Throwable {
        this.contents.setLength(0);
        if (this.selected != null) {
            BufferedReader br = new BufferedReader(new FileReader(new File(this.selected)));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.contents.append(line).append(JAXBControlUIConstants.LINE_SEP);
                }
            }
            catch (EOFException eOFException) {}
            br.close();
        }
        this.updateControls();
    }
}

