/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.launching.AbstractOprofileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewSaveDefaultSessionAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OprofileManualLaunchConfigurationDelegate
extends AbstractOprofileLaunchConfigurationDelegate {
    @Override
    protected boolean preExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, ILaunch launch) {
        Oprofile.OprofileProject.setProject((IProject)this.getProject());
        return true;
    }

    @Override
    protected void postExec(LaunchOptions options, OprofileDaemonEvent[] daemonEvents, Process process) {
        LaunchOptions fOptions = options;
        OprofileDaemonEvent[] fDaemonEvents = daemonEvents;
        Display.getDefault().syncExec(() -> {
            try {
                if (!this.oprofileStatus()) {
                    return;
                }
                this.oprofileReset();
                this.oprofileSetupDaemon(fOptions.getOprofileDaemonOptions(), fDaemonEvents);
            }
            catch (OpcontrolException oe) {
                OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)((Object)((Object)oe))));
                return;
            }
            OprofiledControlDialog dlg = new OprofiledControlDialog();
            dlg.setBlockOnOpen(false);
            dlg.open();
            IRunnableWithProgress refreshRunner = monitor -> {
                monitor.beginTask(OprofileLaunchMessages.getString("oprofiledcontroldialog.post.stopdaemon"), 1);
                try {
                    this.oprofileShutdown();
                }
                catch (OpcontrolException opcontrolException) {
                    // empty catch block
                }
                monitor.worked(1);
                monitor.done();
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
            try {
                dialog.run(true, false, refreshRunner);
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    private class OprofiledControlDialog
    extends MessageDialog {
        private Button startDaemonButton;
        private Button stopDaemonButton;
        private Button refreshViewButton;
        private Button resetSessionButton;
        private Button saveSessionButton;
        private List feedbackList;

        public OprofiledControlDialog() {
            super(new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), OprofileLaunchMessages.getString("oprofiledcontroldialog.title"), null, null, 0, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.setShellStyle(96);
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            GridLayout layout = new GridLayout(5, true);
            GridData gd = new GridData();
            area.setLayout((Layout)layout);
            area.setLayoutData((Object)gd);
            this.startDaemonButton = new Button(area, 8);
            this.startDaemonButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.startDaemonButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.startdaemon"));
            this.startDaemonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileStartCollection();
                        OprofiledControlDialog.this.startDaemonButton.setEnabled(false);
                        OprofiledControlDialog.this.stopDaemonButton.setEnabled(true);
                        OprofiledControlDialog.this.refreshViewButton.setEnabled(true);
                        OprofiledControlDialog.this.resetSessionButton.setEnabled(true);
                        OprofiledControlDialog.this.saveSessionButton.setEnabled(true);
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.startdaemon"));
                }
            });
            this.stopDaemonButton = new Button(area, 8);
            this.stopDaemonButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.stopDaemonButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.stopdaemon"));
            this.stopDaemonButton.setEnabled(false);
            this.stopDaemonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileShutdown();
                        OprofiledControlDialog.this.startDaemonButton.setEnabled(true);
                        OprofiledControlDialog.this.stopDaemonButton.setEnabled(false);
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.stopdaemon"));
                }
            });
            this.saveSessionButton = new Button(area, 8);
            this.saveSessionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.saveSessionButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.savesession"));
            this.saveSessionButton.setEnabled(false);
            this.saveSessionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.save"));
                    OprofileViewSaveDefaultSessionAction hack = new OprofileViewSaveDefaultSessionAction();
                    hack.run();
                }
            });
            this.resetSessionButton = new Button(area, 8);
            this.resetSessionButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.resetSessionButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.resetsession"));
            this.resetSessionButton.setEnabled(false);
            this.resetSessionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileReset();
                    }
                    catch (OpcontrolException oe) {
                        OprofiledControlDialog.this.disableAllButtons();
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                    OprofileManualLaunchConfigurationDelegate.this.refreshOprofileView();
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.reset"));
                }
            });
            this.refreshViewButton = new Button(area, 8);
            this.refreshViewButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.refreshViewButton.setText(OprofileLaunchMessages.getString("oprofiledcontroldialog.buttons.refreshview"));
            this.refreshViewButton.setEnabled(false);
            this.refreshViewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.dumpsamples"));
                    try {
                        OprofileManualLaunchConfigurationDelegate.this.oprofileDumpSamples();
                    }
                    catch (OpcontrolException opcontrolException) {
                        // empty catch block
                    }
                    OprofileManualLaunchConfigurationDelegate.this.refreshOprofileView();
                    OprofiledControlDialog.this.addToFeedbackList(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.refreshed"));
                }
            });
            List feedback = new List(area, 2570);
            feedback.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
            feedback.add(OprofileLaunchMessages.getString("oprofiledcontroldialog.feedback.init"));
            this.feedbackList = feedback;
            return area;
        }

        private void disableAllButtons() {
            this.startDaemonButton.setEnabled(false);
            this.stopDaemonButton.setEnabled(false);
            this.refreshViewButton.setEnabled(false);
            this.resetSessionButton.setEnabled(false);
            this.saveSessionButton.setEnabled(false);
        }

        private void addToFeedbackList(String s) {
            this.feedbackList.add(s, 0);
            this.feedbackList.setTopIndex(0);
        }
    }
}

