/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import org.eclipse.ptp.proxy.util.VarInt;
import org.eclipse.ptp.proxy.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolUtil {
    public static final int TYPE_STRING_ATTR = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_BITSET = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_INTEGER_ATTR = 4;
    public static final int TYPE_BOOLEAN_ATTR = 5;
    private static final String EMPTY_STRING = "";
    private static final int PACKET_ARG_LEN_SIZE = 8;

    @Deprecated
    public static BigInteger decodeAddress(String address) {
        int index = 0;
        int radix = 10;
        boolean negative = false;
        if ((address = address.trim()).length() == 0) {
            return BigInteger.ZERO;
        }
        if (address.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (address.startsWith("0x", index) || address.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (address.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (address.startsWith("0", index) && address.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (index > 0) {
            address = address.substring(index);
        }
        if (negative) {
            address = "-" + address;
        }
        try {
            return new BigInteger(address, radix);
        }
        catch (NumberFormatException numberFormatException) {
            return BigInteger.ZERO;
        }
    }

    @Deprecated
    public static byte[] decodeBytes(String str) {
        int len = str.length() / 2;
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(str.charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(str.charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        return strBytes;
    }

    public static String decodeString(ByteBuffer buf, CharsetDecoder decoder) throws IOException {
        String result = EMPTY_STRING;
        VarInt strLen = new VarInt(buf);
        if (!strLen.isValid()) {
            throw new IOException(Messages.getString("ProtocolUtil.0"));
        }
        int len = strLen.getValue();
        if (len > 0) {
            ByteBuffer strBuf = buf.slice();
            try {
                strBuf.limit(len);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            try {
                CharBuffer chars = decoder.decode(strBuf);
                result = chars.toString();
            }
            catch (CharacterCodingException e) {
                throw new IOException(e.getMessage());
            }
            try {
                buf.position(buf.position() + len);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
        }
        return result;
    }

    @Deprecated
    public static String decodeString(CharBuffer buf, int start) {
        int end = start + 8;
        int len = Integer.parseInt(buf.subSequence(start, end).toString(), 16);
        start = end + 1;
        end = start + len;
        return buf.subSequence(start, end).toString();
    }

    public static String decodeStringAttributeType(ByteBuffer buf, CharsetDecoder decoder) throws IOException {
        String value;
        String result = EMPTY_STRING;
        String key = ProtocolUtil.decodeString(buf, decoder);
        if (key.length() > 0) {
            result = key;
        }
        if ((value = ProtocolUtil.decodeString(buf, decoder)).length() > 0) {
            if (result.length() > 0) {
                result = String.valueOf(result) + "=";
            }
            result = String.valueOf(result) + value;
        }
        return result;
    }

    @Deprecated
    public static String encodeIntVal(int val, int len) {
        char[] res = new char[len];
        String str = Integer.toHexString(val);
        int rem = len - str.length();
        int i = 0;
        while (i < len) {
            res[i] = i < rem ? 48 : str.charAt(i - rem);
            ++i;
        }
        return String.valueOf(res);
    }

    @Deprecated
    public static String encodeString(String str) {
        int len;
        if (str == null) {
            len = 0;
            str = EMPTY_STRING;
        } else {
            len = str.length();
        }
        return String.valueOf(ProtocolUtil.encodeIntVal(len, 8)) + ":" + str;
    }

    public static void encodeStringAttributeType(List<ByteBuffer> bufs, String attribute, Charset charset) throws IOException {
        String[] kv = attribute.split("=", 2);
        bufs.add(ProtocolUtil.encodeType(0));
        if (kv.length == 1) {
            bufs.add(new VarInt(0).getBytes());
            ProtocolUtil.encodeString(bufs, kv[0], charset);
        } else {
            ProtocolUtil.encodeString(bufs, kv[0], charset);
            ProtocolUtil.encodeString(bufs, kv[1], charset);
        }
    }

    public static void encodeStringType(List<ByteBuffer> bufs, String str, Charset charset) {
        bufs.add(ProtocolUtil.encodeType(3));
        ProtocolUtil.encodeString(bufs, str, charset);
    }

    private static void encodeString(List<ByteBuffer> bufs, String str, Charset charset) {
        bufs.add(new VarInt(str.length()).getBytes());
        try {
            bufs.add(ByteBuffer.wrap(str.getBytes(charset.name())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufs.add(ByteBuffer.wrap(str.getBytes()));
        }
    }

    private static ByteBuffer encodeType(int type) {
        ByteBuffer b = ByteBuffer.allocate(1).put((byte)type);
        b.rewind();
        return b;
    }
}

