/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.hover;

import com.ibm.icu.text.BreakIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.GC;

public class LineBreakingReader {
    private final BufferedReader fReader;
    private final GC fGC;
    private final int fMaxWidth;
    private String fLine;
    private int fOffset;
    private int fLineLen;
    private final BreakIterator fLineBreakIterator;

    public LineBreakingReader(Reader reader, GC gc, int maxLineWidth) {
        this.fReader = new BufferedReader(reader);
        this.fGC = gc;
        this.fMaxWidth = maxLineWidth;
        this.fOffset = 0;
        this.fLine = null;
        this.fLineBreakIterator = BreakIterator.getLineInstance();
    }

    public boolean isFormattedLine() {
        return this.fLine != null;
    }

    public String readLine(String indent) throws IOException {
        String res;
        int breakOffset;
        if (this.fLine == null) {
            String line = this.fReader.readLine();
            if (line == null) {
                return null;
            }
            int lineLen = this.fGC.textExtent((String)line).x;
            if (this.fMaxWidth > -1 && lineLen < this.fMaxWidth) {
                return line;
            }
            this.fLine = line;
            this.fLineBreakIterator.setText(line);
            this.fOffset = 0;
        }
        if ((breakOffset = this.findNextBreakOffset(this.fOffset, indent)) != -1) {
            res = this.fLine.substring(this.fOffset, breakOffset);
            this.fOffset = this.findWordBegin(breakOffset);
            if (this.fOffset == this.fLine.length()) {
                this.fLine = null;
            }
            if (breakOffset == 1 && res.charAt(0) == '\t') {
                return "\t" + this.readLine(indent);
            }
        } else {
            res = this.fLine.substring(this.fOffset);
            this.fLine = null;
        }
        return res;
    }

    public String readLine() throws IOException {
        int endLen;
        if (this.fLine == null) {
            String line = this.fReader.readLine();
            if (line == null) {
                return null;
            }
            this.fLineLen = line.length();
            if (this.fMaxWidth == -1 || this.fLineLen < this.fMaxWidth) {
                return line;
            }
            this.fLine = line;
            this.fOffset = 0;
        }
        if ((endLen = this.fOffset + this.fMaxWidth) > this.fLineLen) {
            endLen = this.fLineLen;
        }
        String res = this.fLine.substring(this.fOffset, endLen);
        this.fOffset = endLen;
        if (this.fOffset >= this.fLineLen) {
            this.fLine = null;
            this.fLineLen = 0;
        }
        if (res.charAt(0) == '\t') {
            return "\t" + res;
        }
        return res;
    }

    private int findNextBreakOffset(int currOffset, String indent) {
        int currWidth = indent != null ? this.fGC.textExtent((String)indent).x : 0;
        int nextOffset = this.fLineBreakIterator.following(currOffset);
        while (nextOffset != -1) {
            String word = this.fLine.substring(currOffset, nextOffset);
            int wordWidth = this.fGC.textExtent((String)word).x;
            int nextWidth = wordWidth + currWidth;
            if (this.fMaxWidth > -1 && nextWidth > this.fMaxWidth) {
                if (currWidth > 0) {
                    return currOffset;
                }
                return nextOffset;
            }
            currWidth = nextWidth;
            currOffset = nextOffset;
            nextOffset = this.fLineBreakIterator.next();
        }
        return nextOffset;
    }

    private int findWordBegin(int idx) {
        while (idx < this.fLine.length() && Character.isWhitespace(this.fLine.charAt(idx))) {
            ++idx;
        }
        return idx;
    }
}

