/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobGroup;

public abstract class Job
extends InternalJob
implements IAdaptable {
    public static final IStatus ASYNC_FINISH = new Status(0, "org.eclipse.core.jobs", 1, "", null);
    public static final int INTERACTIVE = 10;
    public static final int SHORT = 20;
    public static final int LONG = 30;
    public static final int BUILD = 40;
    public static final int DECORATE = 50;
    public static final int NONE = 0;
    public static final int SLEEPING = 1;
    public static final int WAITING = 2;
    public static final int RUNNING = 4;

    public static final IJobManager getJobManager() {
        return manager;
    }

    public static Job create(String name, final IJobFunction function) {
        return new Job(name){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = function.run(monitor);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    public static Job create(String name, final ICoreRunnable runnable) {
        return new Job(name){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        runnable.run(monitor);
                    }
                    catch (CoreException e) {
                        IStatus st = e.getStatus();
                        Status status = new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
    }

    public static Job createSystem(String name, ICoreRunnable runnable) {
        Job job = Job.create(name, runnable);
        job.setSystem(true);
        return job;
    }

    public static Job createSystem(ICoreRunnable runnable) {
        return Job.createSystem("", runnable);
    }

    public Job(String name) {
        super(name);
    }

    @Override
    public final void addJobChangeListener(IJobChangeListener listener) {
        super.addJobChangeListener(listener);
    }

    @Override
    public boolean belongsTo(Object family) {
        return false;
    }

    @Override
    public final boolean cancel() {
        return super.cancel();
    }

    @Override
    protected void canceling() {
    }

    @Override
    public final void done(IStatus result) {
        super.done(result);
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    @Override
    public final int getPriority() {
        return super.getPriority();
    }

    @Override
    public final Object getProperty(QualifiedName key) {
        return super.getProperty(key);
    }

    @Override
    public final IStatus getResult() {
        return super.getResult();
    }

    @Override
    public final ISchedulingRule getRule() {
        return super.getRule();
    }

    @Override
    public final int getState() {
        return super.getState();
    }

    @Override
    public final Thread getThread() {
        return super.getThread();
    }

    @Override
    public final JobGroup getJobGroup() {
        return super.getJobGroup();
    }

    @Override
    public final boolean isBlocking() {
        return super.isBlocking();
    }

    @Override
    public final boolean isSystem() {
        return super.isSystem();
    }

    @Override
    public final boolean isUser() {
        return super.isUser();
    }

    @Override
    public final void join() throws InterruptedException {
        super.join();
    }

    @Override
    public final boolean join(long timeoutMillis, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        return super.join(timeoutMillis, monitor);
    }

    @Override
    public final void removeJobChangeListener(IJobChangeListener listener) {
        super.removeJobChangeListener(listener);
    }

    @Override
    protected abstract IStatus run(IProgressMonitor var1);

    public final void schedule() {
        super.schedule(0L);
    }

    @Override
    public final void schedule(long delay) {
        super.schedule(delay);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
    }

    @Override
    public final void setPriority(int priority) {
        super.setPriority(priority);
    }

    @Override
    public final void setProgressGroup(IProgressMonitor group, int ticks) {
        super.setProgressGroup(group, ticks);
    }

    @Override
    public void setProperty(QualifiedName key, Object value) {
        super.setProperty(key, value);
    }

    @Override
    public final void setRule(ISchedulingRule rule) {
        super.setRule(rule);
    }

    @Override
    public final void setSystem(boolean value) {
        super.setSystem(value);
    }

    @Override
    public final void setUser(boolean value) {
        super.setUser(value);
    }

    @Override
    public final void setThread(Thread thread) {
        super.setThread(thread);
    }

    @Override
    public final void setJobGroup(JobGroup jobGroup) {
        super.setJobGroup(jobGroup);
    }

    public boolean shouldRun() {
        return true;
    }

    @Override
    public boolean shouldSchedule() {
        return true;
    }

    @Override
    public final boolean sleep() {
        return super.sleep();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public final void wakeUp() {
        super.wakeUp(0L);
    }

    @Override
    public final void wakeUp(long delay) {
        super.wakeUp(delay);
    }

    @Override
    public Job yieldRule(IProgressMonitor monitor) {
        return super.yieldRule(monitor);
    }
}

