/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.internal.debug.core.PDebugModel;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.launch.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    @Override
    protected void doCleanupLaunch(IPLaunch launch) {
        if (launch.getLaunchMode().equals("debug")) {
            try {
                this.terminateDebugSession(launch.getJobId());
                IPDebugConfiguration debugConfig = this.getDebugConfig(launch.getLaunchConfiguration());
                IPDebugger debugger = debugConfig.getDebugger();
                debugger.cleanup(launch);
            }
            catch (CoreException e) {
                PTPLaunchPlugin.log(e);
            }
        }
    }

    @Override
    protected void doCompleteJobLaunch(final IPLaunch launch, IPDebugger debugger) {
        String jobId = launch.getJobId();
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        new RuntimeProcess(launch, null);
        if (launch.getLaunchMode().equals("debug")) {
            try {
                this.setDefaultSourceLocator((ILaunch)launch, configuration);
                IProject project = this.verifyProject(configuration);
                final DebuggerSession session = new DebuggerSession(jobId, launch, project, debugger);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new ProgressMonitorDialog(PTPLaunchPlugin.getActiveWorkbenchShell()).run(true, true, (IRunnableWithProgress)session);
                        }
                        catch (InterruptedException interruptedException) {
                            ParallelLaunchConfigurationDelegate.this.terminateJob(launch);
                        }
                        catch (InvocationTargetException e) {
                            PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_0, e.getTargetException());
                            PTPLaunchPlugin.log(e.getCause());
                            ParallelLaunchConfigurationDelegate.this.terminateJob(launch);
                        }
                    }
                });
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_1, e.getStatus());
                        PTPLaunchPlugin.log(e);
                        ParallelLaunchConfigurationDelegate.this.terminateJob(launch);
                    }
                });
            }
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block10: {
            if (!(launch instanceof IPLaunch)) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.ParallelLaunchConfigurationDelegate_Invalid_launch_object));
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
            progress.setTaskName(NLS.bind((String)Messages.ParallelLaunchConfigurationDelegate_3, (Object)configuration.getName()));
            progress.setWorkRemaining(90);
            if (progress.isCanceled()) {
                return;
            }
            progress.worked(10);
            progress.subTask(Messages.ParallelLaunchConfigurationDelegate_4);
            if (!this.verifyLaunchAttributes(configuration, mode, (IProgressMonitor)progress.newChild(10)) || progress.isCanceled()) {
                return;
            }
            this.copyExecutable(configuration, (IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled()) {
                return;
            }
            this.doPreLaunchSynchronization(configuration, (IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled()) {
                return;
            }
            IPDebugger debugger = null;
            try {
                if (mode.equals("debug")) {
                    progress.subTask(Messages.ParallelLaunchConfigurationDelegate_6);
                    IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                    debugger = debugConfig.getDebugger();
                    debugger.initialize(configuration, (IProgressMonitor)progress.newChild(10));
                    if (progress.isCanceled()) {
                        return;
                    }
                }
                progress.worked(10);
                progress.subTask(Messages.ParallelLaunchConfigurationDelegate_7);
                this.submitJob(mode, (IPLaunch)launch, debugger, (IProgressMonitor)progress.newChild(40));
                progress.worked(10);
            }
            catch (CoreException e) {
                if (debugger != null) {
                    debugger.cleanup((IPLaunch)launch);
                }
                if (e.getStatus().getCode() == 8) break block10;
                throw e;
            }
        }
    }

    protected void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }

    private void terminateDebugSession(String jobId) throws CoreException {
        PDebugModel model = PTPDebugCorePlugin.getDebugModel();
        IPSession session = model.getSession(jobId);
        if (session != null) {
            TaskSet tasks = model.getTasks(session, "Root");
            try {
                session.getPDISession().terminate(tasks);
            }
            catch (PDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    private void terminateJob(IPLaunch launch) {
        try {
            launch.getJobControl().control(launch.getJobId(), "TERMINATE", null);
        }
        catch (CoreException e1) {
            PTPLaunchPlugin.log(e1);
        }
    }

    private class DebuggerSession
    implements IRunnableWithProgress {
        private final String fJobId;
        private final IPLaunch fLaunch;
        private final IProject fProject;
        private final IPDebugger fDebugger;

        public DebuggerSession(String jobId, IPLaunch launch, IProject project, IPDebugger debugger) {
            this.fJobId = jobId;
            this.fLaunch = launch;
            this.fProject = project;
            this.fDebugger = debugger;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.ParallelLaunchConfigurationDelegate_5, 10);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    IPSession session = PTPDebugCorePlugin.getDebugModel().createDebugSession(this.fDebugger, this.fLaunch, this.fProject, (IProgressMonitor)subMon.newChild(2));
                    String app = LaunchUtils.getProgramName((ILaunchConfiguration)this.fLaunch.getLaunchConfiguration());
                    String path = LaunchUtils.getProgramPath((ILaunchConfiguration)this.fLaunch.getLaunchConfiguration());
                    String cwd = LaunchUtils.getWorkingDirectory((ILaunchConfiguration)this.fLaunch.getLaunchConfiguration());
                    String[] args = LaunchUtils.getProgramArguments((ILaunchConfiguration)this.fLaunch.getLaunchConfiguration());
                    ParallelLaunchConfigurationDelegate.this.switchPerspective(IPTPDebugUIConstants.ID_PERSPECTIVE_DEBUG, Messages.ParallelLaunchConfigurationDelegate_OpenDebugPerspective, "org.eclipse.ptp.launch.switch_to_debug_perspective", false);
                    session.connectToDebugger((IProgressMonitor)subMon.newChild(8), app, path, cwd, args);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(this.fJobId);
                    throw new InvocationTargetException(e, e.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

