/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.debug.model.DsfLaunch;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.gdb.launching.ITracedLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.launching.ShutdownSequence;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;

@ThreadSafe
public class GdbLaunch
extends DsfLaunch
implements ITerminate,
IDisconnect,
ITracedLaunch,
ITargetedLaunch {
    private DefaultDsfExecutor fExecutor;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private boolean fInitialized = false;
    private boolean fShutDown = false;
    private IMemoryBlockRetrievalManager fMemRetrievalManager;
    private IDsfDebugServicesFactory fServiceFactory;
    private ILaunchTarget fLaunchTarget;

    public GdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor("org.eclipse.cdt.dsf.gdb");
        dsfExecutor.prestartCoreThread();
        this.fExecutor = dsfExecutor;
        this.fSession = DsfSession.startSession((DsfExecutor)this.fExecutor, (String)"org.eclipse.cdt.dsf.gdb");
    }

    public DsfExecutor getDsfExecutor() {
        return this.fExecutor;
    }

    public IDsfDebugServicesFactory getServiceFactory() {
        return this.fServiceFactory;
    }

    public void initialize() throws DebugException {
        this.fSession.registerModelAdapter(ILaunch.class, (Object)this);
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                GdbLaunch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), GdbLaunch.this.fSession.getId());
                GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this, null);
                GdbLaunch.this.fInitialized = true;
                GdbLaunch.this.fireChanged();
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    public void initializeControl() throws CoreException {
        try {
            this.fExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    GdbLaunch.this.fMemRetrievalManager = (IMemoryBlockRetrievalManager)new GdbMemoryBlockRetrievalManager("org.eclipse.cdt.dsf.gdb", GdbLaunch.this.getLaunchConfiguration(), GdbLaunch.this.fSession);
                    GdbLaunch.this.fSession.registerModelAdapter(IMemoryBlockRetrievalManager.class, (Object)GdbLaunch.this.fMemRetrievalManager);
                    GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this.fMemRetrievalManager, null);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getDsfExecutor()")
    public void addCLIProcess(String label) throws CoreException {
        try {
            AbstractCLIProcess cliProc = (AbstractCLIProcess)this.getDsfExecutor().submit((Callable)new Callable<AbstractCLIProcess>(){

                @Override
                public AbstractCLIProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getCLIProcess();
                    }
                    return null;
                }
            }).get();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
            DebugPlugin.newProcess((ILaunch)this, (Process)cliProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public void setServiceFactory(IDsfDebugServicesFactory factory) {
        this.fServiceFactory = factory;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
    }

    public boolean canTerminate() {
        return this.fInitialized && super.canTerminate();
    }

    public void terminate() throws DebugException {
        ITerminateHandler handler = this.getAdapter(ITerminateHandler.class);
        if (handler == null) {
            super.terminate();
            return;
        }
        LaunchCommandRequest req = new LaunchCommandRequest(new Object[]{this});
        handler.execute((IDebugCommandRequest)req);
    }

    public boolean canDisconnect() {
        return this.canTerminate();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public void disconnect() throws DebugException {
        IDisconnectHandler handler = this.getAdapter(IDisconnectHandler.class);
        if (handler == null) {
            super.disconnect();
            return;
        }
        LaunchCommandRequest req = new LaunchCommandRequest(new Object[]{this});
        handler.execute((IDebugCommandRequest)req);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.fShutDown) {
            rm.done();
            return;
        }
        this.fShutDown = true;
        final ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.fSession.getId(), new RequestMonitor((Executor)this.fSession.getExecutor(), rm){

            public void handleCompleted() {
                if (GdbLaunch.this.fMemRetrievalManager != null) {
                    GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this.fMemRetrievalManager);
                    GdbLaunch.this.fMemRetrievalManager.dispose();
                }
                GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this);
                if (!this.isSuccess()) {
                    GdbPlugin.getDefault().getLog().log((IStatus)new MultiStatus("org.eclipse.cdt.dsf.gdb", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                if (GdbLaunch.this.fTracker != null) {
                    GdbLaunch.this.fTracker.dispose();
                    GdbLaunch.this.fTracker = null;
                }
                DsfSession.endSession((DsfSession)GdbLaunch.this.fSession);
                if (GdbLaunch.this.isTerminated()) {
                    GdbLaunch.this.fireTerminate();
                }
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

            public void execute(RequestMonitor rm) {
                IGDBControl control;
                if (GdbLaunch.this.fTracker != null && (control = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class)) != null) {
                    control.terminate(rm);
                    return;
                }
                rm.done();
            }
        }, new Sequence.Step(){

            public void execute(RequestMonitor rm) {
                GdbLaunch.this.fExecutor.execute((Runnable)shutdownSeq);
            }
        }};
        this.fExecutor.execute((Runnable)new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (!adapter.equals(ITerminateHandler.class)) {
            Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return (T)super.getAdapter(adapter);
    }

    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch)) {
            if (DsfSession.isSessionActive((String)this.fSession.getId())) {
                DsfSession.endSession((DsfSession)this.fSession);
            }
            this.fExecutor.shutdown();
            this.fExecutor = null;
        }
        super.launchRemoved(launch);
    }

    protected String getDefaultGDBPath() {
        return Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
    }

    public IPath getGDBPath() {
        try {
            String gdb = this.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME");
            if (gdb == null) {
                gdb = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.getDefaultGDBPath());
            }
            if (gdb != null) {
                gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
                return new Path(gdb);
            }
            return null;
        }
        catch (CoreException e) {
            GdbPlugin.log(e.getStatus());
            return null;
        }
    }

    public void setGDBPath(String path) {
        this.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", path);
    }

    public String getGDBVersion() throws CoreException {
        String cmd = String.valueOf(this.getGDBPath().toOSString()) + " --version";
        String[] args = CommandLineUtil.argumentsToArray((String)cmd);
        Process process = null;
        Job timeoutJob = null;
        try {
            final Process finalProc = process = ProcessFactory.getFactory().exec(args, this.getLaunchEnvironment());
            timeoutJob = new Job("GDB version timeout job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor arg) {
                    finalProc.destroy();
                    return Status.OK_STATUS;
                }
            };
            timeoutJob.schedule(10000L);
            String streamOutput = GdbLaunch.readStream(process.getInputStream());
            String gdbVersion = LaunchUtils.getGDBVersionFromText(streamOutput);
            if (gdbVersion == null || gdbVersion.isEmpty()) {
                Exception detailedException = null;
                if (!streamOutput.isEmpty()) {
                    detailedException = new Exception("Unexpected output format: \n\n" + streamOutput);
                } else {
                    streamOutput = GdbLaunch.readStream(process.getErrorStream());
                    if (!streamOutput.isEmpty()) {
                        detailedException = new Exception(streamOutput);
                    }
                }
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Could not determine GDB version using command: " + StringUtil.join((String[])args, (String)" "), (Throwable)detailedException));
            }
            String string = gdbVersion;
            return string;
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error with command: " + StringUtil.join((String[])args, (String)" "), (Throwable)e));
        }
        finally {
            if (timeoutJob != null) {
                timeoutJob.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static String readStream(InputStream stream) throws IOException {
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            String line;
            InputStreamReader r = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                cmdOutput.append(line);
                cmdOutput.append('\n');
            }
            String string = cmdOutput.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getLaunchEnvironment() throws CoreException {
        String projectName = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        IProject project = null;
        if (projectName == null) {
            IResource[] resources = this.getLaunchConfiguration().getMappedResources();
            if (resources != null && resources.length > 0 && resources[0] instanceof IProject) {
                project = (IProject)resources[0];
            }
        } else {
            if ((projectName = projectName.trim()).length() == 0) {
                return null;
            }
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || !project.isAccessible()) {
            return null;
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (projDesc != null) {
            ICdtVariable[] buildVars;
            IEnvironmentVariable[] vars;
            String buildConfigID = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            ICConfigurationDescription cfg = null;
            if (buildConfigID.length() != 0) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
            ICdtVariable[] iCdtVariableArray = buildVars = CCorePlugin.getDefault().getCdtVariableManager().getVariables(cfg);
            int n3 = buildVars.length;
            n = 0;
            while (n < n3) {
                ICdtVariable var = iCdtVariableArray[n];
                try {
                    if (!"project_classpath".equals(var.getName())) {
                        envMap.put(var.getName(), var.getStringValue());
                    }
                }
                catch (CdtVariableException cdtVariableException) {
                    // empty catch block
                }
                ++n;
            }
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public String getGDBInitFile() throws CoreException {
        String defaultGdbInit = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbInit", ".gdbinit", null);
        return this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", defaultGdbInit);
    }

    public IPath getGDBWorkingDirectory() throws CoreException {
        ICProject cp;
        String expandedLocation;
        Object path = null;
        String location = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && !(expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).isEmpty()) {
            path = new Path(expandedLocation);
        }
        if (path != null) {
            if (path.isAbsolute()) {
                File dir = new File(path.toPortableString());
                if (!dir.isDirectory()) {
                    path = null;
                }
            } else {
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                path = res instanceof IContainer && res.exists() ? res.getLocation() : null;
            }
        }
        if (path == null && (cp = LaunchUtils.getCProject(this.getLaunchConfiguration())) != null) {
            IProject p = cp.getProject();
            path = p.getLocation();
        }
        return path;
    }

    public String getProgramArguments() throws CoreException {
        String programArguments = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (programArguments != null) {
            programArguments = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programArguments);
        }
        return programArguments;
    }

    public String getProgramPath() throws CoreException {
        String programPath = this.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME");
        if (programPath == null) {
            programPath = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        }
        return programPath;
    }

    public void setProgramPath(String programPath) throws CoreException {
        this.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
    }

    public List<String> getSharedLibraryPaths() throws CoreException {
        return this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", new ArrayList(0));
    }

    public Properties getEnvironmentVariables() throws CoreException {
        String[] properties;
        Properties envVariables = new Properties();
        boolean append = this.getLaunchConfiguration().getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        if (append) {
            ILaunchConfigurationWorkingCopy wc = this.getLaunchConfiguration().copy("");
            wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
            properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment((ILaunchConfiguration)wc);
        } else {
            properties = DebugPlugin.getDefault().getLaunchManager().getEnvironment(this.getLaunchConfiguration());
        }
        if (properties == null) {
            properties = new String[]{};
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            int idx = property.indexOf(61);
            if (idx != -1) {
                String key = property.substring(0, idx);
                String value = property.substring(idx + 1);
                envVariables.setProperty(key, value);
            } else {
                envVariables.setProperty(property, "");
            }
            ++n2;
        }
        return envVariables;
    }

    public boolean getClearEnvironment() throws CoreException {
        return !this.getLaunchConfiguration().getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
    }

    public boolean getUpdateThreadListOnSuspend() throws CoreException {
        return this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }

    public void setLaunchTarget(ILaunchTarget launchTarget) {
        this.fLaunchTarget = launchTarget;
    }

    public ILaunchTarget getLaunchTarget() {
        return this.fLaunchTarget;
    }

    static class LaunchCommandRequest
    extends CRequest
    implements IDebugCommandRequest {
        private Object[] elements;

        public LaunchCommandRequest(Object[] objects) {
            this.elements = objects;
        }

        public Object[] getElements() {
            return this.elements;
        }

        public void done() {
            IStatus status = this.getStatus();
            if (status != null && !status.isOK()) {
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
                if (statusHandler != null) {
                    try {
                        statusHandler.handleStatus(status, null);
                    }
                    catch (CoreException ex) {
                        GdbPlugin.getDefault().getLog().log(ex.getStatus());
                    }
                } else {
                    GdbPlugin.getDefault().getLog().log(status);
                }
            }
        }
    }
}

