/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ListBlock
extends Block {
    private static final String ANY_CHAR = "\\s(.*+)";
    private static final Pattern startPattern = Pattern.compile("((?:(?:\\*)|(?:\\.))+)\\s(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            boolean matchBlockStart = this.matcher.matches();
            return matchBlockStart;
        }
        this.matcher = null;
        return false;
    }

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            String listSpec = this.matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            offset = level;
            this.listState.push(new ListState(1, type));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(this.matcher, level, type);
        } else {
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
            String listSpec = matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            offset = level;
            this.adjustLevel(matcher, level, type);
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (listState.openItem) {
            this.builder.endBlock();
        }
        listState.openItem = true;
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length();
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        switch (listSpec.charAt(listSpec.length() - 1)) {
            case '.': {
                return DocumentBuilder.BlockType.NUMERIC_LIST;
            }
        }
        return DocumentBuilder.BlockType.BULLETED_LIST;
    }

    private void adjustLevel(Matcher matcher, int level, DocumentBuilder.BlockType type) {
        ListState prevState = this.listState.peek();
        while (level != prevState.level || prevState.type != type) {
            Attributes blockAttributes;
            if (level > prevState.level) {
                if (!prevState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    prevState.openItem = true;
                }
                blockAttributes = new Attributes();
                this.listState.push(new ListState(prevState.level + 1, type));
                this.builder.beginBlock(type, blockAttributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    this.listState.push(new ListState(1, type));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            prevState = this.listState.peek();
        }
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type) {
            this.level = level;
            this.type = type;
        }
    }
}

