/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;

public class PerlMakefileParser {
    private static final String WHITE_SPACE = "(?:\\s+)";
    private static final String COMMENT = "#.+";
    private static final String LINE_WITH_COMMENT = "(?:(.*)#.+)";
    private static final String VARIABLE_PARAMS = "(?:my|local|our)";
    private static final String WORD = "(\\b\\w+\\b)";
    private static final String NON_WHITE_SPACE = "(\\S+)";
    private static final String VARIABLE = "(?:(?:my|local|our)(?:\\s+))?(?:\\$|@|%)(\\b\\w+\\b)(?:\\s+)?";
    private static final String ASSOCIATIVE_KEY = "(?:\\s+)?(\\S+)(?:\\s+)?";
    private static final String EXCLUDE_SPECIALS = "(?![=~|\\-\\*\\+\\/])";
    private static final String NON_CONDITIONAL = "(?!(?:\\s*if|elsif|unless))";
    private static final String ASSIGNMENT_OPERATOR = "=";
    private static final String ASSOCIATIVE_OPERATOR = "=>";
    private static final String SIMPLE_ASSIGNMENT = "(?!(?:\\s*if|elsif|unless))(?:\\s+)?(?:(?:my|local|our)(?:\\s+))?(?:\\$|@|%)(\\b\\w+\\b)(?:\\s+)?(?:=)(?![=~|\\-\\*\\+\\/])(?:(.+))";
    private static final String ASSOCIATIVE_ASSIGNMENT = "(?:\\s+)?(\\S+)(?:\\s+)?=>(?:(.+))";
    private static final String FUNCTION = "\\s*(\\b\\w+\\b)*\\s*?\\((.*)\\)\\s*";
    private static final String BEGIN_END = "(?:[^#]*<<END)";
    private static final String END_END = "^END$";
    private static final String BEGIN_BC = "^=(?!cut)[a-z]\\S+(\\s)?\\S+";
    private static final String END_BC = "^=cut$";
    private static final String MAKEFILE_FUNCTION_NAME = "WriteMakefile";
    private static final String MAKEFILE_FUNCTION = "^.*WriteMakefile(?:\\s+)?\\(.*$";
    private static final Map<Character, Character> SURROUNDING_CHARACTER;
    private static final char SQUARE_BRACKET = '[';
    private static final char CURLY_BRACKET = '{';
    private static final char ROUND_BRACKET = '(';
    private static final int IN_BRACKETS = 1;
    private static final int MAKE_FUNCTION = 2;
    private IFile file;
    private Map<String, String> mVariableDefinitions = new HashMap<String, String>();
    private Map<String, String> mMakefileDefinitions = new HashMap<String, String>();

    static {
        HashMap<Character, Character> aMap = new HashMap<Character, Character>();
        aMap.put(Character.valueOf('['), Character.valueOf(']'));
        aMap.put(Character.valueOf('{'), Character.valueOf('}'));
        aMap.put(Character.valueOf('('), Character.valueOf(')'));
        aMap.put(Character.valueOf(']'), Character.valueOf('['));
        aMap.put(Character.valueOf('}'), Character.valueOf('{'));
        aMap.put(Character.valueOf(')'), Character.valueOf('('));
        SURROUNDING_CHARACTER = Collections.unmodifiableMap(aMap);
    }

    public PerlMakefileParser(IFile file) throws IOException, CoreException {
        if (file.getContents().available() <= 0) {
            return;
        }
        this.file = file;
        this.parse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() {
        String content = "";
        String line = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Scanner variableScanner = new Scanner(this.file.getContents());
                try {
                    this.grabSimpleDefinitions(PerlMakefileParser.cleanUpContent(variableScanner));
                    PerlMakefileParser.cleanupVariables(this.mVariableDefinitions);
                    this.resolveVariables(this.mVariableDefinitions);
                    if (!this.mVariableDefinitions.containsKey(MAKEFILE_FUNCTION_NAME)) {
                        return;
                    }
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (Scanner makefileScanner = new Scanner(this.mVariableDefinitions.get(MAKEFILE_FUNCTION_NAME));){
                        makefileScanner.useDelimiter("(?<=,)");
                        ArrayList<String> makefileList = new ArrayList<String>();
                        while (makefileScanner.hasNext()) {
                            line = makefileScanner.next();
                            if (PerlMakefileParser.matchesAssociativeAssignment(line)) {
                                makefileList.add(line);
                                continue;
                            }
                            if (makefileList.isEmpty()) continue;
                            makefileList.set(makefileList.size() - 1, ((String)makefileList.get(makefileList.size() - 1)).concat(line));
                        }
                        for (String str : makefileList) {
                            content = content.concat(String.valueOf(str) + '\n');
                        }
                        this.grabAssociativeDefinitions(content);
                        PerlMakefileParser.cleanupVariables(this.mMakefileDefinitions);
                        this.resolveVariables(this.mMakefileDefinitions);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    variableScanner.close();
                    return;
                }
                finally {
                    if (variableScanner == null) return;
                    variableScanner.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
    }

    public String getValue(String key) {
        String rc = "";
        if (this.mMakefileDefinitions.containsKey(key)) {
            rc = this.mMakefileDefinitions.get(key);
        }
        return rc;
    }

    public List<String> getValueList(String key) {
        ArrayList<String> rc = new ArrayList<String>();
        String var = "";
        if (this.mMakefileDefinitions.containsKey(key)) {
            String[] tmp;
            var = this.mMakefileDefinitions.get(key);
            String[] stringArray = tmp = var.split(",");
            int n = tmp.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                str = PerlMakefileParser.cleanUpString(str);
                rc.add(str);
                ++n2;
            }
        }
        return rc;
    }

    private void grabSimpleDefinitions(String content) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(content);){
            Stack<Character> brackets = new Stack<Character>();
            String key = "";
            String value = "";
            String tempVar = "";
            String line = "";
            int flags = 0;
            while (scanner.hasNext()) {
                String[] tmp;
                line = scanner.nextLine();
                if (PerlMakefileParser.matchesSimpleAssignment(line)) {
                    tmp = line.split(ASSIGNMENT_OPERATOR);
                    key = PerlMakefileParser.removeVariableSigils(tmp[0]).toLowerCase().replaceAll("\\W", "");
                    value = tmp[1];
                    if (PerlMakefileParser.containsOpener(value)) {
                        flags |= 1;
                    } else {
                        this.mVariableDefinitions.put(key, value);
                    }
                } else if (PerlMakefileParser.containsMakefileFunction(line)) {
                    flags |= 2;
                    flags |= 1;
                }
                if ((flags & 1) != 1) continue;
                PerlMakefileParser.checkBrackets(brackets, line);
                tempVar = tempVar.concat(line.trim());
                if (!brackets.isEmpty()) continue;
                if ((flags & 2) == 2) {
                    this.mVariableDefinitions.putAll(PerlMakefileParser.extractFunction(tempVar));
                } else {
                    tmp = tempVar.split("=[^>]");
                    key = PerlMakefileParser.removeVariableSigils(tmp[0]).toLowerCase().replaceAll("\\W", "");
                    value = tmp[1];
                    this.mVariableDefinitions.put(key, value);
                }
                tempVar = "";
                flags &= 0;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void grabAssociativeDefinitions(String content) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(content);){
            Stack<Character> brackets = new Stack<Character>();
            String key = "";
            String value = "";
            String tempVar = "";
            String line = "";
            boolean flags = false;
            while (scanner.hasNext()) {
                line = scanner.nextLine();
                if (PerlMakefileParser.matchesAssociativeAssignment(line) && !(flags & true)) {
                    String[] tmp = line.split(ASSOCIATIVE_OPERATOR);
                    key = PerlMakefileParser.removeVariableSigils(tmp[0].toLowerCase().replaceAll("\\W", ""));
                    value = tmp[1];
                    if (PerlMakefileParser.containsOpener(value)) {
                        flags |= true;
                    } else {
                        this.mMakefileDefinitions.put(key, value);
                    }
                }
                if (!(flags & true)) continue;
                PerlMakefileParser.checkBrackets(brackets, line);
                tempVar = tempVar.concat(line.trim());
                if (!brackets.isEmpty()) continue;
                key = PerlMakefileParser.removeVariableSigils(tempVar.substring(0, tempVar.indexOf(ASSOCIATIVE_OPERATOR)).toLowerCase().replaceAll("\\W", ""));
                value = tempVar.substring(tempVar.indexOf(ASSOCIATIVE_OPERATOR) + 2, tempVar.length());
                this.mMakefileDefinitions.put(key, value);
                tempVar = "";
                flags &= false;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void checkBrackets(Stack<Character> brackets, String line) {
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '[' || c == '{' || c == '(') {
                brackets.push(Character.valueOf(c));
            } else if (!(c != SURROUNDING_CHARACTER.get(Character.valueOf('[')).charValue() && c != SURROUNDING_CHARACTER.get(Character.valueOf('{')).charValue() && c != SURROUNDING_CHARACTER.get(Character.valueOf('(')).charValue() || brackets.peek() != SURROUNDING_CHARACTER.get(Character.valueOf(c)) || brackets.isEmpty())) {
                brackets.pop();
            }
            ++n2;
        }
    }

    private void resolveVariables(Map<String, String> variables) {
        String tempVal = "";
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            tempVal = entry.getValue();
            if (!this.mVariableDefinitions.containsKey(tempVal)) continue;
            variables.put(entry.getKey(), this.mVariableDefinitions.get(tempVal));
        }
    }

    public static Map<String, String> extractFunction(String line) {
        HashMap<String, String> rc = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(FUNCTION, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            rc.put(variableMatcher.group(1), variableMatcher.group(2));
        }
        return rc;
    }

    public static Map<String, String> extractKeyValueAssociation(String line) {
        HashMap<String, String> rc = new HashMap<String, String>();
        String key = "";
        String value = "";
        if (PerlMakefileParser.matchesAssociativeAssignment(line)) {
            String[] keyValue = line.split(ASSOCIATIVE_OPERATOR);
            key = PerlMakefileParser.cleanUpString(keyValue[0].toLowerCase());
            value = PerlMakefileParser.cleanUpString(keyValue[1]);
            rc.put(key, value);
        }
        return rc;
    }

    private static void cleanupVariables(Map<String, String> variables) {
        String val = "";
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            val = PerlMakefileParser.cleanUpString(PerlMakefileParser.removeVariableSigils(entry.getValue())).trim();
            if (val.startsWith("(") || val.startsWith("[") || val.startsWith("{")) {
                val = val.substring(1, val.length());
            }
            if (val.endsWith(")") || val.endsWith("]") || val.endsWith("}")) {
                val = val.substring(0, val.length() - 1);
            }
            val = PerlMakefileParser.cleanUpString(val);
            variables.put(entry.getKey(), val);
        }
    }

    private static String cleanUpString(String line) {
        String rc = "";
        if ((line = line.trim().replaceAll("('|\")", "")).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.endsWith(",")) {
            line = line.substring(0, line.length() - 1);
        }
        rc = line;
        return rc;
    }

    public static String removeVariableSigils(String variable) {
        return variable.replaceAll("(\\bmy\\b|\\bour\\b|\\blocal\\b|(\\\\)?\\$|(\\\\)?@|(\\\\)?%)", "");
    }

    private static String cleanUpContent(Scanner scanner) {
        String rc = "";
        String line = "";
        boolean flagEND = true;
        boolean flagBC = true;
        while (scanner.hasNext()) {
            line = scanner.nextLine();
            if (PerlMakefileParser.containsBeginEND(line)) {
                flagEND = false;
            } else if (PerlMakefileParser.matchesEndEND(line)) {
                line = scanner.nextLine();
                flagEND = true;
            }
            if (PerlMakefileParser.matchesBeginBC(line)) {
                flagBC = false;
            } else if (PerlMakefileParser.matchesEndBC(line)) {
                line = scanner.nextLine();
                flagBC = true;
            }
            if (PerlMakefileParser.matchesLineWithComment(line)) {
                line = line.replaceAll(COMMENT, "");
            }
            if (!flagEND || !flagBC || line.trim().equals("")) continue;
            rc = rc.concat(String.valueOf(line) + '\n');
        }
        return rc;
    }

    public static boolean containsFunction(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(FUNCTION, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    public static boolean containsMakefileFunction(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(MAKEFILE_FUNCTION, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    public static boolean containsOpener(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile("(\\(|\\[|\\{)", 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    public static boolean containsBeginEND(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(BEGIN_END);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesSimpleAssignment(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(SIMPLE_ASSIGNMENT, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesAssociativeAssignment(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(ASSOCIATIVE_ASSIGNMENT, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesEndEND(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(END_END);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesBeginBC(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(BEGIN_BC);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesEndBC(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(END_BC);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public static boolean matchesLineWithComment(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(LINE_WITH_COMMENT, 2);
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }
}

