/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.net.URI;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.SourceFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.BaseClassesListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.ConstructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.DestructorMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.MethodStubsListDialogField;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NamespaceSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewBaseClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassCodeGenerator;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardUtil;
import org.eclipse.cdt.internal.ui.wizards.classwizard.SourceFileSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NewClassCreationWizardPage
extends NewElementWizardPage {
    protected static final String PAGE_NAME = "NewClassWizardPage";
    protected static final int MAX_FIELD_CHARS = 50;
    private static final String KEY_NAMESPACE_SELECTED = "namespaceSelected";
    private static final String KEY_NAMESPACE = "namespace";
    private static final String KEY_TEST_FILE_SELECTED = "testFileSelected";
    private static final String KEY_STUB_SELECTED = "stubSelected";
    private static final String KEY_STUB_VIRTUAL = "stubVirtual";
    private static final String KEY_STUB_INLINE = "stubInline";
    protected static final int SOURCE_FOLDER_ID = 1;
    protected static final int NAMESPACE_ID = 2;
    protected static final int CLASS_NAME_ID = 4;
    protected static final int BASE_CLASSES_ID = 8;
    protected static final int METHOD_STUBS_ID = 16;
    protected static final int HEADER_FILE_ID = 32;
    protected static final int SOURCE_FILE_ID = 64;
    protected static final int TEST_FILE_ID = 128;
    protected static final int ALL_FIELDS = 255;
    protected int fLastFocusedField = 0;
    protected StringButtonDialogField fSourceFolderDialogField;
    protected SelectionButtonDialogField fNamespaceSelection;
    protected StringButtonDialogField fNamespaceDialogField;
    protected StringDialogField fClassNameDialogField;
    protected BaseClassesListDialogField fBaseClassesDialogField;
    protected MethodStubsListDialogField fMethodStubsDialogField;
    protected StringButtonDialogField fHeaderFileDialogField;
    protected StringButtonDialogField fSourceFileDialogField;
    protected StringButtonDialogField fTestFileDialogField;
    protected SelectionButtonDialogField fTestFileSelection;
    protected boolean fHeaderFileDerivedFromClassName;
    protected boolean fSourceFileDerivedFromClassName;
    protected boolean fTestFileDerivedFromClassName;
    protected IStatus fSourceFolderStatus;
    protected IStatus fNamespaceStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassesStatus;
    protected IStatus fMethodStubsStatus;
    protected IStatus fHeaderFileStatus;
    protected IStatus fSourceFileStatus;
    protected IStatus fTestFileStatus;
    protected final IStatus STATUS_OK = new StatusInfo();
    protected IFile fCreatedHeaderFile;
    protected IFile fCreatedSourceFile;
    protected IFile fCreatedTestFile;
    protected ICElement fCreatedClass;
    private boolean isFirstTime = false;
    private static final int MAX_UNIQUE_CLASSNAME = 99;
    private IDialogSettings fDialogSettings;

    public NewClassCreationWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewClassWizardMessages.NewClassCreationWizardPage_title);
        this.setDescription(NewClassWizardMessages.NewClassCreationWizardPage_description);
        SourceFolderFieldAdapter sourceFolderAdapter = new SourceFolderFieldAdapter();
        this.fSourceFolderDialogField = new StringButtonDialogField(sourceFolderAdapter);
        this.fSourceFolderDialogField.setDialogFieldListener(sourceFolderAdapter);
        this.fSourceFolderDialogField.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_sourceFolder_label);
        this.fSourceFolderDialogField.setButtonLabel(NewClassWizardMessages.NewClassCreationWizardPage_sourceFolder_button);
        NamespaceFieldAdapter namespaceAdapter = new NamespaceFieldAdapter();
        this.fNamespaceSelection = new SelectionButtonDialogField(32);
        this.fNamespaceSelection.setDialogFieldListener(namespaceAdapter);
        this.fNamespaceSelection.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_namespace_label);
        this.fNamespaceDialogField = new StringButtonDialogField(namespaceAdapter);
        this.fNamespaceDialogField.setDialogFieldListener(namespaceAdapter);
        this.fNamespaceDialogField.setButtonLabel(NewClassWizardMessages.NewClassCreationWizardPage_namespace_button);
        ClassNameFieldAdapter classAdapter = new ClassNameFieldAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(classAdapter);
        this.fClassNameDialogField.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_className_label);
        BaseClassesFieldAdapter baseClassesAdapter = new BaseClassesFieldAdapter();
        this.fBaseClassesDialogField = new BaseClassesListDialogField(NewClassWizardMessages.NewClassCreationWizardPage_baseClasses_label, baseClassesAdapter);
        MethodStubsFieldAdapter methodStubsAdapter = new MethodStubsFieldAdapter();
        this.fMethodStubsDialogField = new MethodStubsListDialogField(NewClassWizardMessages.NewClassCreationWizardPage_methodStubs_label, methodStubsAdapter);
        FileGroupFieldAdapter fileGroupAdapter = new FileGroupFieldAdapter();
        this.fHeaderFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fHeaderFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fHeaderFileDialogField.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_headerFile_label);
        this.fHeaderFileDialogField.setButtonLabel(NewClassWizardMessages.NewClassCreationWizardPage_headerFile_button);
        this.fSourceFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fSourceFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fSourceFileDialogField.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_sourceFile_label);
        this.fSourceFileDialogField.setButtonLabel(NewClassWizardMessages.NewClassCreationWizardPage_sourceFile_button);
        this.fTestFileSelection = new SelectionButtonDialogField(32);
        this.fTestFileSelection.setDialogFieldListener(fileGroupAdapter);
        this.fTestFileSelection.setLabelText(NewClassWizardMessages.NewClassCreationWizardPage_testFile_label);
        this.fTestFileDialogField = new StringButtonDialogField(fileGroupAdapter);
        this.fTestFileDialogField.setDialogFieldListener(fileGroupAdapter);
        this.fTestFileDialogField.setButtonLabel(NewClassWizardMessages.NewClassCreationWizardPage_testFile_button);
        this.fHeaderFileDerivedFromClassName = true;
        this.fSourceFileDerivedFromClassName = true;
        this.fTestFileDerivedFromClassName = true;
        this.fSourceFolderStatus = this.STATUS_OK;
        this.fNamespaceStatus = this.STATUS_OK;
        this.fClassNameStatus = this.STATUS_OK;
        this.fBaseClassesStatus = this.STATUS_OK;
        this.fMethodStubsStatus = this.STATUS_OK;
        this.fHeaderFileStatus = this.STATUS_OK;
        this.fSourceFileStatus = this.STATUS_OK;
        this.fTestFileStatus = this.STATUS_OK;
        this.fLastFocusedField = 0;
        this.isFirstTime = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSourceFolderControls(composite, nColumns);
        this.createNamespaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassNameControls(composite, nColumns);
        this.createBaseClassesControls(composite, nColumns);
        this.createMethodStubsControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createFileControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createSourceFolderControls(Composite parent, int nColumns) {
        this.fSourceFolderDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fSourceFolderDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(1));
    }

    protected void createNamespaceControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fNamespaceSelection.doFillIntoGrid(tabGroup, 1);
        Text textControl = this.fNamespaceDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(2));
        Button button = this.fNamespaceDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    protected void createClassNameControls(Composite composite, int nColumns) {
        this.fClassNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text textControl = this.fClassNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(4));
    }

    protected void createBaseClassesControls(Composite composite, int nColumns) {
        this.fBaseClassesDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fBaseClassesDialogField.getListControl(null);
        LayoutUtil.setVerticalGrabbing(listControl, false);
        listControl.addFocusListener((FocusListener)new StatusFocusListener(8));
    }

    protected void createMethodStubsControls(Composite composite, int nColumns) {
        this.fMethodStubsDialogField.doFillIntoGrid(composite, nColumns);
        Control listControl = this.fMethodStubsDialogField.getListControl(null);
        LayoutUtil.setHeightHint(listControl, this.convertHeightInCharsToPixels(6) + this.convertHeightInCharsToPixels(1) / 2);
        LayoutUtil.setVerticalGrabbing(listControl, false);
        listControl.addFocusListener((FocusListener)new StatusFocusListener(16));
    }

    protected void createFileControls(Composite composite, int nColumns) {
        this.fHeaderFileDialogField.doFillIntoGrid(composite, nColumns);
        Text textControl = this.fHeaderFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(32));
        this.fSourceFileDialogField.doFillIntoGrid(composite, nColumns);
        textControl = this.fSourceFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(64));
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fTestFileSelection.doFillIntoGrid(tabGroup, 1);
        textControl = this.fTestFileDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        textControl.setLayoutData((Object)gd);
        textControl.addFocusListener((FocusListener)new StatusFocusListener(128));
        Button button = this.fTestFileDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
    }

    public void init(IStructuredSelection selection) {
        String text;
        ICElement ns;
        if (this.fDialogSettings == null) {
            this.fDialogSettings = this.getDialogSettings().getSection(PAGE_NAME);
            if (this.fDialogSettings == null) {
                this.fDialogSettings = this.getDialogSettings().addNewSection(PAGE_NAME);
            }
        }
        ICElement celem = this.getInitialCElement(selection);
        String namespace = null;
        if (celem != null && (ns = NewClassWizardUtil.getNamespace(celem)) != null && (namespace = TypeUtil.getFullyQualifiedName((ICElement)ns).toString()) != null && namespace.length() == 0) {
            namespace = null;
        }
        if (namespace == null) {
            namespace = this.fDialogSettings.get(KEY_NAMESPACE);
        }
        this.setNamespaceText(namespace, false);
        this.setNamespaceSelection(namespace != null || this.fDialogSettings.getBoolean(KEY_NAMESPACE_SELECTED), true);
        IPath folderPath = null;
        if (celem != null) {
            ICProject cproject;
            ICContainer folder = NewClassWizardUtil.getSourceFolder(celem);
            if (folder == null && (cproject = celem.getCProject()) != null) {
                folder = NewClassWizardUtil.getFirstSourceRoot(cproject);
            }
            if (folder != null) {
                folderPath = folder.getResource().getFullPath();
            }
        }
        this.setSourceFolderFullPath(folderPath, false);
        String className = null;
        ITextSelection textSel = this.getEditorTextSelection();
        if (textSel != null && (text = textSel.getText()) != null && text.length() > 0 && CConventions.validateClassName((String)text).isOK()) {
            className = text;
        }
        this.setClassName(className, true);
        IMethodStub[] stubs = this.getDefaultMethodStubs();
        int i = 0;
        while (i < stubs.length) {
            IMethodStub stub = stubs[i];
            if (stub.canModifyVirtual()) {
                stub.setVirtual(this.getBooleanSettingWithDefault(KEY_STUB_VIRTUAL + i, stub.isVirtual()));
            }
            if (stub.canModifyInline()) {
                stub.setInline(this.getBooleanSettingWithDefault(KEY_STUB_INLINE + i, stub.isInline()));
            }
            this.addMethodStub(stub, this.getBooleanSettingWithDefault(KEY_STUB_SELECTED + i, true));
            ++i;
        }
        this.setTestFileSelection(this.fDialogSettings.getBoolean(KEY_TEST_FILE_SELECTED), true);
        this.handleFieldChanged(255);
    }

    private boolean getBooleanSettingWithDefault(String key, boolean defaultValue) {
        String value = this.fDialogSettings.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    protected ICElement getInitialCElement(IStructuredSelection selection) {
        ICElement celem = NewClassWizardUtil.getCElementFromSelection(selection);
        if (celem == null) {
            celem = NewClassWizardUtil.getCElementFromEditor();
        }
        if (celem == null || celem.getElementType() == 10) {
            try {
                ICProject[] projects = CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot()).getCProjects();
                if (projects.length == 1) {
                    celem = projects[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
        return celem;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(50);
    }

    protected ITextSelection getEditorTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected IMethodStub[] getDefaultMethodStubs() {
        return new IMethodStub[]{new ConstructorMethodStub(), new DestructorMethodStub()};
    }

    public String getSourceFolderText() {
        return this.fSourceFolderDialogField.getText().trim();
    }

    public void setSourceFolderText(String folder, boolean update) {
        this.fSourceFolderDialogField.setTextWithoutUpdate(folder != null ? folder : "");
        if (update) {
            this.fSourceFolderDialogField.dialogFieldChanged();
        }
    }

    protected IPath getSourceFolderFullPath() {
        String text = this.getSourceFolderText();
        if (text.length() > 0) {
            return new Path(text).makeAbsolute();
        }
        return null;
    }

    protected void setSourceFolderFullPath(IPath folderPath, boolean update) {
        String str = folderPath != null ? folderPath.makeRelative().toString() : "";
        this.setSourceFolderText(str, update);
    }

    protected ICProject getCurrentProject() {
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath != null) {
            return this.toCProject(PathUtil.getEnclosingProject((IPath)folderPath));
        }
        return null;
    }

    private ICProject toCProject(IProject enclosingProject) {
        if (enclosingProject != null) {
            return CoreModel.getDefault().create(enclosingProject);
        }
        return null;
    }

    public String getNamespaceText() {
        return this.fNamespaceDialogField.getText().trim();
    }

    public void setNamespaceText(String namespace, boolean update) {
        this.fNamespaceDialogField.setTextWithoutUpdate(namespace != null ? namespace : "");
        if (update) {
            this.fNamespaceDialogField.dialogFieldChanged();
        }
    }

    public boolean isNamespaceSelected() {
        return this.fNamespaceSelection.isSelected();
    }

    public void setNamespaceSelection(boolean isSelected, boolean canBeModified) {
        this.fNamespaceSelection.setSelection(isSelected);
        this.fNamespaceSelection.setEnabled(canBeModified);
        this.updateNamespaceEnableState();
    }

    private void updateNamespaceEnableState() {
        this.fNamespaceDialogField.setEnabled(this.isNamespaceSelected());
    }

    public String getClassName() {
        return this.fClassNameDialogField.getText().trim();
    }

    public void setClassName(String name, boolean update) {
        this.fClassNameDialogField.setTextWithoutUpdate(name != null ? name : "");
        if (update) {
            this.fClassNameDialogField.dialogFieldChanged();
        }
    }

    protected IMethodStub[] getSelectedMethodStubs() {
        return this.fMethodStubsDialogField.getCheckedMethodStubs();
    }

    protected void addMethodStub(IMethodStub methodStub, boolean selected) {
        this.fMethodStubsDialogField.addMethodStub(methodStub, selected);
    }

    protected IBaseClassInfo[] getBaseClasses() {
        List<IBaseClassInfo> classesList = this.fBaseClassesDialogField.getElements();
        return classesList.toArray(new IBaseClassInfo[classesList.size()]);
    }

    protected void addBaseClass(ITypeInfo newBaseClass, ASTAccessVisibility access, boolean isVirtual) {
        List baseClasses = this.fBaseClassesDialogField.getElements();
        if (baseClasses != null) {
            for (IBaseClassInfo baseClassInfo : baseClasses) {
                BaseClassInfo info = (BaseClassInfo)baseClassInfo;
                if (!info.getType().equals(newBaseClass)) continue;
                return;
            }
        }
        if (this.verifyBaseClasses()) {
            NewClassWizardUtil.resolveClassLocation(newBaseClass, (IRunnableContext)this.getContainer());
        }
        this.fBaseClassesDialogField.addBaseClass(new BaseClassInfo(newBaseClass, access, isVirtual));
    }

    public void setTestFileSelection(boolean isSelected, boolean canBeModified) {
        this.fTestFileSelection.setSelection(isSelected);
        this.fTestFileSelection.setEnabled(canBeModified);
        this.updateTestFileEnableState();
    }

    private void updateTestFileEnableState() {
        this.fTestFileDialogField.setEnabled(this.fTestFileSelection.isSelected());
    }

    public String getHeaderFileText() {
        return this.fHeaderFileDialogField.getText().trim();
    }

    public void setHeaderFileText(String header, boolean update) {
        this.setFileText(this.fHeaderFileDialogField, header, update);
    }

    protected IPath getHeaderFileFullPath() {
        return this.getFilePath(this.getHeaderFileText());
    }

    protected void setHeaderFileFullPath(IPath path, boolean update) {
        this.setFileFullPath(this.fHeaderFileDialogField, path, update);
    }

    public String getSourceFileText() {
        return this.fSourceFileDialogField.getText().trim();
    }

    public void setSourceFileText(String source, boolean update) {
        this.setFileText(this.fSourceFileDialogField, source, update);
    }

    protected IPath getSourceFileFullPath() {
        return this.getFilePath(this.getSourceFileText());
    }

    protected void setSourceFileFullPath(IPath path, boolean update) {
        this.setFileFullPath(this.fSourceFileDialogField, path, update);
    }

    public String getTestFileText() {
        return this.fTestFileDialogField.isEnabled() ? this.fTestFileDialogField.getText().trim() : null;
    }

    public void setTestFileText(String testFile, boolean update) {
        this.setFileText(this.fTestFileDialogField, testFile, update);
    }

    protected IPath getTestFileFullPath() {
        return this.getFilePath(this.getTestFileText());
    }

    private IPath getFilePath(String filename) {
        IPath folderPath;
        if (filename == null || filename.length() == 0) {
            return null;
        }
        Path path = new Path(filename);
        if (!path.isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    private void setFileText(StringButtonDialogField field, String filename, boolean update) {
        field.setTextWithoutUpdate(filename != null ? filename : "");
        if (update) {
            field.dialogFieldChanged();
        }
    }

    private void setFileFullPath(StringButtonDialogField field, IPath path, boolean update) {
        String str = null;
        if (path != null) {
            IPath relativePath;
            IPath sourceFolder = this.getSourceFolderFullPath();
            if (sourceFolder != null && (relativePath = PathUtil.makeRelativePath((IPath)path, (IPath)sourceFolder)) != null) {
                path = relativePath;
            }
            str = path.makeRelative().toString();
        }
        this.setFileText(field, str, update);
    }

    protected void setTestFileFullPath(IPath path, boolean update) {
        this.setFileFullPath(this.fTestFileDialogField, path, update);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fClassNameDialogField.setFocus();
    }

    private IPath chooseSourceFolder(IPath initialPath) {
        Object result;
        ICProject cProject;
        ISourceRoot projRoot;
        ICContainer initElement = NewClassWizardUtil.getSourceFolder(initialPath);
        if (initElement instanceof ISourceRoot && (projRoot = (cProject = initElement.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(initElement)) {
            initElement = cProject;
        }
        SourceFolderSelectionDialog dialog = new SourceFolderSelectionDialog(this.getShell());
        dialog.setInput(CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot()));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof ICElement) {
            ICProject cproject;
            ISourceRoot folder;
            ICElement element = (ICElement)result;
            if (element instanceof ICProject && (folder = (cproject = (ICProject)element).findSourceRoot((IResource)cproject.getProject())) != null) {
                return folder.getResource().getFullPath();
            }
            return element.getResource().getFullPath();
        }
        return null;
    }

    private IPath updateSourceFolderFromPath(IPath filePath) {
        ICProject cProject;
        ISourceRoot projRoot;
        ICContainer folder = NewClassWizardUtil.getSourceFolder(filePath);
        if (folder instanceof ISourceRoot && (projRoot = (cProject = folder.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(folder)) {
            folder = cProject;
        }
        if (folder != null) {
            return folder.getPath();
        }
        IProject proj = PathUtil.getEnclosingProject((IPath)filePath);
        if (proj != null) {
            return proj.getFullPath();
        }
        return null;
    }

    private ITypeInfo chooseNamespace() {
        ICProject project = this.getCurrentProject();
        TypeSearchScope scope = project != null ? new TypeSearchScope(project) : new TypeSearchScope(true);
        Object[] elements = AllTypesCache.getNamespaces((ITypeSearchScope)scope, (boolean)false);
        if (elements == null || elements.length == 0) {
            String title = NewClassWizardMessages.NewClassCreationWizardPage_getTypes_noNamespaces_title;
            String message = NewClassWizardMessages.NewClassCreationWizardPage_getTypes_noNamespaces_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return null;
        }
        NamespaceSelectionDialog dialog = new NamespaceSelectionDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result == 0) {
            return (ITypeInfo)dialog.getFirstResult();
        }
        return null;
    }

    private void chooseBaseClasses() {
        List oldContents = this.fBaseClassesDialogField.getElements();
        NewBaseClassSelectionDialog dialog = new NewBaseClassSelectionDialog(this.getShell());
        dialog.addListener(new NewBaseClassSelectionDialog.ITypeSelectionListener(){

            @Override
            public void typeAdded(ITypeInfo newBaseClass) {
                NewClassCreationWizardPage.this.addBaseClass(newBaseClass, ASTAccessVisibility.PUBLIC, false);
            }
        });
        int result = dialog.open();
        if (result != 0) {
            this.fBaseClassesDialogField.setElements(oldContents);
        }
    }

    private IPath chooseFile(String title, IPath initialPath) {
        SourceFileSelectionDialog dialog = new SourceFileSelectionDialog(this.getShell());
        dialog.setTitle(title);
        ICModel input = CoreModel.create((IWorkspaceRoot)NewClassWizardUtil.getWorkspaceRoot());
        ICProject project = this.getCurrentProject();
        if (project != null) {
            input = project;
        }
        dialog.setInput((ICElement)input);
        IPath filePath = initialPath;
        if (filePath != null) {
            String folderName = filePath.removeLastSegments(1).toString();
            String fileName = filePath.lastSegment();
            dialog.setInitialSelection(folderName, fileName);
        } else {
            filePath = this.getSourceFolderFullPath();
            if (filePath != null) {
                dialog.setInitialSelection(filePath.toString(), null);
            }
        }
        if (dialog.open() == 0) {
            return dialog.getFilePath();
        }
        return null;
    }

    private void updateFilesFromClassName(String className) {
        String[] names;
        String headerName = "";
        String sourceName = "";
        String testName = "";
        IPath folder = this.getSourceFolderFullPath();
        if (className != null && className.length() > 0 && (names = this.generateFileNames(className, folder)) != null && names.length == 3) {
            headerName = names[0];
            sourceName = names[1];
            testName = names[2];
        }
        if (this.fHeaderFileDerivedFromClassName) {
            this.fHeaderFileDialogField.setTextWithoutUpdate(headerName);
        }
        if (this.fSourceFileDerivedFromClassName) {
            this.fSourceFileDialogField.setTextWithoutUpdate(sourceName);
        }
        if (this.fTestFileDerivedFromClassName && this.fTestFileDialogField.isEnabled()) {
            this.fTestFileDialogField.setTextWithoutUpdate(testName);
        }
    }

    protected String[] generateFileNames(String className, IPath folder) {
        String headerName = null;
        String sourceName = null;
        String testName = null;
        if (folder == null) {
            headerName = NewSourceFileGenerator.generateHeaderFileNameFromClass(className);
            sourceName = NewSourceFileGenerator.generateSourceFileNameFromClass(className);
            testName = NewSourceFileGenerator.generateTestFileNameFromClass(className);
        } else {
            String currName = className;
            int count = 0;
            String separator = "";
            if (Character.isDigit(className.charAt(className.length() - 1))) {
                separator = "_";
            }
            while (count < 99) {
                String test;
                String source;
                String header = NewSourceFileGenerator.generateHeaderFileNameFromClass(currName);
                IPath path = folder.append(header);
                if (!(path.toFile().exists() || (path = folder.append(source = NewSourceFileGenerator.generateSourceFileNameFromClass(currName))).toFile().exists() || (path = folder.append(test = NewSourceFileGenerator.generateTestFileNameFromClass(currName))).toFile().exists())) {
                    headerName = header;
                    sourceName = source;
                    testName = test;
                    break;
                }
                currName = String.valueOf(className) + separator + ++count;
            }
        }
        return new String[]{headerName, sourceName, testName};
    }

    protected void handleFieldChanged(int fields) {
        if (fields == 0) {
            return;
        }
        if (this.fieldChanged(fields, 1)) {
            this.fSourceFolderStatus = this.sourceFolderChanged();
        }
        if (this.fieldChanged(fields, 2)) {
            this.fNamespaceStatus = this.namespaceChanged();
        }
        if (this.fieldChanged(fields, 4)) {
            this.fClassNameStatus = this.classNameChanged();
        }
        if (this.fieldChanged(fields, 8)) {
            this.fBaseClassesStatus = this.baseClassesChanged();
        }
        if (this.fieldChanged(fields, 16)) {
            this.fMethodStubsStatus = this.methodStubsChanged();
        }
        if (this.fieldChanged(fields, 32)) {
            this.fHeaderFileStatus = this.headerFileChanged();
        }
        if (this.fieldChanged(fields, 64)) {
            this.fSourceFileStatus = this.sourceFileChanged();
        }
        if (this.fieldChanged(fields, 128)) {
            this.fTestFileStatus = this.testFileChanged();
        }
        this.doStatusUpdate();
    }

    private boolean fieldChanged(int fields, int fieldID) {
        return (fields & fieldID) != 0;
    }

    protected void doStatusUpdate() {
        IStatus lastStatus = this.getLastFocusedStatus();
        boolean isClassNameWarning = this.fClassNameStatus.getSeverity() == 2;
        IStatus[] status = new IStatus[]{lastStatus, this.fSourceFolderStatus != lastStatus ? this.fSourceFolderStatus : this.STATUS_OK, this.fNamespaceStatus != lastStatus ? this.fNamespaceStatus : this.STATUS_OK, this.fHeaderFileStatus != lastStatus && isClassNameWarning ? this.fHeaderFileStatus : this.STATUS_OK, this.fSourceFileStatus != lastStatus && isClassNameWarning ? this.fSourceFileStatus : this.STATUS_OK, this.fTestFileStatus != lastStatus && isClassNameWarning ? this.fTestFileStatus : this.STATUS_OK, this.fClassNameStatus != lastStatus ? this.fClassNameStatus : this.STATUS_OK, this.fBaseClassesStatus != lastStatus ? this.fBaseClassesStatus : this.STATUS_OK, this.fMethodStubsStatus != lastStatus ? this.fMethodStubsStatus : this.STATUS_OK, this.fHeaderFileStatus != lastStatus ? this.fHeaderFileStatus : this.STATUS_OK, this.fSourceFileStatus != lastStatus ? this.fSourceFileStatus : this.STATUS_OK, this.fTestFileStatus != lastStatus ? this.fTestFileStatus : this.STATUS_OK};
        this.updateStatus(status);
    }

    protected IStatus getLastFocusedStatus() {
        switch (this.fLastFocusedField) {
            case 1: {
                return this.fSourceFolderStatus;
            }
            case 2: {
                return this.fNamespaceStatus;
            }
            case 4: {
                return this.fClassNameStatus;
            }
            case 8: {
                return this.fBaseClassesStatus;
            }
            case 16: {
                return this.fMethodStubsStatus;
            }
            case 32: {
                return this.fHeaderFileStatus;
            }
            case 64: {
                return this.fSourceFileStatus;
            }
            case 128: {
                return this.fTestFileStatus;
            }
        }
        return this.STATUS_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus sourceFolderChanged() {
        StatusInfo status = new StatusInfo();
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath == null) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterSourceFolderName);
            return status;
        }
        IResource res = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (res != null && res.exists()) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFolder, (Object)folderPath));
                    return status;
                }
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    if (resType == 4) {
                        status.setError(NewClassWizardMessages.NewClassCreationWizardPage_warning_NotACProject);
                        return status;
                    }
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_NotInACProject);
                }
                if (NewClassWizardUtil.isOnSourceRoot(res)) return status;
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotASourceFolder, (Object)folderPath));
                return status;
            }
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFolder, (Object)folderPath));
            return status;
        }
        status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
        return status;
    }

    protected IStatus namespaceChanged() {
        StatusInfo status = new StatusInfo();
        if (!this.isNamespaceSelected()) {
            return status;
        }
        String namespace = this.getNamespaceText();
        if (namespace == null || namespace.length() == 0) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterNamespace);
            return status;
        }
        IStatus val = CConventions.validateNamespaceName((String)namespace);
        if (val.getSeverity() == 4) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidNamespace, (Object)val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_NamespaceDiscouraged, (Object)val.getMessage()));
        }
        QualifiedTypeName typeName = new QualifiedTypeName(namespace);
        ICProject project = this.getCurrentProject();
        if (project != null) {
            int searchResult = NewClassWizardUtil.searchForCppType((IQualifiedTypeName)typeName, project, ICPPNamespace.class);
            switch (searchResult) {
                case 1: {
                    status.setOK();
                    return status;
                }
                case 2: {
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_error_TypeMatchingNamespaceExists);
                    return status;
                }
                case 3: {
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_error_NamespaceExistsDifferentCase);
                    return status;
                }
                case 4: {
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_error_TypeMatchingNamespaceExistsDifferentCase);
                    return status;
                }
                case 0: {
                    QualifiedTypeName ns = typeName;
                    while (ns.isQualified()) {
                        IQualifiedTypeName ns1 = ns.getEnclosingTypeName();
                        if (NewClassWizardUtil.searchForCppType(ns1, project, ICPPNamespace.class) == 1) break;
                        ns = ns1;
                    }
                    status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_NamespaceNotExists, (Object)ns.getFullyQualifiedName()));
                }
            }
        }
        if ((val = CConventions.validateNamespaceName((String)typeName.lastSegment())).getSeverity() == 4) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidNamespace, (Object)val.getMessage()));
            return status;
        }
        return status;
    }

    protected IStatus classNameChanged() {
        ICProject project;
        StatusInfo status = new StatusInfo();
        String className = this.getClassName();
        if (className == null || className.length() == 0) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterClassName);
            return status;
        }
        QualifiedTypeName typeName = new QualifiedTypeName(className);
        if (typeName.isQualified()) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_QualifiedClassName);
            return status;
        }
        IStatus val = CConventions.validateClassName((String)className);
        if (val.getSeverity() == 4) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidClassName, (Object)val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_ClassNameDiscouraged, (Object)val.getMessage()));
        }
        if ((project = this.getCurrentProject()) != null) {
            String namespace;
            QualifiedTypeName fullyQualifiedName = typeName;
            if (this.isNamespaceSelected() && (namespace = this.getNamespaceText()) != null && namespace.length() > 0) {
                fullyQualifiedName = new QualifiedTypeName(namespace).append((IQualifiedTypeName)typeName);
            }
            int searchResult = NewClassWizardUtil.searchForCppType((IQualifiedTypeName)fullyQualifiedName, project, ICPPClassType.class);
            switch (searchResult) {
                case 1: {
                    status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_ClassNameExists);
                    return status;
                }
                case 2: {
                    status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_TypeMatchingClassExists);
                    return status;
                }
                case 3: {
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_error_ClassNameExistsDifferentCase);
                    return status;
                }
                case 4: {
                    status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_error_TypeMatchingClassExistsDifferentCase);
                    return status;
                }
            }
        }
        return status;
    }

    protected IStatus baseClassesChanged() {
        if (this.verifyBaseClasses()) {
            IBaseClassInfo[] baseClasses;
            IPath folder = this.getSourceFolderFullPath();
            ICProject project = this.getCurrentProject();
            if (project != null && (baseClasses = this.getBaseClasses()) != null && baseClasses.length > 0) {
                IStatus status = this.baseClassesChanged(project, folder, baseClasses);
                if (status.isMultiStatus()) {
                    return StatusUtil.getMostSevere(status.getChildren());
                }
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus baseClassesChanged(ICProject project, IPath sourceFolder, IBaseClassInfo[] baseClasses) {
        IScannerInfo info;
        MultiStatus status = new MultiStatus(CUIPlugin.getPluginId(), 0, "", null);
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project.getProject());
        if (provider != null && (info = provider.getScannerInformation((IResource)project.getProject())) != null) {
            String[] includePaths = info.getIncludePaths();
            int i = 0;
            while (i < baseClasses.length) {
                IBaseClassInfo baseClass = baseClasses[i];
                ITypeInfo baseType = baseClass.getType();
                StatusInfo baseClassStatus = new StatusInfo();
                if (!NewClassWizardUtil.isTypeReachable(baseType, project, includePaths)) {
                    baseClassStatus.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_BaseClassNotExistsInProject, (Object)baseType.getQualifiedTypeName().toString()));
                }
                status.add((IStatus)baseClassStatus);
                ++i;
            }
        }
        return status;
    }

    public boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    protected IStatus methodStubsChanged() {
        return Status.OK_STATUS;
    }

    protected IStatus headerFileChanged() {
        StatusInfo status = new StatusInfo();
        IPath path = this.getHeaderFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterHeaderFileName);
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_HeaderFileNotInSourceFolder);
            return status;
        }
        if (!NewClassWizardUtil.isOnSourceRoot(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_HeaderFileNotInSourceFolder);
            return status;
        }
        boolean fileExists = false;
        IFile file = NewClassWizardUtil.getWorkspaceRoot().getFile(path);
        if (file.getType() == 1) {
            if (!file.exists()) {
                URI location = file.getLocationURI();
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    fileExists = store.fetchInfo().exists();
                }
                catch (CoreException e) {
                    status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_LocationUnknown);
                    return status;
                }
            } else {
                fileExists = true;
            }
            IProject proj = file.getProject();
            if (!proj.isOpen()) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile, (Object)path));
                return status;
            }
            if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_NotInACProject);
            } else if (fileExists) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_HeaderFileExists);
            }
        } else {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile);
            return status;
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateHeaderFileName((IProject)this.getCurrentProject().getProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidHeaderFileName, (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_HeaderFileNameDiscouraged, (Object)val.getMessage()));
            }
        }
        return status;
    }

    protected IStatus sourceFileChanged() {
        StatusInfo status = new StatusInfo();
        IPath path = this.getSourceFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterSourceFileName);
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_SourceFileNotInSourceFolder);
            return status;
        }
        if (!NewClassWizardUtil.isOnSourceRoot(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_SourceFileNotInSourceFolder);
            return status;
        }
        boolean fileExists = false;
        IFile file = NewClassWizardUtil.getWorkspaceRoot().getFile(path);
        if (file.getType() == 1) {
            if (!file.exists()) {
                URI location = file.getLocationURI();
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    fileExists = store.fetchInfo().exists();
                }
                catch (CoreException e) {
                    status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_LocationUnknown);
                    return status;
                }
            } else {
                fileExists = true;
            }
            IProject proj = file.getProject();
            if (!proj.isOpen()) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile, (Object)path));
                return status;
            }
            if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_NotInACProject);
            } else if (fileExists) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_SourceFileExists);
            }
        } else {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile);
            return status;
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateSourceFileName((IProject)this.getCurrentProject().getProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidSourceFileName, (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_SourceFileNameDiscouraged, (Object)val.getMessage()));
            }
        }
        return status;
    }

    protected IStatus testFileChanged() {
        StatusInfo status = new StatusInfo();
        if (!this.fTestFileDialogField.isEnabled()) {
            return status;
        }
        IPath path = this.getTestFileFullPath();
        if (path == null) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_EnterTestFileName);
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_TestFileNotInSourceFolder);
            return status;
        }
        if (!NewClassWizardUtil.isOnSourceRoot(path)) {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_TestFileNotInSourceFolder);
            return status;
        }
        boolean fileExists = false;
        IFile file = NewClassWizardUtil.getWorkspaceRoot().getFile(path);
        if (file.getType() == 1) {
            if (!file.exists()) {
                URI location = file.getLocationURI();
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    fileExists = store.fetchInfo().exists();
                }
                catch (CoreException e) {
                    status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_LocationUnknown);
                    return status;
                }
            } else {
                fileExists = true;
            }
            IProject proj = file.getProject();
            if (!proj.isOpen()) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile, (Object)path));
                return status;
            }
            if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_NotInACProject);
            } else if (fileExists) {
                status.setWarning(NewClassWizardMessages.NewClassCreationWizardPage_warning_TestFileExists);
            }
        } else {
            status.setError(NewClassWizardMessages.NewClassCreationWizardPage_error_NotAFile);
            return status;
        }
        IPath folderPath = path.removeLastSegments(1).makeRelative();
        IResource folder = NewClassWizardUtil.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
            return status;
        }
        if (!fileExists) {
            IStatus val = CConventions.validateSourceFileName((IProject)this.getCurrentProject().getProject(), (String)path.lastSegment());
            if (val.getSeverity() == 4) {
                status.setError(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_error_InvalidTestFileName, (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NLS.bind((String)NewClassWizardMessages.NewClassCreationWizardPage_warning_TestFileNameDiscouraged, (Object)val.getMessage()));
            }
        }
        return status;
    }

    public void createClass(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fDialogSettings.put(KEY_NAMESPACE_SELECTED, this.fNamespaceSelection.isSelected());
        this.fDialogSettings.put(KEY_TEST_FILE_SELECTED, this.fTestFileSelection.isSelected());
        String namespace = this.fNamespaceSelection.isSelected() ? this.getNamespaceText() : null;
        this.fDialogSettings.put(KEY_NAMESPACE, namespace);
        IMethodStub[] stubs = this.fMethodStubsDialogField.getMethodStubs();
        int i = 0;
        while (i < stubs.length) {
            IMethodStub stub = stubs[i];
            if (stub.canModifyVirtual()) {
                this.fDialogSettings.put(KEY_STUB_VIRTUAL + i, stub.isVirtual());
            }
            if (stub.canModifyInline()) {
                this.fDialogSettings.put(KEY_STUB_INLINE + i, stub.isInline());
            }
            this.fDialogSettings.put(KEY_STUB_SELECTED + i, this.fMethodStubsDialogField.isChecked(stub));
            ++i;
        }
        this.fCreatedClass = null;
        this.fCreatedHeaderFile = null;
        this.fCreatedSourceFile = null;
        this.fCreatedTestFile = null;
        IPath headerPath = this.getHeaderFileFullPath();
        IPath sourcePath = this.getSourceFileFullPath();
        IPath testPath = this.getTestFileFullPath();
        this.createClass(headerPath, sourcePath, testPath, this.getClassName(), namespace, this.getBaseClasses(), this.getSelectedMethodStubs(), monitor);
    }

    public boolean openClassInEditor() {
        return NewClassWizardPrefs.openClassInEditor();
    }

    protected void createClass(IPath headerPath, IPath sourcePath, IPath testPath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs, IProgressMonitor monitor) throws CoreException, InterruptedException {
        NewClassCodeGenerator generator = new NewClassCodeGenerator(headerPath, sourcePath, testPath, className, namespace, baseClasses, methodStubs);
        generator.setForceSourceFileCreation(true);
        generator.createClass(monitor);
        this.fCreatedClass = generator.getCreatedClass();
        this.fCreatedHeaderFile = generator.getCreatedHeaderFile();
        this.fCreatedSourceFile = generator.getCreatedSourceFile();
        this.fCreatedTestFile = generator.getCreatedTestFile();
    }

    protected void createClass(IPath headerPath, IPath sourcePath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs, IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.createClass(headerPath, sourcePath, null, className, namespace, baseClasses, methodStubs, monitor);
    }

    public ICElement getCreatedClass() {
        return this.fCreatedClass;
    }

    public IFile getCreatedHeaderFile() {
        return this.fCreatedHeaderFile;
    }

    public IFile getCreatedSourceFile() {
        return this.fCreatedSourceFile;
    }

    public IFile getCreatedTestFile() {
        return this.fCreatedTestFile;
    }

    private final class BaseClassesFieldAdapter
    implements IListAdapter<IBaseClassInfo> {
        private BaseClassesFieldAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<IBaseClassInfo> field, int index) {
            if (index == 0) {
                NewClassCreationWizardPage.this.chooseBaseClasses();
            }
            NewClassCreationWizardPage.this.handleFieldChanged(8);
        }

        @Override
        public void selectionChanged(ListDialogField<IBaseClassInfo> field) {
        }

        @Override
        public void doubleClicked(ListDialogField<IBaseClassInfo> field) {
        }
    }

    private final class ClassNameFieldAdapter
    implements IDialogFieldListener {
        private ClassNameFieldAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            int changedFields = 4;
            NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText().trim());
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields |= 0xE0);
        }
    }

    private final class FileGroupFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private FileGroupFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            IPath filePath = null;
            IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
            IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
            IPath testPath = NewClassCreationWizardPage.this.getTestFileFullPath();
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                filePath = NewClassCreationWizardPage.this.chooseFile(NewClassWizardMessages.NewClassCreationWizardPage_ChooseHeaderFileDialog_title, NewClassCreationWizardPage.this.getHeaderFileFullPath());
                if (filePath != null) {
                    headerPath = filePath;
                }
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                filePath = NewClassCreationWizardPage.this.chooseFile(NewClassWizardMessages.NewClassCreationWizardPage_ChooseSourceFileDialog_title, NewClassCreationWizardPage.this.getSourceFileFullPath());
                if (filePath != null) {
                    sourcePath = filePath;
                }
            } else if (field == NewClassCreationWizardPage.this.fTestFileDialogField && (filePath = NewClassCreationWizardPage.this.chooseFile(NewClassWizardMessages.NewClassCreationWizardPage_ChooseTestFileDialog_title, NewClassCreationWizardPage.this.getTestFileFullPath())) != null) {
                testPath = filePath;
            }
            if (filePath != null) {
                int segments;
                IPath folderPath = null;
                int changedFields = 0;
                int headerSegments = 0;
                int sourceSegments = 0;
                int testSegments = 0;
                if (headerPath != null) {
                    headerSegments = filePath.matchingFirstSegments(headerPath);
                }
                if (sourcePath != null) {
                    sourceSegments = filePath.matchingFirstSegments(sourcePath);
                }
                if (testPath != null) {
                    testSegments = filePath.matchingFirstSegments(testPath);
                }
                if ((segments = Math.min(Math.min(headerSegments, sourceSegments), testSegments)) > 0) {
                    IPath newFolderPath = filePath.uptoSegment(segments);
                    folderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(newFolderPath);
                }
                if (folderPath != null) {
                    changedFields |= 0xE1;
                    NewClassCreationWizardPage.this.setSourceFolderFullPath(folderPath, false);
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                    NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                    NewClassCreationWizardPage.this.setTestFileFullPath(testPath, false);
                }
                if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                    NewClassCreationWizardPage.this.setHeaderFileFullPath(filePath, false);
                    changedFields |= 0x20;
                } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                    NewClassCreationWizardPage.this.setSourceFileFullPath(filePath, false);
                    changedFields |= 0x40;
                } else if (field == NewClassCreationWizardPage.this.fTestFileDialogField) {
                    NewClassCreationWizardPage.this.setTestFileFullPath(filePath, false);
                    changedFields |= 0x80;
                }
                NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            int changedFields = 0;
            if (field == NewClassCreationWizardPage.this.fTestFileSelection) {
                boolean enabled = NewClassCreationWizardPage.this.fTestFileSelection.isSelected();
                NewClassCreationWizardPage.this.fTestFileDialogField.setEnabled(enabled);
                if (enabled) {
                    NewClassCreationWizardPage.this.fTestFileDerivedFromClassName = true;
                    NewClassCreationWizardPage.this.updateFilesFromClassName(NewClassCreationWizardPage.this.fClassNameDialogField.getText().trim());
                } else {
                    NewClassCreationWizardPage.this.fTestFileDialogField.setTextWithoutUpdate("");
                }
                changedFields = 128;
                NewClassCreationWizardPage.this.updateTestFileEnableState();
                NewClassCreationWizardPage.this.handleFieldChanged(1);
            }
            if (field == NewClassCreationWizardPage.this.fHeaderFileDialogField) {
                changedFields |= 0x20;
                NewClassCreationWizardPage.this.fHeaderFileDerivedFromClassName = false;
            } else if (field == NewClassCreationWizardPage.this.fSourceFileDialogField) {
                changedFields |= 0x40;
                NewClassCreationWizardPage.this.fSourceFileDerivedFromClassName = false;
            } else if (field == NewClassCreationWizardPage.this.fTestFileDialogField) {
                changedFields |= 0x80;
                NewClassCreationWizardPage.this.fTestFileDerivedFromClassName = false;
            }
            NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
        }
    }

    private final class MethodStubsFieldAdapter
    implements IListAdapter<IMethodStub> {
        private MethodStubsFieldAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<IMethodStub> field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField<IMethodStub> field) {
        }

        @Override
        public void doubleClicked(ListDialogField<IMethodStub> field) {
        }
    }

    private final class NamespaceFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private NamespaceFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            ITypeInfo ns = NewClassCreationWizardPage.this.chooseNamespace();
            if (ns != null) {
                int changedFields = 6;
                IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
                if (oldFolderPath == null) {
                    IPath headerPath = NewClassCreationWizardPage.this.getHeaderFileFullPath();
                    IPath sourcePath = NewClassCreationWizardPage.this.getSourceFileFullPath();
                    IPath testPath = NewClassCreationWizardPage.this.getTestFileFullPath();
                    IPath newFolderPath = NewClassCreationWizardPage.this.updateSourceFolderFromPath(ns.getEnclosingProject().getProject().getFullPath());
                    if (newFolderPath != null) {
                        changedFields |= 0xE1;
                        NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                        NewClassCreationWizardPage.this.setHeaderFileFullPath(headerPath, false);
                        NewClassCreationWizardPage.this.setSourceFileFullPath(sourcePath, false);
                        NewClassCreationWizardPage.this.setTestFileFullPath(testPath, false);
                    }
                }
                NewClassCreationWizardPage.this.setNamespaceText(ns.getQualifiedTypeName().toString(), false);
                NewClassCreationWizardPage.this.handleFieldChanged(changedFields);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewClassCreationWizardPage.this.updateNamespaceEnableState();
            NewClassCreationWizardPage.this.handleFieldChanged(6);
        }
    }

    private final class SourceFolderFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceFolderFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            IPath oldFolderPath = NewClassCreationWizardPage.this.getSourceFolderFullPath();
            IPath newFolderPath = NewClassCreationWizardPage.this.chooseSourceFolder(oldFolderPath);
            if (newFolderPath != null) {
                NewClassCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                NewClassCreationWizardPage.this.handleFieldChanged(255);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewClassCreationWizardPage.this.handleFieldChanged(255);
        }
    }

    private final class StatusFocusListener
    implements FocusListener {
        private int fieldID;

        public StatusFocusListener(int fieldID) {
            this.fieldID = fieldID;
        }

        public void focusGained(FocusEvent e) {
            if (NewClassCreationWizardPage.this.fLastFocusedField != this.fieldID) {
                NewClassCreationWizardPage.this.fLastFocusedField = this.fieldID;
                if (NewClassCreationWizardPage.this.isFirstTime) {
                    NewClassCreationWizardPage.this.isFirstTime = false;
                    return;
                }
                NewClassCreationWizardPage.this.doStatusUpdate();
            }
        }

        public void focusLost(FocusEvent e) {
            if (NewClassCreationWizardPage.this.fLastFocusedField != 0) {
                NewClassCreationWizardPage.this.fLastFocusedField = 0;
                NewClassCreationWizardPage.this.doStatusUpdate();
            }
        }
    }
}

