/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.core.SyncUtils;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceSyncFileFilterStorage
extends AbstractSyncFileFilter {
    private static final String PATTERN_NODE_NAME = "pattern";
    private static final String NUM_PATTERNS_KEY = "num-patterns";
    private static final String ATTR_RULE = "rule";

    public PreferenceSyncFileFilterStorage() {
    }

    public PreferenceSyncFileFilterStorage(PreferenceSyncFileFilterStorage filter) {
        this.rules.addAll(filter.rules);
    }

    public void loadBuiltInDefaultFilter() {
        for (String pattern : Arrays.asList("/.project", "/.cproject", "/.settings/", "coredir.[0-9]*/", "core", "!core/", "core.[0-9]*", "!core.[0-9]*/", "CVS/")) {
            this.addPattern(pattern, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFilter() {
        this.rules.clear();
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return false;
        }
        try {
            if (!node.nodeExists(PATTERN_NODE_NAME)) {
                return false;
            }
            Preferences prefPatternNode = node.node(PATTERN_NODE_NAME);
            int numPatterns = prefPatternNode.getInt(NUM_PATTERNS_KEY, -1);
            if (numPatterns == -1) {
                RDTSyncCorePlugin.log(Messages.SyncFileFilter_1);
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= numPatterns) {
                    return true;
                }
                if (!prefPatternNode.nodeExists(Integer.toString(i))) {
                    RDTSyncCorePlugin.log(Messages.SyncFileFilter_1);
                    this.rules.clear();
                    return false;
                }
                Preferences prefMatcherNode = prefPatternNode.node(Integer.toString(i));
                String p = prefMatcherNode.get(ATTR_RULE, null);
                if (p == null) {
                    this.rules.clear();
                    throw new NoSuchElementException(Messages.PathResourceMatcher_0);
                }
                this.rules.add(new PreferenceIgnoreRule(p));
                ++i;
            }
        }
        catch (BackingStoreException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_1, e);
            return false;
        }
    }

    @Override
    public void saveFilter() {
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences prefRootNode = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (prefRootNode == null) {
            RDTSyncCorePlugin.log(Messages.SyncManager_6);
            return;
        }
        try {
            prefRootNode.node(PATTERN_NODE_NAME).removeNode();
            prefRootNode.flush();
        }
        catch (BackingStoreException e) {
            RDTSyncCorePlugin.log(Messages.SyncFileFilter_2, e);
            return;
        }
        Preferences prefPatternNode = prefRootNode.node(PATTERN_NODE_NAME);
        prefPatternNode.putInt(NUM_PATTERNS_KEY, this.rules.size());
        int i = 0;
        while (i < this.rules.size()) {
            Preferences prefRuleNode = prefPatternNode.node(Integer.toString(i));
            prefRuleNode.put(ATTR_RULE, ((AbstractSyncFileFilter.AbstractIgnoreRule)this.rules.get(i)).toString());
            ++i;
        }
        SyncUtils.flushNode((Preferences)prefRootNode);
    }

    @Override
    public void addPattern(String pattern, boolean exclude, int index) {
        this.rules.add(index, new PreferenceIgnoreRule(pattern, exclude));
    }

    @Override
    public void addPattern(IResource resource, boolean exclude, int index) {
        this.rules.add(index, new PreferenceIgnoreRule(resource.getProjectRelativePath().toString(), exclude));
    }

    @Override
    public AbstractSyncFileFilter clone() {
        return new PreferenceSyncFileFilterStorage(this);
    }

    private class PreferenceIgnoreRule
    extends AbstractSyncFileFilter.AbstractIgnoreRule {
        String pattern;
        boolean exclude;

        PreferenceIgnoreRule(String p, boolean e) {
            super(PreferenceSyncFileFilterStorage.this);
            this.pattern = p;
            this.exclude = e;
        }

        PreferenceIgnoreRule(String r) {
            super(PreferenceSyncFileFilterStorage.this);
            this.pattern = r.substring(1);
            this.exclude = r.charAt(0) == '-';
        }

        @Override
        public boolean isMatch(IResource target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMatch(String target, boolean isFolder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getResult() {
            return this.exclude;
        }

        @Override
        public String toString() {
            return String.valueOf(this.exclude ? "-" : "+") + this.pattern;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }
    }
}

